/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.worker;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.BrowserVersion;
import org.htmlunit.WebClient;
import org.htmlunit.WebRequest;
import org.htmlunit.WebResponse;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.ContextAction;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.RecursiveFunctionObject;
import org.htmlunit.javascript.configuration.ClassConfiguration;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.WorkerJavaScriptConfiguration;
import org.htmlunit.javascript.host.PermissionStatus;
import org.htmlunit.javascript.host.Permissions;
import org.htmlunit.javascript.host.PushManager;
import org.htmlunit.javascript.host.PushSubscription;
import org.htmlunit.javascript.host.PushSubscriptionOptions;
import org.htmlunit.javascript.host.Window;
import org.htmlunit.javascript.host.WindowOrWorkerGlobalScopeMixin;
import org.htmlunit.javascript.host.event.MessageEvent;
import org.htmlunit.javascript.host.event.SecurityPolicyViolationEvent;
import org.htmlunit.javascript.host.media.MediaSource;
import org.htmlunit.javascript.host.media.SourceBuffer;
import org.htmlunit.javascript.host.media.SourceBufferList;
import org.htmlunit.javascript.host.worker.ServiceWorkerRegistration;
import org.htmlunit.javascript.host.worker.Worker;
import org.htmlunit.javascript.host.worker.WorkerGlobalScope;
import org.htmlunit.javascript.host.worker.WorkerJob;
import org.htmlunit.javascript.host.worker.WorkerLocation;
import org.htmlunit.javascript.host.worker.WorkerNavigator;
import org.htmlunit.util.MimeType;

@JsxClass
public class DedicatedWorkerGlobalScope
extends WorkerGlobalScope {
    private static final Log LOG = LogFactory.getLog(DedicatedWorkerGlobalScope.class);
    private static final Method GETTER_NAME;
    private static final Method SETTER_NAME;
    private Map<Class<? extends Scriptable>, Scriptable> prototypes_ = new HashMap<Class<? extends Scriptable>, Scriptable>();
    private final Window owningWindow_;
    private final String origin_;
    private String name_;
    private final Worker worker_;
    private WorkerLocation workerLocation_;
    private WorkerNavigator workerNavigator_;

    public DedicatedWorkerGlobalScope() {
        this.owningWindow_ = null;
        this.origin_ = null;
        this.name_ = null;
        this.worker_ = null;
        this.workerLocation_ = null;
    }

    @Override
    @JsxConstructor
    public void jsConstructor() {
    }

    DedicatedWorkerGlobalScope(Window owningWindow, Context context, WebClient webClient, String name, Worker worker) throws Exception {
        BrowserVersion browserVersion = webClient.getBrowserVersion();
        context.initSafeStandardObjects((ScriptableObject)this);
        JavaScriptEngine.configureRhino(webClient, browserVersion, this);
        WorkerJavaScriptConfiguration jsConfig = WorkerJavaScriptConfiguration.getInstance(browserVersion);
        ClassConfiguration config = jsConfig.getClassConfiguration(DedicatedWorkerGlobalScope.class.getSuperclass().getSimpleName());
        HtmlUnitScriptable parentPrototype = JavaScriptEngine.configureClass(config, (Scriptable)this);
        config = jsConfig.getClassConfiguration(DedicatedWorkerGlobalScope.class.getSimpleName());
        HtmlUnitScriptable prototype = JavaScriptEngine.configureClass(config, (Scriptable)this);
        prototype.setPrototype((Scriptable)parentPrototype);
        this.setPrototype((Scriptable)prototype);
        HashMap<Class<? extends Scriptable>, Scriptable> prototypes = new HashMap<Class<? extends Scriptable>, Scriptable>();
        HashMap<String, Scriptable> prototypesPerJSName = new HashMap<String, Scriptable>();
        prototypes.put((Class<? extends Scriptable>)config.getHostClass(), (Scriptable)prototype);
        prototypesPerJSName.put(config.getClassName(), (Scriptable)prototype);
        RecursiveFunctionObject functionObject = new RecursiveFunctionObject(DedicatedWorkerGlobalScope.class.getSimpleName(), config.getJsConstructor().getValue(), (Scriptable)this, browserVersion);
        functionObject.addAsConstructor((Scriptable)this, (Scriptable)prototype, 2);
        JavaScriptEngine.configureScope(this, config, functionObject, jsConfig, browserVersion, prototypes, prototypesPerJSName);
        this.delete("webkitURL");
        this.delete("WebKitCSSMatrix");
        if (browserVersion.isFirefox()) {
            this.delete(MediaSource.class.getSimpleName());
            this.delete(SecurityPolicyViolationEvent.class.getSimpleName());
            this.delete(SourceBuffer.class.getSimpleName());
            this.delete(SourceBufferList.class.getSimpleName());
        }
        if (browserVersion.isFirefoxESR()) {
            this.delete(Permissions.class.getSimpleName());
            this.delete(PermissionStatus.class.getSimpleName());
            this.delete(PushManager.class.getSimpleName());
            this.delete(PushSubscription.class.getSimpleName());
            this.delete(PushSubscriptionOptions.class.getSimpleName());
            this.delete(ServiceWorkerRegistration.class.getSimpleName());
        }
        if (!webClient.getOptions().isWebSocketEnabled()) {
            this.delete("WebSocket");
        }
        this.setPrototypes(prototypes);
        this.owningWindow_ = owningWindow;
        URL currentURL = owningWindow.getWebWindow().getEnclosedPage().getUrl();
        this.origin_ = currentURL.getProtocol() + "://" + currentURL.getHost() + ":" + currentURL.getPort();
        this.name_ = name;
        this.defineProperty("name", null, GETTER_NAME, SETTER_NAME, 1);
        this.worker_ = worker;
        this.workerLocation_ = null;
    }

    @JsxGetter
    public Object getSelf() {
        return this;
    }

    @JsxGetter
    public Function getOnmessage() {
        return this.getEventHandler("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setEventHandler("message", onmessage);
    }

    @JsxGetter
    public WorkerLocation getLocation() {
        return this.workerLocation_;
    }

    @JsxGetter
    public WorkerNavigator getNavigator() {
        return this.workerNavigator_;
    }

    public String jsGetName() {
        return this.name_;
    }

    public void jsSetName(Scriptable name) {
        this.name_ = JavaScriptEngine.toString(name);
    }

    @JsxFunction
    public void postMessage(Object message) {
        MessageEvent event = new MessageEvent();
        event.initMessageEvent("message", false, false, message, this.origin_, "", this.owningWindow_, JavaScriptEngine.UNDEFINED);
        event.setParentScope((Scriptable)this.owningWindow_);
        event.setPrototype(this.owningWindow_.getPrototype(event.getClass()));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("[DedicatedWorker] postMessage: {}" + String.valueOf(message)));
        }
        JavaScriptEngine jsEngine = (JavaScriptEngine)this.owningWindow_.getWebWindow().getWebClient().getJavaScriptEngine();
        ContextAction action = cx -> {
            this.worker_.getEventListenersContainer().executeCapturingListeners(event, null);
            Object[] args = new Object[]{event};
            this.worker_.getEventListenersContainer().executeBubblingListeners(event, args);
            return null;
        };
        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
        WorkerJob job = new WorkerJob(cf, (ContextAction<Object>)action, "postMessage: " + JavaScriptEngine.toString(message));
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
    }

    void messagePosted(Object message) {
        MessageEvent event = new MessageEvent();
        event.initMessageEvent("message", false, false, message, this.origin_, "", this.owningWindow_, JavaScriptEngine.UNDEFINED);
        event.setParentScope((Scriptable)this.owningWindow_);
        event.setPrototype(this.owningWindow_.getPrototype(event.getClass()));
        JavaScriptEngine jsEngine = (JavaScriptEngine)this.owningWindow_.getWebWindow().getWebClient().getJavaScriptEngine();
        ContextAction action = cx -> {
            this.executeEvent(cx, event);
            return null;
        };
        HtmlUnitContextFactory cf = jsEngine.getContextFactory();
        WorkerJob job = new WorkerJob(cf, (ContextAction<Object>)action, "messagePosted: " + JavaScriptEngine.toString(message));
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
    }

    void executeEvent(Context cx, MessageEvent event) {
        Function handlerFunction;
        List<Scriptable> handlers = this.getEventListenersContainer().getListeners("message", false);
        if (handlers != null) {
            Object[] args = new Object[]{event};
            for (Scriptable scriptable : handlers) {
                if (!(scriptable instanceof Function)) continue;
                Function handlerFunction2 = (Function)scriptable;
                handlerFunction2.call(cx, (Scriptable)this, (Scriptable)this, args);
            }
        }
        if ((handlerFunction = this.getEventHandler("message")) != null) {
            Object[] args = new Object[]{event};
            handlerFunction.call(cx, (Scriptable)this, (Scriptable)this, args);
        }
    }

    @JsxFunction
    public static void importScripts(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        DedicatedWorkerGlobalScope workerScope = (DedicatedWorkerGlobalScope)thisObj;
        WebClient webClient = workerScope.owningWindow_.getWebWindow().getWebClient();
        for (Object arg : args) {
            String url = JavaScriptEngine.toString(arg);
            workerScope.loadAndExecute(webClient, url, cx, true);
        }
    }

    void loadAndExecute(WebClient webClient, String url, Context context, boolean checkMimeType) throws IOException {
        HtmlPage page = (HtmlPage)this.owningWindow_.getDocument().getPage();
        URL fullUrl = page.getFullyQualifiedUrl(url);
        this.workerLocation_ = new WorkerLocation(fullUrl, this.origin_);
        this.workerLocation_.setParentScope((Scriptable)this);
        this.workerLocation_.setPrototype(this.getPrototype(this.workerLocation_.getClass()));
        this.workerNavigator_ = new WorkerNavigator(webClient.getBrowserVersion());
        this.workerNavigator_.setParentScope((Scriptable)this);
        this.workerNavigator_.setPrototype(this.getPrototype(this.workerNavigator_.getClass()));
        WebRequest webRequest = new WebRequest(fullUrl);
        WebResponse response = webClient.loadWebResponse(webRequest);
        if (checkMimeType && !MimeType.isJavascriptMimeType(response.getContentType())) {
            throw JavaScriptEngine.reportRuntimeError("NetworkError: importScripts response is not a javascript response");
        }
        String scriptCode = response.getContentAsString();
        AbstractJavaScriptEngine<?> javaScriptEngine = webClient.getJavaScriptEngine();
        DedicatedWorkerGlobalScope thisScope = this;
        ContextAction action = cx -> javaScriptEngine.execute(page, (Scriptable)thisScope, scriptCode, fullUrl.toExternalForm(), 1);
        HtmlUnitContextFactory cf = javaScriptEngine.getContextFactory();
        if (context != null) {
            action.run(context);
        } else {
            WorkerJob job = new WorkerJob(cf, (ContextAction<Object>)action, "loadAndExecute " + url);
            this.owningWindow_.getWebWindow().getJobManager().addJob(job, page);
        }
    }

    @JsxFunction
    public static Object setTimeout(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        return WindowOrWorkerGlobalScopeMixin.setTimeout(context, (Scriptable)((DedicatedWorkerGlobalScope)thisObj).owningWindow_, args, function);
    }

    @JsxFunction
    public static Object setInterval(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        return WindowOrWorkerGlobalScopeMixin.setInterval(context, (Scriptable)((DedicatedWorkerGlobalScope)thisObj).owningWindow_, args, function);
    }

    @Override
    public Scriptable getPrototype(Class<? extends HtmlUnitScriptable> jsClass) {
        return this.prototypes_.get(jsClass);
    }

    public void setPrototypes(Map<Class<? extends Scriptable>, Scriptable> map) {
        this.prototypes_ = map;
    }

    static {
        try {
            GETTER_NAME = DedicatedWorkerGlobalScope.class.getDeclaredMethod("jsGetName", new Class[0]);
            SETTER_NAME = DedicatedWorkerGlobalScope.class.getDeclaredMethod("jsSetName", Scriptable.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

