/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.htmlunit.SgmlPage;
import org.htmlunit.WebAssert;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.ElementFactory;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.html.HTMLOptionElement;
import org.htmlunit.javascript.host.html.HTMLSelectElement;

@JsxClass
public class HTMLOptionsCollection
extends HtmlUnitScriptable {
    private HtmlSelect htmlSelect_;

    public HTMLOptionsCollection() {
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    public HTMLOptionsCollection(HtmlUnitScriptable parentScope) {
        this.setParentScope((Scriptable)parentScope);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    public void initialize(HtmlSelect select) {
        WebAssert.notNull("select", select);
        this.htmlSelect_ = select;
    }

    public Object get(int index, Scriptable start) {
        if (this.htmlSelect_ == null || index < 0) {
            return JavaScriptEngine.UNDEFINED;
        }
        if (index >= this.htmlSelect_.getOptionSize()) {
            return JavaScriptEngine.UNDEFINED;
        }
        return this.getScriptableFor(this.htmlSelect_.getOption(index));
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (this.htmlSelect_ == null) {
            super.put(name, start, value);
            return;
        }
        HTMLSelectElement parent = (HTMLSelectElement)this.htmlSelect_.getScriptableObject();
        if (!this.has(name, start) && ScriptableObject.hasProperty((Scriptable)parent, (String)name)) {
            ScriptableObject.putProperty((Scriptable)parent, (String)name, (Object)value);
        } else {
            super.put(name, start, value);
        }
    }

    @JsxFunction
    public Object item(int index) {
        Object item = this.get(index, (Scriptable)this);
        if (JavaScriptEngine.UNDEFINED == item) {
            return null;
        }
        return item;
    }

    public void put(int index, Scriptable start, Object newValue) {
        if (newValue == null) {
            this.htmlSelect_.removeOption(index);
        } else {
            HTMLOptionElement option = (HTMLOptionElement)newValue;
            HtmlOption htmlOption = (HtmlOption)option.getDomNodeOrNull();
            if (index >= this.getLength()) {
                this.setLength(index);
                this.htmlSelect_.appendOption(htmlOption);
            } else {
                this.htmlSelect_.replaceOption(index, htmlOption);
            }
        }
    }

    @JsxGetter
    public int getLength() {
        return this.htmlSelect_.getOptionSize();
    }

    @JsxSetter
    public void setLength(int newLength) {
        if (newLength < 0) {
            return;
        }
        int currentLength = this.htmlSelect_.getOptionSize();
        if (currentLength > newLength) {
            this.htmlSelect_.setOptionSize(newLength);
        } else {
            SgmlPage page = this.htmlSelect_.getPage();
            ElementFactory factory = page.getWebClient().getPageCreator().getHtmlParser().getFactory("option");
            for (int i = currentLength; i < newLength; ++i) {
                HtmlOption option = (HtmlOption)factory.createElement(page, "option", null);
                this.htmlSelect_.appendOption(option);
            }
        }
    }

    @JsxFunction
    public void add(Object newOptionObject, Object beforeOptionObject) {
        HtmlOption htmlOption = (HtmlOption)((HTMLOptionElement)newOptionObject).getDomNodeOrNull();
        HtmlOption beforeOption = null;
        if (beforeOptionObject instanceof Number) {
            int index = (Integer)Context.jsToJava((Object)beforeOptionObject, Integer.class);
            if (index < 0 || index >= this.getLength()) {
                this.htmlSelect_.appendOption(htmlOption);
                return;
            }
            beforeOption = (HtmlOption)((HTMLOptionElement)this.item(index)).getDomNodeOrDie();
        } else if (beforeOptionObject instanceof HTMLOptionElement && (beforeOption = (HtmlOption)((HTMLOptionElement)beforeOptionObject).getDomNodeOrDie()).getParentNode() != this.htmlSelect_) {
            throw JavaScriptEngine.asJavaScriptException(this.getWindow(), "Unknown option.", 8);
        }
        if (null == beforeOption) {
            this.htmlSelect_.appendOption(htmlOption);
            return;
        }
        beforeOption.insertBefore(htmlOption);
    }

    @JsxFunction
    public void remove(int index) {
        int idx = index;
        if (idx < 0) {
            return;
        }
        if ((idx = Math.max(idx, 0)) >= this.getLength()) {
            return;
        }
        this.htmlSelect_.removeOption(idx);
    }

    @JsxGetter
    public int getSelectedIndex() {
        return this.htmlSelect_.getSelectedIndex();
    }

    @JsxSetter
    public void setSelectedIndex(int index) {
        this.htmlSelect_.setSelectedIndex(index);
    }

    @JsxSymbol
    public Scriptable iterator() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), (Scriptable)this);
    }
}

