/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.FormEncodingType;
import org.htmlunit.WebAssert;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.FormFieldWithNameHistory;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.SubmittableElement;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.dom.AbstractList;
import org.htmlunit.javascript.host.dom.DOMTokenList;
import org.htmlunit.javascript.host.dom.RadioNodeList;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.html.HTMLButtonElement;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.html.HTMLFormControlsCollection;
import org.htmlunit.javascript.host.html.HTMLInputElement;

@JsxClass(domClass=HtmlForm.class)
public class HTMLFormElement
extends HTMLElement
implements Function {
    @Override
    @JsxConstructor
    public void jsConstructor() {
        super.jsConstructor();
    }

    @Override
    @JsxGetter
    public String getName() {
        return this.getHtmlForm().getNameAttribute();
    }

    @Override
    @JsxSetter
    public void setName(String name) {
        this.getHtmlForm().setNameAttribute(name);
    }

    @JsxGetter
    public HTMLFormControlsCollection getElements() {
        HtmlForm htmlForm = this.getHtmlForm();
        HTMLFormControlsCollection elements = new HTMLFormControlsCollection(htmlForm, false){

            @Override
            protected Object getWithPreemption(String name) {
                return HTMLFormElement.this.getWithPreemption(name);
            }
        };
        elements.setElementsSupplier((Supplier<List> & Serializable)() -> {
            HtmlElement domNode = this.getDomNodeOrNull();
            if (domNode == null) {
                return new ArrayList();
            }
            return new ArrayList<HtmlElement>(((HtmlForm)domNode).getElementsJS());
        });
        elements.setEffectOnCacheFunction((java.util.function.Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> AbstractList.EffectOnCache.NONE);
        return elements;
    }

    @JsxSymbol
    public Scriptable iterator() {
        return this.getElements().iterator();
    }

    @JsxGetter
    public int getLength() {
        return this.getElements().getLength();
    }

    @JsxGetter
    public String getAction() {
        String action = this.getHtmlForm().getActionAttribute();
        try {
            return ((HtmlPage)this.getHtmlForm().getPage()).getFullyQualifiedUrl(action).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            return action;
        }
    }

    @JsxSetter
    public void setAction(String action) {
        WebAssert.notNull("action", action);
        this.getHtmlForm().setActionAttribute(action);
    }

    @JsxGetter
    public String getMethod() {
        return this.getHtmlForm().getMethodAttribute();
    }

    @JsxSetter
    public void setMethod(String method) {
        WebAssert.notNull("method", method);
        this.getHtmlForm().setMethodAttribute(method);
    }

    @JsxGetter
    public String getTarget() {
        return this.getHtmlForm().getTargetAttribute();
    }

    @JsxSetter
    public void setTarget(String target) {
        WebAssert.notNull("target", target);
        this.getHtmlForm().setTargetAttribute(target);
    }

    @JsxGetter
    public String getRel() {
        return this.getHtmlForm().getRelAttribute();
    }

    @JsxSetter
    public void setRel(String rel) {
        this.getHtmlForm().setAttribute("rel", rel);
    }

    @JsxGetter
    public DOMTokenList getRelList() {
        return new DOMTokenList(this, "rel");
    }

    @JsxSetter
    public void setRelList(Object rel) {
        if (JavaScriptEngine.isUndefined(rel)) {
            this.setRel("undefined");
            return;
        }
        this.setRel(JavaScriptEngine.toString(rel));
    }

    @JsxGetter
    public String getEnctype() {
        String encoding = this.getHtmlForm().getEnctypeAttribute();
        if (!(FormEncodingType.URL_ENCODED.getName().equals(encoding) || FormEncodingType.MULTIPART.getName().equals(encoding) || "text/plain".equals(encoding))) {
            return FormEncodingType.URL_ENCODED.getName();
        }
        return encoding;
    }

    @JsxSetter
    public void setEnctype(String enctype) {
        WebAssert.notNull("encoding", enctype);
        this.getHtmlForm().setEnctypeAttribute(enctype);
    }

    @JsxGetter
    public String getEncoding() {
        return this.getEnctype();
    }

    @JsxSetter
    public void setEncoding(String encoding) {
        this.setEnctype(encoding);
    }

    public HtmlForm getHtmlForm() {
        return (HtmlForm)this.getDomNodeOrDie();
    }

    @JsxFunction
    public void submit() {
        this.getHtmlForm().submit(null);
    }

    @JsxFunction
    public void requestSubmit(Object submitter) {
        if (JavaScriptEngine.isUndefined(submitter)) {
            this.submit();
            return;
        }
        SubmittableElement submittable = null;
        if (submitter instanceof HTMLElement) {
            HTMLElement subHtmlElement = (HTMLElement)submitter;
            if (subHtmlElement instanceof HTMLButtonElement) {
                if ("submit".equals(((HTMLButtonElement)subHtmlElement).getType())) {
                    submittable = (SubmittableElement)((Object)subHtmlElement.getDomNodeOrDie());
                }
            } else if (subHtmlElement instanceof HTMLInputElement && "submit".equals(((HTMLInputElement)subHtmlElement).getType())) {
                submittable = (SubmittableElement)((Object)subHtmlElement.getDomNodeOrDie());
            }
            if (submittable != null && subHtmlElement.getForm() != this) {
                throw JavaScriptEngine.typeError("Failed to execute 'requestSubmit' on 'HTMLFormElement': The specified element is not owned by this form element.");
            }
        }
        if (submittable == null) {
            throw JavaScriptEngine.typeError("Failed to execute 'requestSubmit' on 'HTMLFormElement': The specified element is not a submit button.");
        }
        this.getHtmlForm().submit(submittable);
    }

    @JsxFunction
    public void reset() {
        this.getHtmlForm().reset();
    }

    @Override
    protected Object getWithPreemption(String name) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        List<HtmlElement> elements = this.findElements(name);
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            return this.getScriptableFor(elements.get(0));
        }
        ArrayList<DomNode> nodes = new ArrayList<DomNode>(elements);
        RadioNodeList nodeList = new RadioNodeList((DomNode)this.getHtmlForm(), nodes);
        nodeList.setElementsSupplier((Supplier<List> & Serializable)() -> new ArrayList<HtmlElement>(this.findElements(name)));
        return nodeList;
    }

    public boolean has(String name, Scriptable start) {
        if (super.has(name, start)) {
            return true;
        }
        return this.findFirstElement(name) != null;
    }

    protected ScriptableObject getOwnPropertyDescriptor(Context cx, Object id) {
        HtmlElement element;
        ScriptableObject desc = super.getOwnPropertyDescriptor(cx, id);
        if (desc != null) {
            return desc;
        }
        if (id instanceof CharSequence && (element = this.findFirstElement(id.toString())) != null) {
            return ScriptableObject.buildDataDescriptor((Scriptable)this, element.getScriptableObject(), (int)3);
        }
        return null;
    }

    List<HtmlElement> findElements(String name) {
        ArrayList<HtmlElement> elements = new ArrayList<HtmlElement>();
        HtmlForm form = (HtmlForm)this.getDomNodeOrNull();
        if (form == null) {
            return elements;
        }
        for (HtmlElement htmlElement : form.getElementsJS()) {
            if (!HTMLFormElement.isAccessibleByIdOrName(htmlElement, name)) continue;
            elements.add(htmlElement);
        }
        if (elements.isEmpty()) {
            for (DomNode domNode : form.getHtmlElementDescendants()) {
                HtmlImage img;
                if (!(domNode instanceof HtmlImage) || !name.equals((img = (HtmlImage)domNode).getId()) && !name.equals(img.getNameAttribute())) continue;
                elements.add(img);
            }
        }
        return elements;
    }

    private HtmlElement findFirstElement(String name) {
        HtmlForm form = (HtmlForm)this.getDomNodeOrNull();
        if (form == null) {
            return null;
        }
        for (DomNode node : form.getElementsJS()) {
            if (!HTMLFormElement.isAccessibleByIdOrName(node, name)) continue;
            return node;
        }
        for (DomNode node : form.getHtmlElementDescendants()) {
            HtmlImage img;
            if (!(node instanceof HtmlImage) || !name.equals((img = (HtmlImage)node).getId()) && !name.equals(img.getNameAttribute())) continue;
            return img;
        }
        return null;
    }

    private static boolean isAccessibleByIdOrName(HtmlElement element, String name) {
        if (name.equals(element.getId())) {
            return true;
        }
        if (name.equals(element.getAttributeDirect("name"))) {
            return true;
        }
        if (element instanceof FormFieldWithNameHistory) {
            FormFieldWithNameHistory elementWithNames = (FormFieldWithNameHistory)((Object)element);
            if (name.equals(elementWithNames.getOriginalName())) {
                return true;
            }
            if (elementWithNames.getNewNames().contains(name)) {
                return true;
            }
        }
        return false;
    }

    public Object get(int index, Scriptable start) {
        if (this.getDomNodeOrNull() == null) {
            return NOT_FOUND;
        }
        return this.getElements().get(index, (Scriptable)((HTMLFormElement)start).getElements());
    }

    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        throw JavaScriptEngine.typeError("Not a function.");
    }

    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw JavaScriptEngine.typeError("Not a function.");
    }

    @Override
    public boolean dispatchEvent(Event event) {
        boolean result = super.dispatchEvent(event);
        if ("submit".equals(event.getType()) && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_FORM_DISPATCHEVENT_SUBMITS)) {
            this.submit();
        }
        return result;
    }

    @JsxFunction
    public boolean checkValidity() {
        return this.getDomNodeOrDie().isValid();
    }

    @JsxGetter
    public boolean isNoValidate() {
        return this.getHtmlForm().isNoValidate();
    }

    @JsxSetter
    public void setNoValidate(boolean value) {
        this.getHtmlForm().setNoValidate(value);
    }
}

