/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.draganddrop;

import java.io.File;
import java.util.ArrayList;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Function;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSymbol;
import org.htmlunit.javascript.host.draganddrop.DataTransferItem;
import org.htmlunit.javascript.host.file.FileList;

@JsxClass
public class DataTransferItemList
extends HtmlUnitScriptable {
    private ArrayList<DataTransferItem> items_;
    private FileList fileList_;

    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxGetter
    public int getLength() {
        if (this.items_ == null) {
            return 0;
        }
        return this.items_.size();
    }

    @JsxFunction
    public static DataTransferItem add(Context context, Scriptable scope, Scriptable thisObj, Object[] args, Function function) {
        DataTransferItemList itemList = (DataTransferItemList)thisObj;
        if (args.length == 1) {
            if (args[0] instanceof org.htmlunit.javascript.host.file.File) {
                DataTransferItem item = DataTransferItem.buildFileItem((org.htmlunit.javascript.host.file.File)args[0]);
                item.setParentScope(itemList.getParentScope());
                item.setPrototype(itemList.getPrototype(item.getClass()));
                if (itemList.items_ == null) {
                    itemList.items_ = new ArrayList();
                }
                itemList.items_.add(item);
                itemList.updateFileList();
                return item;
            }
            throw JavaScriptEngine.typeError("Failed to execute 'add' on 'DataTransferItemList': parameter 1 is not of type 'File'.");
        }
        if (args.length > 1) {
            String data = JavaScriptEngine.toString(args[0]);
            String type = JavaScriptEngine.toString(args[1]);
            DataTransferItem item = DataTransferItem.buildStringItem(data, type);
            item.setParentScope(itemList.getParentScope());
            item.setPrototype(itemList.getPrototype(item.getClass()));
            if (itemList.items_ == null) {
                itemList.items_ = new ArrayList();
            }
            itemList.items_.add(item);
            return item;
        }
        throw JavaScriptEngine.typeError("Failed to execute 'add' on 'DataTransferItemList' - no args provided.");
    }

    @JsxFunction
    public void clear() {
        if (this.items_ != null) {
            this.items_.clear();
            if (this.fileList_ != null) {
                this.fileList_.updateFiles(new ArrayList<org.htmlunit.javascript.host.file.File>());
            }
        }
    }

    @JsxFunction
    public void remove(int index) {
        if (this.items_ != null && index >= 0 && index < this.items_.size()) {
            this.items_.remove(index);
            this.updateFileList();
        }
    }

    public Object get(int index, Scriptable start) {
        if (this == start && index >= 0 && index < this.items_.size()) {
            return this.items_.get(index);
        }
        return super.get(index, start);
    }

    @JsxSymbol(symbolName="iterator")
    public Scriptable values() {
        return JavaScriptEngine.newArrayIteratorTypeValues(this.getParentScope(), (Scriptable)this);
    }

    public FileList getFiles() {
        if (this.fileList_ == null) {
            FileList list = new FileList(new File[0]);
            list.setParentScope(this.getParentScope());
            list.setPrototype(this.getPrototype(list.getClass()));
            this.fileList_ = list;
            if (this.items_ != null) {
                this.updateFileList();
            }
        }
        return this.fileList_;
    }

    private void updateFileList() {
        if (this.fileList_ != null) {
            ArrayList<org.htmlunit.javascript.host.file.File> files = new ArrayList<org.htmlunit.javascript.host.file.File>();
            for (DataTransferItem item : this.items_) {
                if (!item.isFile()) continue;
                files.add(item.getAsFile());
            }
            this.fileList_.updateFiles(files);
        }
    }
}

