/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.draganddrop;

import org.htmlunit.WebWindow;
import org.htmlunit.corejs.javascript.Callable;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.host.file.File;

@JsxClass
public class DataTransferItem
extends HtmlUnitScriptable {
    private static final String KIND_STRING = "string";
    private static final String KIND_FILE = "file";
    private final String kind_;
    private final String type_;
    private Object data_;

    public DataTransferItem() {
        this(null, null, null);
    }

    private DataTransferItem(String kind, String type, Object data) {
        this.kind_ = kind;
        this.type_ = type;
        this.data_ = data;
    }

    public static DataTransferItem buildStringItem(CharSequence data, String type) {
        return new DataTransferItem(KIND_STRING, type, data);
    }

    public static DataTransferItem buildFileItem(File file) {
        return new DataTransferItem(KIND_FILE, file.getType(), file);
    }

    @JsxConstructor
    public void jsConstructor() {
    }

    @JsxGetter
    public String getKind() {
        return this.kind_;
    }

    @JsxGetter
    public String getType() {
        return this.type_;
    }

    @JsxFunction
    public void getAsString(Object callback) {
        if (!(callback instanceof Callable)) {
            throw JavaScriptEngine.typeError("getAsString callback '" + JavaScriptEngine.toString(callback) + "' is not a function");
        }
        if (this.isFile()) {
            return;
        }
        final Callable fun = (Callable)callback;
        final Object[] args = new Object[]{this.data_};
        WebWindow webWindow = this.getWindow().getWebWindow();
        PostponedAction action = new PostponedAction(webWindow.getEnclosedPage(), "getAsString callback"){

            @Override
            public void execute() {
                fun.call(Context.getCurrentContext(), DataTransferItem.this.getParentScope(), (Scriptable)DataTransferItem.this, args);
            }
        };
        AbstractJavaScriptEngine<?> engine = webWindow.getWebClient().getJavaScriptEngine();
        engine.addPostponedAction(action);
    }

    @JsxFunction
    public File getAsFile() {
        if (!this.isFile()) {
            return null;
        }
        return (File)this.data_;
    }

    public boolean isFile() {
        return this.kind_ == KIND_FILE;
    }
}

