/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.AlertHandler;
import org.htmlunit.BrowserVersion;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.ConfirmHandler;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.Page;
import org.htmlunit.PrintHandler;
import org.htmlunit.PromptHandler;
import org.htmlunit.ScriptException;
import org.htmlunit.ScriptResult;
import org.htmlunit.SgmlPage;
import org.htmlunit.StatusHandler;
import org.htmlunit.StorageHolder;
import org.htmlunit.TopLevelWindow;
import org.htmlunit.WebAssert;
import org.htmlunit.WebClient;
import org.htmlunit.WebConsole;
import org.htmlunit.WebWindow;
import org.htmlunit.WebWindowNotFoundException;
import org.htmlunit.corejs.javascript.AccessorSlot;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.EcmaError;
import org.htmlunit.corejs.javascript.JavaScriptException;
import org.htmlunit.corejs.javascript.NativeConsole;
import org.htmlunit.corejs.javascript.NativeObject;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.corejs.javascript.Slot;
import org.htmlunit.css.ComputedCssStyleDeclaration;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.FrameWindow;
import org.htmlunit.html.HtmlAnchor;
import org.htmlunit.html.HtmlAttributeChangeEvent;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlEmbed;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlImage;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlMap;
import org.htmlunit.html.HtmlObject;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.javascript.AbstractJavaScriptEngine;
import org.htmlunit.javascript.HtmlUnitContextFactory;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.PostponedAction;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstant;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.Element;
import org.htmlunit.javascript.host.External;
import org.htmlunit.javascript.host.HTMLCollectionFrames;
import org.htmlunit.javascript.host.History;
import org.htmlunit.javascript.host.Location;
import org.htmlunit.javascript.host.Navigator;
import org.htmlunit.javascript.host.Netscape;
import org.htmlunit.javascript.host.Screen;
import org.htmlunit.javascript.host.Storage;
import org.htmlunit.javascript.host.WindowOrWorkerGlobalScope;
import org.htmlunit.javascript.host.WindowOrWorkerGlobalScopeMixin;
import org.htmlunit.javascript.host.WindowProxy;
import org.htmlunit.javascript.host.crypto.Crypto;
import org.htmlunit.javascript.host.css.ComputedCSSStyleDeclaration;
import org.htmlunit.javascript.host.css.MediaQueryList;
import org.htmlunit.javascript.host.css.StyleMedia;
import org.htmlunit.javascript.host.dom.AbstractList;
import org.htmlunit.javascript.host.dom.Document;
import org.htmlunit.javascript.host.dom.Selection;
import org.htmlunit.javascript.host.event.Event;
import org.htmlunit.javascript.host.event.EventTarget;
import org.htmlunit.javascript.host.event.MessageEvent;
import org.htmlunit.javascript.host.html.DocumentProxy;
import org.htmlunit.javascript.host.html.HTMLCollection;
import org.htmlunit.javascript.host.html.HTMLDocument;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.htmlunit.javascript.host.performance.Performance;
import org.htmlunit.javascript.host.speech.SpeechSynthesis;
import org.htmlunit.javascript.host.xml.XMLDocument;
import org.htmlunit.util.StringUtils;
import org.htmlunit.util.UrlUtils;
import org.htmlunit.xml.XmlPage;

@JsxClass
public class Window
extends EventTarget
implements WindowOrWorkerGlobalScope,
AutoCloseable {
    private static final Log LOG = LogFactory.getLog(Window.class);
    @JsxConstant(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public static final int TEMPORARY = 0;
    @JsxConstant(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public static final int PERSISTENT = 1;
    private static final Method GETTER_LENGTH;
    private static final Method SETTER_LENGTH;
    private static final Method GETTER_SELF;
    private static final Method SETTER_SELF;
    private static final Method GETTER_PARENT;
    private static final Method SETTER_PARENT;
    private static final Method GETTER_FRAMES;
    private static final Method SETTER_FRAMES;
    private Scriptable lengthShadow_;
    private Scriptable selfShadow_;
    private Scriptable parentShadow_;
    private Scriptable framesShadow_;
    private Document document_;
    private DocumentProxy documentProxy_;
    private Navigator navigator_;
    private Object clientInformation_;
    private WebWindow webWindow_;
    private WindowProxy windowProxy_;
    private Screen screen_;
    private History history_;
    private Location location_;
    private Selection selection_;
    private Event currentEvent_;
    private String status_ = "";
    private Map<Class<? extends Scriptable>, Scriptable> prototypes_ = new HashMap<Class<? extends Scriptable>, Scriptable>();
    private Object controllers_;
    private Object opener_;
    private Object top_ = NOT_FOUND;
    private Crypto crypto_;
    private Scriptable performance_;
    private final EnumMap<StorageHolder.Type, Storage> storages_ = new EnumMap(StorageHolder.Type.class);
    private transient List<AnimationFrame> animationFrames_ = new ArrayList<AnimationFrame>();

    @JsxConstructor
    public static Scriptable jsConstructor(Context cx, Scriptable scope, Object[] args, org.htmlunit.corejs.javascript.Function ctorObj, boolean inNewExpr) {
        throw JavaScriptEngine.typeError("Illegal constructor");
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.animationFrames_ = new ArrayList<AnimationFrame>();
    }

    @Override
    public Scriptable getPrototype(Class<? extends HtmlUnitScriptable> jsClass) {
        return this.prototypes_.get(jsClass);
    }

    public void setPrototypes(Map<Class<? extends Scriptable>, Scriptable> map) {
        this.prototypes_ = map;
    }

    @JsxFunction
    public void alert(Object message) {
        String stringMessage = JavaScriptEngine.toString(message);
        AlertHandler handler = this.getWebWindow().getWebClient().getAlertHandler();
        if (handler == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("window.alert(\"" + stringMessage + "\") no alert handler installed"));
            }
        } else {
            handler.handleAlert(this.document_.getPage(), stringMessage);
        }
    }

    @Override
    @JsxFunction
    public String btoa(String stringToEncode) {
        return WindowOrWorkerGlobalScopeMixin.btoa(stringToEncode, this);
    }

    @Override
    @JsxFunction
    public String atob(String encodedData) {
        return WindowOrWorkerGlobalScopeMixin.atob(encodedData, this);
    }

    @JsxFunction
    public boolean confirm(String message) {
        ConfirmHandler handler = this.getWebWindow().getWebClient().getConfirmHandler();
        if (handler == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("window.confirm(\"" + message + "\") no confirm handler installed, simulating the OK button"));
            }
            return true;
        }
        return handler.handleConfirm(this.document_.getPage(), message);
    }

    @JsxFunction
    public String prompt(String message, Object defaultValue) {
        PromptHandler handler = this.getWebWindow().getWebClient().getPromptHandler();
        if (handler == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)("window.prompt(\"" + message + "\") no prompt handler installed"));
            }
            return null;
        }
        defaultValue = JavaScriptEngine.isUndefined(defaultValue) ? null : JavaScriptEngine.toString(defaultValue);
        return handler.handlePrompt(this.document_.getPage(), message, (String)defaultValue);
    }

    @JsxGetter(propertyName="document")
    public DocumentProxy getDocument_js() {
        return this.documentProxy_;
    }

    public Document getDocument() {
        return this.document_;
    }

    @JsxGetter
    public Object getEvent() {
        if (this.currentEvent_ == null) {
            return JavaScriptEngine.UNDEFINED;
        }
        return this.currentEvent_;
    }

    public Event getCurrentEvent() {
        return this.currentEvent_;
    }

    public void setCurrentEvent(Event event) {
        this.currentEvent_ = event;
    }

    @JsxFunction
    public WindowProxy open(Object url, Object name, Object features, Object replace) {
        WebClient webClient;
        String urlString = null;
        if (!JavaScriptEngine.isUndefined(url)) {
            urlString = JavaScriptEngine.toString(url);
        }
        String windowName = "";
        if (!JavaScriptEngine.isUndefined(name)) {
            windowName = JavaScriptEngine.toString(name);
        }
        String featuresString = null;
        if (!JavaScriptEngine.isUndefined(features)) {
            featuresString = JavaScriptEngine.toString(features);
        }
        if ((webClient = this.getWebWindow().getWebClient()).getOptions().isPopupBlockerEnabled()) {
            LOG.debug((Object)"Ignoring window.open() invocation because popups are blocked.");
            return null;
        }
        boolean replaceCurrentEntryInBrowsingHistory = false;
        if (!JavaScriptEngine.isUndefined(replace)) {
            replaceCurrentEntryInBrowsingHistory = JavaScriptEngine.toBoolean(replace);
        }
        if ((featuresString != null || replaceCurrentEntryInBrowsingHistory) && LOG.isDebugEnabled()) {
            LOG.debug((Object)("window.open: features and replaceCurrentEntryInBrowsingHistory not implemented: url=[" + urlString + "] windowName=[" + windowName + "] features=[" + featuresString + "] replaceCurrentEntry=[" + replaceCurrentEntryInBrowsingHistory + "]"));
        }
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)urlString) && !StringUtils.isEmptyString(windowName)) {
            try {
                WebWindow webWindow = webClient.getWebWindowByName(windowName);
                return Window.getProxy(webWindow);
            }
            catch (WebWindowNotFoundException webWindow) {
                // empty catch block
            }
        }
        URL newUrl = this.makeUrlForOpenWindow(urlString);
        WebWindow newWebWindow = webClient.openWindow(newUrl, windowName, this.webWindow_);
        return Window.getProxy(newWebWindow);
    }

    private URL makeUrlForOpenWindow(String urlString) {
        if (urlString.isEmpty()) {
            return UrlUtils.URL_ABOUT_BLANK;
        }
        try {
            Page page = this.getWebWindow().getEnclosedPage();
            if (page != null && page.isHtmlPage()) {
                return ((HtmlPage)page).getFullyQualifiedUrl(urlString);
            }
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            if (LOG.isWarnEnabled()) {
                LOG.error((Object)("Unable to create URL for openWindow: relativeUrl=[" + urlString + "]"), (Throwable)e);
            }
            return null;
        }
    }

    @JsxFunction
    public static Object setTimeout(Context context, Scriptable scope, Scriptable thisObj, Object[] args, org.htmlunit.corejs.javascript.Function function) {
        return WindowOrWorkerGlobalScopeMixin.setTimeout(context, thisObj, args, function);
    }

    @JsxFunction
    public static Object setInterval(Context context, Scriptable scope, Scriptable thisObj, Object[] args, org.htmlunit.corejs.javascript.Function function) {
        return WindowOrWorkerGlobalScopeMixin.setInterval(context, thisObj, args, function);
    }

    @JsxFunction
    public void clearTimeout(int timeoutId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("clearTimeout(" + timeoutId + ")"));
        }
        this.getWebWindow().getJobManager().removeJob(timeoutId);
    }

    @JsxFunction
    public void clearInterval(int intervalID) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("clearInterval(" + intervalID + ")"));
        }
        this.getWebWindow().getJobManager().removeJob(intervalID);
    }

    @JsxGetter
    public Navigator getNavigator() {
        return this.navigator_;
    }

    @JsxGetter
    public Object getClientInformation() {
        if (this.clientInformation_ != null) {
            return this.clientInformation_;
        }
        return this.navigator_;
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF})
    public void setClientInformation(Object clientInformation) {
        this.clientInformation_ = clientInformation;
    }

    @JsxGetter(propertyName="window")
    public Window getWindow_js() {
        return this;
    }

    @JsxGetter
    public Storage getLocalStorage() {
        return this.getStorage(StorageHolder.Type.LOCAL_STORAGE);
    }

    @JsxGetter
    public Storage getSessionStorage() {
        return this.getStorage(StorageHolder.Type.SESSION_STORAGE);
    }

    public Storage getStorage(StorageHolder.Type storageType) {
        return this.storages_.computeIfAbsent(storageType, k -> {
            WebWindow webWindow = this.getWebWindow();
            Map<String, String> store = webWindow.getWebClient().getStorageHolder().getStore(storageType, webWindow.getEnclosedPage());
            return new Storage(this, store);
        });
    }

    @JsxGetter
    public Location getLocation() {
        return this.location_;
    }

    @JsxSetter
    public void setLocation(String newLocation) throws IOException {
        this.location_.setHref(newLocation);
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void dump(String message) {
        WebConsole console = this.getWebWindow().getWebClient().getWebConsole();
        console.print(Context.getCurrentContext(), (Scriptable)this, NativeConsole.Level.INFO, new String[]{message}, null);
    }

    public int animateAnimationsFrames() {
        ArrayList<AnimationFrame> animationFrames = new ArrayList<AnimationFrame>(this.animationFrames_);
        this.animationFrames_.clear();
        double now = (double)System.nanoTime() / 1000000.0;
        Object[] args = new Object[]{now};
        WebWindow ww = this.getWindow().getWebWindow();
        JavaScriptEngine jsEngine = (JavaScriptEngine)ww.getWebClient().getJavaScriptEngine();
        for (AnimationFrame animationFrame : animationFrames) {
            jsEngine.callFunction((HtmlPage)ww.getEnclosedPage(), animationFrame.callback_, (Scriptable)this, this.getParentScope(), args);
        }
        return this.animationFrames_.size();
    }

    @JsxFunction
    public int requestAnimationFrame(Object callback) {
        if (callback instanceof org.htmlunit.corejs.javascript.Function) {
            int id = this.animationFrames_.size();
            AnimationFrame animationFrame = new AnimationFrame(id, (org.htmlunit.corejs.javascript.Function)callback);
            this.animationFrames_.add(animationFrame);
            return id;
        }
        return -1;
    }

    @JsxFunction
    public void cancelAnimationFrame(Object requestId) {
        int id = (int)JavaScriptEngine.toNumber(requestId);
        this.animationFrames_.removeIf(animationFrame -> animationFrame.id_ == (long)id);
    }

    @JsxGetter
    public Screen getScreen() {
        return this.screen_;
    }

    @JsxGetter
    public History getHistory() {
        return this.history_;
    }

    @JsxGetter
    public External getExternal() {
        External external = new External();
        external.setParentScope((Scriptable)this);
        external.setPrototype(this.getPrototype(external.getClass()));
        return external;
    }

    public void initialize(WebWindow webWindow, Page pageToEnclose) {
        WebWindow opener;
        this.webWindow_ = webWindow;
        this.webWindow_.setScriptableObject(this);
        this.defineProperty("length", null, GETTER_LENGTH, SETTER_LENGTH, 1);
        this.defineProperty("self", null, GETTER_SELF, SETTER_SELF, 1);
        this.defineProperty("parent", null, GETTER_PARENT, SETTER_PARENT, 1);
        this.defineProperty("frames", null, GETTER_FRAMES, SETTER_FRAMES, 1);
        this.windowProxy_ = new WindowProxy(this.webWindow_);
        this.document_ = pageToEnclose instanceof XmlPage ? new XMLDocument() : new HTMLDocument();
        this.document_.setParentScope((Scriptable)this);
        this.document_.setPrototype(this.getPrototype(this.document_.getClass()));
        this.document_.setWindow(this);
        if (pageToEnclose instanceof SgmlPage) {
            SgmlPage page = (SgmlPage)pageToEnclose;
            this.document_.setDomNode(page);
            if (page.isHtmlPage()) {
                HtmlPage htmlPage = (HtmlPage)page;
                htmlPage.addAutoCloseable(this);
            }
        }
        this.documentProxy_ = new DocumentProxy(this.webWindow_);
        this.navigator_ = new Navigator();
        this.navigator_.setParentScope((Scriptable)this);
        this.navigator_.setPrototype(this.getPrototype(this.navigator_.getClass()));
        this.screen_ = new Screen(this.getWebWindow().getScreen());
        this.screen_.setParentScope((Scriptable)this);
        this.screen_.setPrototype(this.getPrototype(this.screen_.getClass()));
        this.history_ = new History();
        this.history_.setParentScope((Scriptable)this);
        this.history_.setPrototype(this.getPrototype(this.history_.getClass()));
        this.location_ = new Location();
        this.location_.setParentScope((Scriptable)this);
        this.location_.setPrototype(this.getPrototype(this.location_.getClass()));
        this.location_.jsConstructor();
        this.location_.initialize(this, pageToEnclose);
        Context ctx = Context.getCurrentContext();
        this.controllers_ = ctx.newObject((Scriptable)this);
        if (this.webWindow_ instanceof TopLevelWindow && (opener = ((TopLevelWindow)this.webWindow_).getOpener()) != null) {
            this.opener_ = opener.getScriptableObject();
        }
    }

    public void initialize(Page enclosedPage) {
        if (enclosedPage != null && enclosedPage.isHtmlPage()) {
            HtmlPage htmlPage = (HtmlPage)enclosedPage;
            this.setDomNode(htmlPage);
            this.clearEventListenersContainer();
            WebAssert.notNull("document_", this.document_);
            this.document_.setDomNode(htmlPage);
        }
    }

    public void initialize() {
    }

    @JsxGetter
    public Object getTop() {
        if (this.top_ != NOT_FOUND) {
            return this.top_;
        }
        WebWindow top = this.getWebWindow().getTopWindow();
        return top.getScriptableObject();
    }

    @JsxSetter
    public void setTop(Object o) {
    }

    @JsxGetter
    public Object getOpener() {
        Object opener = this.opener_;
        if (opener instanceof Window) {
            opener = ((Window)opener).windowProxy_;
        }
        return opener;
    }

    @JsxSetter
    public void setOpener(Object newValue) {
        this.opener_ = newValue;
    }

    @JsxGetter
    public HtmlUnitScriptable getFrameElement() {
        WebWindow window = this.getWebWindow();
        if (window instanceof FrameWindow) {
            return ((FrameWindow)window).getFrameElement().getScriptableObject();
        }
        return null;
    }

    @JsxGetter
    public Object getLength() {
        return JavaScriptEngine.UNDEFINED;
    }

    public Object jsGetLength() {
        if (this.lengthShadow_ != null) {
            return this.lengthShadow_;
        }
        HTMLCollection frames = this.getFrames();
        if (frames != null) {
            return frames.getLength();
        }
        return 0;
    }

    public void jsSetLength(Scriptable lengthShadow) {
        this.lengthShadow_ = lengthShadow;
    }

    @JsxGetter
    public Object getSelf() {
        return JavaScriptEngine.UNDEFINED;
    }

    public Object jsGetSelf() {
        if (this.selfShadow_ != null) {
            return this.selfShadow_;
        }
        return this;
    }

    public void jsSetSelf(Scriptable selfShadow) {
        this.selfShadow_ = selfShadow;
    }

    @JsxGetter
    public Object getParent() {
        return JavaScriptEngine.UNDEFINED;
    }

    public Object jsGetParent() {
        if (this.parentShadow_ != null) {
            return this.parentShadow_;
        }
        WebWindow parent = this.getWebWindow().getParentWindow();
        return parent.getScriptableObject();
    }

    public void jsSetParent(Scriptable parentShadow) {
        this.parentShadow_ = parentShadow;
    }

    @JsxGetter(propertyName="frames")
    public Object getFrames_js() {
        return JavaScriptEngine.UNDEFINED;
    }

    public Object jsGetFrames() {
        if (this.framesShadow_ != null) {
            return this.framesShadow_;
        }
        return this;
    }

    public void jsSetFrames(Scriptable framesShadow) {
        this.framesShadow_ = framesShadow;
    }

    private HTMLCollection getFrames() {
        Page page = this.getWebWindow().getEnclosedPage();
        if (page instanceof HtmlPage) {
            return new HTMLCollectionFrames((HtmlPage)page);
        }
        return null;
    }

    public WebWindow getWebWindow() {
        return this.webWindow_;
    }

    @JsxFunction
    public void focus() {
        WebWindow window = this.getWebWindow();
        window.getWebClient().setCurrentWindow(window);
    }

    @JsxFunction
    public void blur() {
        LOG.debug((Object)"window.blur() not implemented");
    }

    @JsxFunction(functionName="close")
    public void close_js() {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof TopLevelWindow) {
            ((TopLevelWindow)webWindow).close();
        } else {
            webWindow.getWebClient().deregisterWebWindow(webWindow);
        }
    }

    @JsxGetter
    public boolean isClosed() {
        WebWindow webWindow = this.getWebWindow();
        return !webWindow.getWebClient().containsWebWindow(webWindow);
    }

    @JsxFunction
    public void moveTo(int x, int y) {
        LOG.debug((Object)"window.moveTo() not implemented");
    }

    @JsxFunction
    public void moveBy(int x, int y) {
        LOG.debug((Object)"window.moveBy() not implemented");
    }

    @JsxFunction
    public void resizeBy(int width, int height) {
        LOG.debug((Object)"window.resizeBy() not implemented");
    }

    @JsxFunction
    public void resizeTo(int width, int height) {
        LOG.debug((Object)"window.resizeTo() not implemented");
    }

    @JsxFunction
    public void scroll(Scriptable x, Scriptable y) {
        this.scrollTo(x, y);
    }

    @JsxFunction
    public void scrollBy(Scriptable x, Scriptable y) {
        HTMLElement body = this.document_.getBody();
        if (body != null) {
            int xOff = 0;
            int yOff = 0;
            if (y != null) {
                xOff = JavaScriptEngine.toInt32(x);
                yOff = JavaScriptEngine.toInt32(y);
            } else {
                if (!(x instanceof NativeObject)) {
                    throw JavaScriptEngine.typeError("eee");
                }
                if (x.has("left", x)) {
                    xOff = JavaScriptEngine.toInt32(x.get("left", x));
                }
                if (x.has("top", x)) {
                    yOff = JavaScriptEngine.toInt32(x.get("top", x));
                }
            }
            body.setScrollLeft(body.getScrollLeft() + xOff);
            body.setScrollTop(body.getScrollTop() + yOff);
            Event event = new Event(body, "scroll");
            body.fireEvent(event);
        }
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void scrollByLines(int lines) {
        HTMLElement body = this.document_.getBody();
        if (body != null) {
            body.setScrollTop(body.getScrollTop() + 19 * lines);
            Event event = new Event(body, "scroll");
            body.fireEvent(event);
        }
    }

    @JsxFunction(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void scrollByPages(int pages) {
        HTMLElement body = this.document_.getBody();
        if (body != null) {
            body.setScrollTop(body.getScrollTop() + this.getInnerHeight() * pages);
            Event event = new Event(body, "scroll");
            body.fireEvent(event);
        }
    }

    @JsxFunction
    public void scrollTo(Scriptable x, Scriptable y) {
        HTMLElement body = this.document_.getBody();
        if (body != null) {
            int xOff = 0;
            int yOff = 0;
            if (y != null) {
                xOff = JavaScriptEngine.toInt32(x);
                yOff = JavaScriptEngine.toInt32(y);
            } else {
                if (!(x instanceof NativeObject)) {
                    throw JavaScriptEngine.typeError("eee");
                }
                xOff = body.getScrollLeft();
                yOff = body.getScrollTop();
                if (x.has("left", x)) {
                    xOff = JavaScriptEngine.toInt32(x.get("left", x));
                }
                if (x.has("top", x)) {
                    yOff = JavaScriptEngine.toInt32(x.get("top", x));
                }
            }
            body.setScrollLeft(xOff);
            body.setScrollTop(yOff);
            Event event = new Event(body, "scroll");
            body.fireEvent(event);
        }
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnload() {
        return this.getEventHandler("load");
    }

    @JsxSetter
    public void setOnload(Object onload) {
        this.setHandlerForJavaScript("load", onload);
    }

    @JsxSetter
    public void setOnblur(Object onblur) {
        this.setHandlerForJavaScript("blur", onblur);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnblur() {
        return this.getEventHandler("blur");
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnclick() {
        return this.getEventHandler("click");
    }

    @JsxSetter
    public void setOnclick(Object onclick) {
        this.setHandlerForJavaScript("click", onclick);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndblclick() {
        return this.getEventHandler("dblclick");
    }

    @JsxSetter
    public void setOndblclick(Object ondblclick) {
        this.setHandlerForJavaScript("dblclick", ondblclick);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnhashchange() {
        return this.getEventHandler("hashchange");
    }

    @JsxSetter
    public void setOnhashchange(Object onhashchange) {
        this.setHandlerForJavaScript("hashchange", onhashchange);
    }

    @JsxGetter
    public String getName() {
        return this.getWebWindow().getName();
    }

    @JsxSetter
    public void setName(String name) {
        this.getWebWindow().setName(name);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnbeforeunload() {
        return this.getEventHandler("beforeunload");
    }

    @JsxSetter
    public void setOnbeforeunload(Object onbeforeunload) {
        this.setHandlerForJavaScript("beforeunload", onbeforeunload);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnerror() {
        return this.getEventHandler("error");
    }

    @JsxSetter
    public void setOnerror(Object onerror) {
        this.setHandlerForJavaScript("error", onerror);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmessage() {
        return this.getEventHandler("message");
    }

    @JsxSetter
    public void setOnmessage(Object onmessage) {
        this.setHandlerForJavaScript("message", onmessage);
    }

    public void triggerOnError(ScriptException e) {
        org.htmlunit.corejs.javascript.Function f = this.getOnerror();
        if (f != null) {
            Object msg = e.getMessage();
            String url = e.getPage().getUrl().toExternalForm();
            int line = e.getFailingLineNumber();
            int column = e.getFailingColumnNumber();
            Object jsError = e.getMessage();
            if (e.getCause() instanceof JavaScriptException) {
                msg = "uncaught exception: " + e.getCause().getMessage();
                jsError = ((JavaScriptException)e.getCause()).getValue();
            } else if (e.getCause() instanceof EcmaError) {
                msg = "uncaught " + e.getCause().getMessage();
                EcmaError ecmaError = (EcmaError)e.getCause();
                Scriptable err = Context.getCurrentContext().newObject((Scriptable)this, "Error");
                ScriptableObject.putProperty((Scriptable)err, (String)"message", (Object)ecmaError.getMessage());
                ScriptableObject.putProperty((Scriptable)err, (String)"fileName", (Object)ecmaError.sourceName());
                ScriptableObject.putProperty((Scriptable)err, (String)"lineNumber", (Object)ecmaError.lineNumber());
                jsError = err;
            }
            Object[] args = new Object[]{msg, url, line, column, jsError};
            f.call(Context.getCurrentContext(), (Scriptable)this, (Scriptable)this, args);
        }
    }

    private void setHandlerForJavaScript(String eventName, Object handler) {
        this.getEventListenersContainer().setEventHandler(eventName, handler);
    }

    public Object getWithFallback(String name) {
        Object result = NOT_FOUND;
        DomNode domNode = this.getDomNodeOrNull();
        if (domNode != null) {
            HtmlPage page = (HtmlPage)domNode.getPage();
            result = Window.getFrameWindowByName(page, name);
            if (result == NOT_FOUND && (result = this.getElementsByName(page, name)) == NOT_FOUND) {
                try {
                    Object htmlElement = page.getHtmlElementById(name);
                    result = this.getScriptableFor(htmlElement);
                }
                catch (ElementNotFoundException e) {
                    result = NOT_FOUND;
                }
            }
            if (result instanceof Window) {
                WebWindow webWindow = ((Window)result).getWebWindow();
                result = Window.getProxy(webWindow);
            }
        }
        return result;
    }

    public Object get(int index, Scriptable start) {
        if (index < 0 || this.getWebWindow() == null) {
            return JavaScriptEngine.UNDEFINED;
        }
        HTMLCollection frames = this.getFrames();
        if (frames == null || index >= frames.getLength()) {
            return JavaScriptEngine.UNDEFINED;
        }
        return frames.item(index);
    }

    private static Object getFrameWindowByName(HtmlPage page, String name) {
        try {
            return page.getFrameByName(name).getScriptableObject();
        }
        catch (ElementNotFoundException e) {
            return NOT_FOUND;
        }
    }

    private Object getElementsByName(HtmlPage page, String name) {
        List<DomElement> elements = page.getElementsByName(name);
        Filter filter = new Filter(false);
        elements.removeIf(domElement -> !filter.matches(domElement));
        if (elements.isEmpty()) {
            return NOT_FOUND;
        }
        if (elements.size() == 1) {
            return this.getScriptableFor(elements.get(0));
        }
        String expElementName = "null".equals(name) ? "" : name;
        HTMLCollection coll = new HTMLCollection((DomNode)page, true);
        coll.setElementsSupplier((Supplier<List> & Serializable)() -> {
            List<DomElement> expElements = page.getElementsByName(expElementName);
            ArrayList<DomElement> result = new ArrayList<DomElement>(expElements.size());
            for (DomElement domElement : expElements) {
                if (!filter.matches(domElement)) continue;
                result.add(domElement);
            }
            return result;
        });
        coll.setEffectOnCacheFunction((Function<HtmlAttributeChangeEvent, AbstractList.EffectOnCache> & Serializable)event -> {
            if ("name".equals(event.getName())) {
                return AbstractList.EffectOnCache.RESET;
            }
            return AbstractList.EffectOnCache.NONE;
        });
        return coll;
    }

    public static WindowProxy getProxy(WebWindow w) {
        return ((Window)w.getScriptableObject()).windowProxy_;
    }

    @JsxGetter
    public String getStatus() {
        return this.status_;
    }

    @JsxSetter
    public void setStatus(String message) {
        this.status_ = message;
        StatusHandler statusHandler = this.webWindow_.getWebClient().getStatusHandler();
        if (statusHandler != null) {
            statusHandler.statusMessageChanged(this.webWindow_.getEnclosedPage(), message);
        }
    }

    @JsxGetter
    public int getInnerWidth() {
        return this.getWebWindow().getInnerWidth();
    }

    @JsxSetter
    public void setInnerWidth(int width) {
        this.getWebWindow().setInnerWidth(width);
    }

    @JsxGetter
    public int getOuterWidth() {
        return this.getWebWindow().getOuterWidth();
    }

    @JsxSetter
    public void setOuterWidth(int width) {
        this.getWebWindow().setOuterWidth(width);
    }

    @JsxGetter
    public int getInnerHeight() {
        return this.getWebWindow().getInnerHeight();
    }

    @JsxSetter
    public void setInnerHeight(int height) {
        this.getWebWindow().setInnerHeight(height);
    }

    @JsxGetter
    public int getOuterHeight() {
        return this.getWebWindow().getOuterHeight();
    }

    @JsxSetter
    public void setOuterHeight(int height) {
        this.getWebWindow().setOuterHeight(height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsxFunction
    public void print() {
        PrintHandler handler = this.getWebWindow().getWebClient().getPrintHandler();
        if (handler == null) {
            LOG.info((Object)"No PrintHandler installed - window.print() ignored");
            return;
        }
        SgmlPage sgmlPage = this.getDocument().getPage();
        if (!(sgmlPage instanceof HtmlPage)) {
            LOG.debug((Object)"Page is not an HtmlPage - window.print() ignored");
            return;
        }
        Event event = new Event(this, "beforeprint");
        this.fireEvent(event);
        HtmlPage page = (HtmlPage)sgmlPage;
        page.setPrinting(true);
        try {
            handler.handlePrint(page);
        }
        finally {
            page.setPrinting(false);
        }
        event = new Event(this, "afterprint");
        this.fireEvent(event);
    }

    @JsxFunction
    public void captureEvents(String type) {
    }

    @JsxFunction
    public void releaseEvents(String type) {
    }

    @JsxFunction
    public ComputedCSSStyleDeclaration getComputedStyle(Object element, String pseudoElement) {
        if (!(element instanceof Element)) {
            throw JavaScriptEngine.typeError("parameter 1 is not of type 'Element'");
        }
        Element e = (Element)element;
        ComputedCssStyleDeclaration style = this.getWebWindow().getComputedStyle(e.getDomNodeOrDie(), pseudoElement);
        return new ComputedCSSStyleDeclaration(e, style);
    }

    @JsxFunction
    public Selection getSelection() {
        WebWindow webWindow = this.getWebWindow();
        if (webWindow instanceof FrameWindow) {
            FrameWindow frameWindow = (FrameWindow)webWindow;
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_WINDOW_SELECTION_NULL_IF_INVISIBLE) && !frameWindow.getFrameElement().isDisplayed()) {
                return null;
            }
        }
        return this.getSelectionImpl();
    }

    public Selection getSelectionImpl() {
        if (this.selection_ == null) {
            this.selection_ = new Selection();
            this.selection_.setParentScope((Scriptable)this);
            this.selection_.setPrototype(this.getPrototype(this.selection_.getClass()));
        }
        return this.selection_;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Object getControllers() {
        return this.controllers_;
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setControllers(Object value) {
        this.controllers_ = value;
    }

    @JsxGetter(value={SupportedBrowser.FF})
    public int getMozInnerScreenX() {
        return 12;
    }

    @JsxGetter(value={SupportedBrowser.FF_ESR}, propertyName="mozInnerScreenX")
    public int getMozInnerScreenXffesr_js() {
        return 10;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public int getMozInnerScreenY() {
        return 89;
    }

    @JsxFunction
    public void stop() {
    }

    @JsxGetter
    public int getPageXOffset() {
        return 0;
    }

    @JsxGetter
    public int getPageYOffset() {
        return 0;
    }

    @JsxGetter
    public int getScrollX() {
        return 0;
    }

    @JsxGetter
    public int getScrollY() {
        return 0;
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public Netscape getNetscape() {
        return new Netscape(this);
    }

    public boolean isConst(String name) {
        if ("undefined".equals(name) || "Infinity".equals(name) || "NaN".equals(name)) {
            return false;
        }
        return super.isConst(name);
    }

    @Override
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        ScriptResult result = this.fireEvent(event);
        return !event.isAborted(result);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnchange() {
        return this.getEventHandler("change");
    }

    @JsxSetter
    public void setOnchange(Object onchange) {
        this.setHandlerForJavaScript("change", onchange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnsubmit() {
        return this.getEventHandler("submit");
    }

    @JsxSetter
    public void setOnsubmit(Object onsubmit) {
        this.setHandlerForJavaScript("submit", onsubmit);
    }

    @JsxFunction
    public static void postMessage(Context context, Scriptable scope, Scriptable thisObj, Object[] args, org.htmlunit.corejs.javascript.Function funObj) {
        if (args.length < 1) {
            throw JavaScriptEngine.typeError("message not provided");
        }
        Object message = args[0];
        String targetOrigin = "*";
        if (args.length > 1) {
            targetOrigin = JavaScriptEngine.toString(args[1]);
        }
        Object transfer = JavaScriptEngine.UNDEFINED;
        if (args.length > 2) {
            transfer = args[2];
        }
        Window sender = (Window)scope;
        final Window receiver = (Window)thisObj;
        URL receiverURL = receiver.getWebWindow().getEnclosedPage().getUrl();
        WebWindow webWindow = sender.getWebWindow();
        Page page = webWindow.getEnclosedPage();
        URL senderURL = page.getUrl();
        if (!StringUtils.equalsChar('*', targetOrigin)) {
            URL targetURL;
            if (StringUtils.equalsChar('/', targetOrigin)) {
                targetURL = senderURL;
            } else {
                try {
                    targetURL = new URL(targetOrigin);
                }
                catch (Exception e) {
                    throw JavaScriptEngine.asJavaScriptException((HtmlUnitScriptable)Window.getTopLevelScope((Scriptable)thisObj), "Failed to execute 'postMessage' on 'Window': Invalid target origin '" + targetOrigin + "' was specified (reason: " + e.getMessage() + ".", 12);
                }
            }
            if (Window.getPort(targetURL) != Window.getPort(receiverURL)) {
                return;
            }
            if (!targetURL.getHost().equals(receiverURL.getHost())) {
                return;
            }
            if (!targetURL.getProtocol().equals(receiverURL.getProtocol())) {
                return;
            }
        }
        String origin = "";
        try {
            URL originUrl = UrlUtils.getUrlWithoutPathRefQuery(senderURL);
            origin = UrlUtils.removeRedundantPort(originUrl).toExternalForm();
        }
        catch (MalformedURLException e) {
            throw JavaScriptEngine.throwAsScriptRuntimeEx(e);
        }
        final MessageEvent event = new MessageEvent();
        event.initMessageEvent("message", false, false, message, origin, "", sender, transfer);
        event.setParentScope(scope);
        event.setPrototype(receiver.getPrototype(event.getClass()));
        final AbstractJavaScriptEngine<?> jsEngine = webWindow.getWebClient().getJavaScriptEngine();
        PostponedAction action = new PostponedAction(page, "Window.postMessage"){

            @Override
            public void execute() {
                HtmlUnitContextFactory cf = jsEngine.getContextFactory();
                cf.call(cx -> receiver.dispatchEvent(event));
            }
        };
        jsEngine.addPostponedAction(action);
    }

    public static int getPort(URL url) {
        int port = url.getPort();
        if (port == -1) {
            port = "http".equals(url.getProtocol()) ? 80 : 443;
        }
        return port;
    }

    @JsxGetter
    public Scriptable getPerformance() {
        if (this.performance_ == null) {
            Performance performance = new Performance();
            performance.setParentScope((Scriptable)this);
            performance.setPrototype(this.getPrototype(performance.getClass()));
            this.performance_ = performance;
        }
        return this.performance_;
    }

    @JsxSetter
    public void setPerformance(Scriptable performance) {
        this.performance_ = performance;
    }

    @JsxGetter
    public int getDevicePixelRatio() {
        return 1;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public StyleMedia getStyleMedia() {
        StyleMedia styleMedia = new StyleMedia();
        styleMedia.setParentScope((Scriptable)this);
        styleMedia.setPrototype(this.getPrototype(styleMedia.getClass()));
        return styleMedia;
    }

    @JsxFunction
    public MediaQueryList matchMedia(String mediaQueryString) {
        MediaQueryList mediaQueryList = new MediaQueryList(mediaQueryString);
        mediaQueryList.setParentScope((Scriptable)this);
        mediaQueryList.setPrototype(this.getPrototype(mediaQueryList.getClass()));
        return mediaQueryList;
    }

    @JsxFunction
    public boolean find(String search, boolean caseSensitive, boolean backwards, boolean wrapAround, boolean wholeWord, boolean searchInFrames, boolean showDialog) {
        return false;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public SpeechSynthesis getSpeechSynthesis() {
        SpeechSynthesis speechSynthesis = new SpeechSynthesis();
        speechSynthesis.setParentScope((Scriptable)this);
        speechSynthesis.setPrototype(this.getPrototype(speechSynthesis.getClass()));
        return speechSynthesis;
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public boolean getOffscreenBuffering() {
        return true;
    }

    @JsxGetter
    public Crypto getCrypto() {
        if (this.crypto_ == null) {
            this.crypto_ = new Crypto(this);
        }
        return this.crypto_;
    }

    @Override
    public void close() {
    }

    @Override
    public void setParentScope(Scriptable parent) {
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnfocus() {
        return this.getEventHandler("focus");
    }

    @JsxSetter
    public void setOnfocus(Object onfocus) {
        this.setHandlerForJavaScript("focus", onfocus);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragend() {
        return this.getEventHandler("dragend");
    }

    @JsxSetter
    public void setOndragend(Object ondragend) {
        this.setHandlerForJavaScript("dragend", ondragend);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOninvalid() {
        return this.getEventHandler("invalid");
    }

    @JsxSetter
    public void setOninvalid(Object oninvalid) {
        this.setHandlerForJavaScript("invalid", oninvalid);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerout() {
        return this.getEventHandler("pointerout");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerout(Object onpointerout) {
        this.setHandlerForJavaScript("pointerout", onpointerout);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnratechange() {
        return this.getEventHandler("ratechange");
    }

    @JsxSetter
    public void setOnratechange(Object onratechange) {
        this.setHandlerForJavaScript("ratechange", onratechange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnanimationiteration() {
        return this.getEventHandler("animationiteration");
    }

    @JsxSetter
    public void setOnanimationiteration(Object onanimationiteration) {
        this.setHandlerForJavaScript("animationiteration", onanimationiteration);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOncanplaythrough() {
        return this.getEventHandler("canplaythrough");
    }

    @JsxSetter
    public void setOncanplaythrough(Object oncanplaythrough) {
        this.setHandlerForJavaScript("canplaythrough", oncanplaythrough);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOncancel() {
        return this.getEventHandler("cancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOncancel(Object oncancel) {
        this.setHandlerForJavaScript("cancel", oncancel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerenter() {
        return this.getEventHandler("pointerenter");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerenter(Object onpointerenter) {
        this.setHandlerForJavaScript("pointerenter", onpointerenter);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnselect() {
        return this.getEventHandler("select");
    }

    @JsxSetter
    public void setOnselect(Object onselect) {
        this.setHandlerForJavaScript("select", onselect);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnauxclick() {
        return this.getEventHandler("auxclick");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnauxclick(Object onauxclick) {
        this.setHandlerForJavaScript("auxclick", onauxclick);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnscroll() {
        return this.getEventHandler("scroll");
    }

    @JsxSetter
    public void setOnscroll(Object onscroll) {
        this.setHandlerForJavaScript("scroll", onscroll);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnkeydown() {
        return this.getEventHandler("keydown");
    }

    @JsxSetter
    public void setOnkeydown(Object onkeydown) {
        this.setHandlerForJavaScript("keydown", onkeydown);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnwebkitanimationstart() {
        return this.getEventHandler("webkitanimationstart");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkitanimationstart(Object onwebkitanimationstart) {
        this.setHandlerForJavaScript("webkitanimationstart", onwebkitanimationstart);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnkeyup() {
        return this.getEventHandler("keyup");
    }

    @JsxSetter
    public void setOnkeyup(Object onkeyup) {
        this.setHandlerForJavaScript("keyup", onkeyup);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnreset() {
        return this.getEventHandler("reset");
    }

    @JsxSetter
    public void setOnreset(Object onreset) {
        this.setHandlerForJavaScript("reset", onreset);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnkeypress() {
        return this.getEventHandler("keypress");
    }

    @JsxSetter
    public void setOnkeypress(Object onkeypress) {
        this.setHandlerForJavaScript("keypress", onkeypress);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndrag() {
        return this.getEventHandler("drag");
    }

    @JsxSetter
    public void setOndrag(Object ondrag) {
        this.setHandlerForJavaScript("drag", ondrag);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnseeked() {
        return this.getEventHandler("seeked");
    }

    @JsxSetter
    public void setOnseeked(Object onseeked) {
        this.setHandlerForJavaScript("seeked", onseeked);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnoffline() {
        return this.getEventHandler("offline");
    }

    @JsxSetter
    public void setOnoffline(Object onoffline) {
        this.setHandlerForJavaScript("offline", onoffline);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndeviceorientation() {
        return this.getEventHandler("deviceorientation");
    }

    @JsxSetter
    public void setOndeviceorientation(Object ondeviceorientation) {
        this.setHandlerForJavaScript("deviceorientation", ondeviceorientation);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOntoggle() {
        return this.getEventHandler("toggle");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOntoggle(Object ontoggle) {
        this.setHandlerForJavaScript("toggle", ontoggle);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnplay() {
        return this.getEventHandler("play");
    }

    @JsxSetter
    public void setOnplay(Object onplay) {
        this.setHandlerForJavaScript("play", onplay);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOncontextmenu() {
        return this.getEventHandler("contextmenu");
    }

    @JsxSetter
    public void setOncontextmenu(Object oncontextmenu) {
        this.setHandlerForJavaScript("contextmenu", oncontextmenu);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmousemove() {
        return this.getEventHandler("mousemove");
    }

    @JsxSetter
    public void setOnmousemove(Object onmousemove) {
        this.setHandlerForJavaScript("mousemove", onmousemove);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointermove() {
        return this.getEventHandler("pointermove");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointermove(Object onpointermove) {
        this.setHandlerForJavaScript("pointermove", onpointermove);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseover() {
        return this.getEventHandler("mouseover");
    }

    @JsxSetter
    public void setOnmouseover(Object onmouseover) {
        this.setHandlerForJavaScript("mouseover", onmouseover);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnlostpointercapture() {
        return this.getEventHandler("lostpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnlostpointercapture(Object onlostpointercapture) {
        this.setHandlerForJavaScript("lostpointercapture", onlostpointercapture);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerover() {
        return this.getEventHandler("pointerover");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerover(Object onpointerover) {
        this.setHandlerForJavaScript("pointerover", onpointerover);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnclose() {
        return this.getEventHandler("close");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnclose(Object onclose) {
        this.setHandlerForJavaScript("close", onclose);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnanimationend() {
        return this.getEventHandler("animationend");
    }

    @JsxSetter
    public void setOnanimationend(Object onanimationend) {
        this.setHandlerForJavaScript("animationend", onanimationend);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragenter() {
        return this.getEventHandler("dragenter");
    }

    @JsxSetter
    public void setOndragenter(Object ondragenter) {
        this.setHandlerForJavaScript("dragenter", ondragenter);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public org.htmlunit.corejs.javascript.Function getOnafterprint() {
        return this.getEventHandler("afterprint");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnafterprint(Object onafterprint) {
        this.setHandlerForJavaScript("afterprint", onafterprint);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public org.htmlunit.corejs.javascript.Function getOnmozfullscreenerror() {
        return this.getEventHandler("mozfullscreenerror");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmozfullscreenerror(Object onmozfullscreenerror) {
        this.setHandlerForJavaScript("mozfullscreenerror", onmozfullscreenerror);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseleave() {
        return this.getEventHandler("mouseleave");
    }

    @JsxSetter
    public void setOnmouseleave(Object onmouseleave) {
        this.setHandlerForJavaScript("mouseleave", onmouseleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnmousewheel() {
        return this.getEventHandler("mousewheel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnmousewheel(Object onmousewheel) {
        this.setHandlerForJavaScript("mousewheel", onmousewheel);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnseeking() {
        return this.getEventHandler("seeking");
    }

    @JsxSetter
    public void setOnseeking(Object onseeking) {
        this.setHandlerForJavaScript("seeking", onseeking);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOncuechange() {
        return this.getEventHandler("cuechange");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOncuechange(Object oncuechange) {
        this.setHandlerForJavaScript("cuechange", oncuechange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnpageshow() {
        return this.getEventHandler("pageshow");
    }

    @JsxSetter
    public void setOnpageshow(Object onpageshow) {
        this.setHandlerForJavaScript("pageshow", onpageshow);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public org.htmlunit.corejs.javascript.Function getOnmozfullscreenchange() {
        return this.getEventHandler("mozfullscreenchange");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnmozfullscreenchange(Object onmozfullscreenchange) {
        this.setHandlerForJavaScript("mozfullscreenchange", onmozfullscreenchange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndurationchange() {
        return this.getEventHandler("durationchange");
    }

    @JsxSetter
    public void setOndurationchange(Object ondurationchange) {
        this.setHandlerForJavaScript("durationchange", ondurationchange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnplaying() {
        return this.getEventHandler("playing");
    }

    @JsxSetter
    public void setOnplaying(Object onplaying) {
        this.setHandlerForJavaScript("playing", onplaying);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnended() {
        return this.getEventHandler("ended");
    }

    @JsxSetter
    public void setOnended(Object onended) {
        this.setHandlerForJavaScript("ended", onended);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnloadeddata() {
        return this.getEventHandler("loadeddata");
    }

    @JsxSetter
    public void setOnloadeddata(Object onloadeddata) {
        this.setHandlerForJavaScript("loadeddata", onloadeddata);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnunhandledrejection() {
        return this.getEventHandler("unhandledrejection");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnunhandledrejection(Object onunhandledrejection) {
        this.setHandlerForJavaScript("unhandledrejection", onunhandledrejection);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseout() {
        return this.getEventHandler("mouseout");
    }

    @JsxSetter
    public void setOnmouseout(Object onmouseout) {
        this.setHandlerForJavaScript("mouseout", onmouseout);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnsuspend() {
        return this.getEventHandler("suspend");
    }

    @JsxSetter
    public void setOnsuspend(Object onsuspend) {
        this.setHandlerForJavaScript("suspend", onsuspend);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnwaiting() {
        return this.getEventHandler("waiting");
    }

    @JsxSetter
    public void setOnwaiting(Object onwaiting) {
        this.setHandlerForJavaScript("waiting", onwaiting);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOncanplay() {
        return this.getEventHandler("canplay");
    }

    @JsxSetter
    public void setOncanplay(Object oncanplay) {
        this.setHandlerForJavaScript("canplay", oncanplay);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmousedown() {
        return this.getEventHandler("mousedown");
    }

    @JsxSetter
    public void setOnmousedown(Object onmousedown) {
        this.setHandlerForJavaScript("mousedown", onmousedown);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnlanguagechange() {
        return this.getEventHandler("languagechange");
    }

    @JsxSetter
    public void setOnlanguagechange(Object onlanguagechange) {
        this.setHandlerForJavaScript("languagechange", onlanguagechange);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnemptied() {
        return this.getEventHandler("emptied");
    }

    @JsxSetter
    public void setOnemptied(Object onemptied) {
        this.setHandlerForJavaScript("emptied", onemptied);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnrejectionhandled() {
        return this.getEventHandler("rejectionhandled");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnrejectionhandled(Object onrejectionhandled) {
        this.setHandlerForJavaScript("rejectionhandled", onrejectionhandled);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointercancel() {
        return this.getEventHandler("pointercancel");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointercancel(Object onpointercancel) {
        this.setHandlerForJavaScript("pointercancel", onpointercancel);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnresize() {
        return this.getEventHandler("resize");
    }

    @JsxSetter
    public void setOnresize(Object onresize) {
        this.setHandlerForJavaScript("resize", onresize);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnpause() {
        return this.getEventHandler("pause");
    }

    @JsxSetter
    public void setOnpause(Object onpause) {
        this.setHandlerForJavaScript("pause", onpause);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnloadstart() {
        return this.getEventHandler("loadstart");
    }

    @JsxSetter
    public void setOnloadstart(Object onloadstart) {
        this.setHandlerForJavaScript("loadstart", onloadstart);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnprogress() {
        return this.getEventHandler("progress");
    }

    @JsxSetter
    public void setOnprogress(Object onprogress) {
        this.setHandlerForJavaScript("progress", onprogress);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerup() {
        return this.getEventHandler("pointerup");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerup(Object onpointerup) {
        this.setHandlerForJavaScript("pointerup", onpointerup);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnwheel() {
        return this.getEventHandler("wheel");
    }

    @JsxSetter
    public void setOnwheel(Object onwheel) {
        this.setHandlerForJavaScript("wheel", onwheel);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerleave() {
        return this.getEventHandler("pointerleave");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerleave(Object onpointerleave) {
        this.setHandlerForJavaScript("pointerleave", onpointerleave);
    }

    @JsxGetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public org.htmlunit.corejs.javascript.Function getOnbeforeprint() {
        return this.getEventHandler("beforeprint");
    }

    @JsxSetter(value={SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void setOnbeforeprint(Object onbeforeprint) {
        this.setHandlerForJavaScript("beforeprint", onbeforeprint);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnstorage() {
        return this.getEventHandler("storage");
    }

    @JsxSetter
    public void setOnstorage(Object onstorage) {
        this.setHandlerForJavaScript("storage", onstorage);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnanimationstart() {
        return this.getEventHandler("animationstart");
    }

    @JsxSetter
    public void setOnanimationstart(Object onanimationstart) {
        this.setHandlerForJavaScript("animationstart", onanimationstart);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOntimeupdate() {
        return this.getEventHandler("timeupdate");
    }

    @JsxSetter
    public void setOntimeupdate(Object ontimeupdate) {
        this.setHandlerForJavaScript("timeupdate", ontimeupdate);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnpagehide() {
        return this.getEventHandler("pagehide");
    }

    @JsxSetter
    public void setOnpagehide(Object onpagehide) {
        this.setHandlerForJavaScript("pagehide", onpagehide);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnwebkitanimationiteration() {
        return this.getEventHandler("webkitanimationiteration");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkitanimationiteration(Object onwebkitanimationiteration) {
        this.setHandlerForJavaScript("webkitanimationiteration", onwebkitanimationiteration);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnabort() {
        return this.getEventHandler("abort");
    }

    @JsxSetter
    public void setOnabort(Object onabort) {
        this.setHandlerForJavaScript("abort", onabort);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnloadedmetadata() {
        return this.getEventHandler("loadedmetadata");
    }

    @JsxSetter
    public void setOnloadedmetadata(Object onloadedmetadata) {
        this.setHandlerForJavaScript("loadedmetadata", onloadedmetadata);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseup() {
        return this.getEventHandler("mouseup");
    }

    @JsxSetter
    public void setOnmouseup(Object onmouseup) {
        this.setHandlerForJavaScript("mouseup", onmouseup);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragover() {
        return this.getEventHandler("dragover");
    }

    @JsxSetter
    public void setOndragover(Object ondragover) {
        this.setHandlerForJavaScript("dragover", ondragover);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnonline() {
        return this.getEventHandler("online");
    }

    @JsxSetter
    public void setOnonline(Object ononline) {
        this.setHandlerForJavaScript("online", ononline);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnsearch() {
        return this.getEventHandler("search");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnsearch(Object onsearch) {
        this.setHandlerForJavaScript("search", onsearch);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOninput() {
        return this.getEventHandler("input");
    }

    @JsxSetter
    public void setOninput(Object oninput) {
        this.setHandlerForJavaScript("input", oninput);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnwebkittransitionend() {
        return this.getEventHandler("webkittransitionend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkittransitionend(Object onwebkittransitionend) {
        this.setHandlerForJavaScript("webkittransitionend", onwebkittransitionend);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndevicemotion() {
        return this.getEventHandler("devicemotion");
    }

    @JsxSetter
    public void setOndevicemotion(Object ondevicemotion) {
        this.setHandlerForJavaScript("devicemotion", ondevicemotion);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnstalled() {
        return this.getEventHandler("stalled");
    }

    @JsxSetter
    public void setOnstalled(Object onstalled) {
        this.setHandlerForJavaScript("stalled", onstalled);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnmouseenter() {
        return this.getEventHandler("mouseenter");
    }

    @JsxSetter
    public void setOnmouseenter(Object onmouseenter) {
        this.setHandlerForJavaScript("mouseenter", onmouseenter);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragleave() {
        return this.getEventHandler("dragleave");
    }

    @JsxSetter
    public void setOndragleave(Object ondragleave) {
        this.setHandlerForJavaScript("dragleave", ondragleave);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnpointerdown() {
        return this.getEventHandler("pointerdown");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnpointerdown(Object onpointerdown) {
        this.setHandlerForJavaScript("pointerdown", onpointerdown);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndrop() {
        return this.getEventHandler("drop");
    }

    @JsxSetter
    public void setOndrop(Object ondrop) {
        this.setHandlerForJavaScript("drop", ondrop);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnunload() {
        return this.getEventHandler("unload");
    }

    @JsxSetter
    public void setOnunload(Object onunload) {
        this.setHandlerForJavaScript("unload", onunload);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOnwebkitanimationend() {
        return this.getEventHandler("webkitanimationend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOnwebkitanimationend(Object onwebkitanimationend) {
        this.setHandlerForJavaScript("webkitanimationend", onwebkitanimationend);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOndragstart() {
        return this.getEventHandler("dragstart");
    }

    @JsxSetter
    public void setOndragstart(Object ondragstart) {
        this.setHandlerForJavaScript("dragstart", ondragstart);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOntransitionend() {
        return this.getEventHandler("transitionend");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOntransitionend(Object ontransitionend) {
        this.setHandlerForJavaScript("transitionend", ontransitionend);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOndeviceorientationabsolute() {
        return this.getEventHandler("deviceorientationabsolute");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOndeviceorientationabsolute(Object ondeviceorientationabsolute) {
        this.setHandlerForJavaScript("deviceorientationabsolute", ondeviceorientationabsolute);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnvolumechange() {
        return this.getEventHandler("volumechange");
    }

    @JsxSetter
    public void setOnvolumechange(Object onvolumechange) {
        this.setHandlerForJavaScript("volumechange", onvolumechange);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public org.htmlunit.corejs.javascript.Function getOngotpointercapture() {
        return this.getEventHandler("gotpointercapture");
    }

    @JsxSetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE})
    public void setOngotpointercapture(Object ongotpointercapture) {
        this.setHandlerForJavaScript("gotpointercapture", ongotpointercapture);
    }

    @JsxGetter
    public org.htmlunit.corejs.javascript.Function getOnpopstate() {
        return this.getEventHandler("popstate");
    }

    @JsxSetter
    public void setOnpopstate(Object onpopstate) {
        this.setHandlerForJavaScript("popstate", onpopstate);
    }

    @Override
    public BrowserVersion getBrowserVersion() {
        return this.getWebWindow().getWebClient().getBrowserVersion();
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        Slot slot;
        if ("event".equals(name) && (slot = this.querySlot(Context.getCurrentContext(), "event")) instanceof AccessorSlot) {
            this.delete("event");
        }
        super.put(name, start, value);
    }

    @JsxGetter
    public boolean getIsSecureContext() {
        Page page = this.getWebWindow().getEnclosedPage();
        if (page != null) {
            String protocol = page.getUrl().getProtocol();
            if ("https".equals(protocol) || "wss".equals(protocol) || "file".equals(protocol)) {
                return true;
            }
            String host = page.getUrl().getHost();
            if ("localhost".equals(host) || "localhost.".equals(host) || host.endsWith(".localhost") || host.endsWith(".localhost.")) {
                return true;
            }
        }
        return false;
    }

    static {
        try {
            GETTER_LENGTH = Window.class.getDeclaredMethod("jsGetLength", new Class[0]);
            SETTER_LENGTH = Window.class.getDeclaredMethod("jsSetLength", Scriptable.class);
            GETTER_SELF = Window.class.getDeclaredMethod("jsGetSelf", new Class[0]);
            SETTER_SELF = Window.class.getDeclaredMethod("jsSetSelf", Scriptable.class);
            GETTER_PARENT = Window.class.getDeclaredMethod("jsGetParent", new Class[0]);
            SETTER_PARENT = Window.class.getDeclaredMethod("jsSetParent", Scriptable.class);
            GETTER_FRAMES = Window.class.getDeclaredMethod("jsGetFrames", new Class[0]);
            SETTER_FRAMES = Window.class.getDeclaredMethod("jsSetFrames", Scriptable.class);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static final class AnimationFrame {
        private final long id_;
        private final org.htmlunit.corejs.javascript.Function callback_;

        AnimationFrame(long id, org.htmlunit.corejs.javascript.Function callback) {
            this.id_ = id;
            this.callback_ = callback;
        }
    }

    private static final class Filter {
        private final boolean includeFormFields_;

        Filter(boolean includeFormFields) {
            this.includeFormFields_ = includeFormFields;
        }

        boolean matches(Object object) {
            if (object instanceof HtmlEmbed || object instanceof HtmlForm || object instanceof HtmlImage || object instanceof HtmlObject) {
                return true;
            }
            return this.includeFormFields_ && (object instanceof HtmlAnchor || object instanceof HtmlButton || object instanceof HtmlInput || object instanceof HtmlMap || object instanceof HtmlSelect || object instanceof HtmlTextArea);
        }
    }
}

