/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.htmlunit.ElementNotFoundException;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlCaption;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlTableBody;
import org.htmlunit.html.HtmlTableCell;
import org.htmlunit.html.HtmlTableFooter;
import org.htmlunit.html.HtmlTableHeader;
import org.htmlunit.html.HtmlTableRow;
import org.htmlunit.html.TableRowGroup;

public class HtmlTable
extends HtmlElement {
    public static final String TAG_NAME = "table";

    HtmlTable(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    public final HtmlTableCell getCellAt(int rowIndex, int columnIndex) {
        RowIterator rowIterator = this.getRowIterator();
        HashSet<Position> occupied = new HashSet<Position>();
        int row = 0;
        for (HtmlTableRow htmlTableRow : rowIterator) {
            HtmlTableRow.CellIterator cellIterator = htmlTableRow.getCellIterator();
            int col = 0;
            for (HtmlTableCell cell : cellIterator) {
                while (occupied.contains(new Position(row, col))) {
                    ++col;
                }
                int nextRow = row + cell.getRowSpan();
                if (row <= rowIndex && nextRow > rowIndex) {
                    int nextCol = col + cell.getColumnSpan();
                    if (col <= columnIndex && nextCol > columnIndex) {
                        return cell;
                    }
                }
                if (cell.getRowSpan() > 1 || cell.getColumnSpan() > 1) {
                    for (int i = 0; i < cell.getRowSpan(); ++i) {
                        for (int j = 0; j < cell.getColumnSpan(); ++j) {
                            occupied.add(new Position(row + i, col + j));
                        }
                    }
                }
                ++col;
            }
            ++row;
        }
        return null;
    }

    private RowIterator getRowIterator() {
        return new RowIterator(this);
    }

    public List<HtmlTableRow> getRows() {
        ArrayList<HtmlTableRow> result = new ArrayList<HtmlTableRow>();
        for (HtmlTableRow row : this.getRowIterator()) {
            result.add(row);
        }
        return Collections.unmodifiableList(result);
    }

    public HtmlTableRow getRow(int index) throws IndexOutOfBoundsException {
        int count = 0;
        for (HtmlTableRow row : this.getRowIterator()) {
            if (count == index) {
                return row;
            }
            ++count;
        }
        throw new IndexOutOfBoundsException("No row found for index " + index + ".");
    }

    public final int getRowCount() {
        int count = 0;
        RowIterator iterator = this.getRowIterator();
        while (iterator.hasNext()) {
            ++count;
            iterator.next();
        }
        return count;
    }

    public final HtmlTableRow getRowById(String id) throws ElementNotFoundException {
        for (HtmlTableRow row : this.getRowIterator()) {
            if (!row.getId().equals(id)) continue;
            return row;
        }
        throw new ElementNotFoundException("tr", "id", id);
    }

    public String getCaptionText() {
        for (DomElement element : this.getChildElements()) {
            if (!(element instanceof HtmlCaption)) continue;
            return element.asNormalizedText();
        }
        return null;
    }

    public HtmlTableHeader getHeader() {
        for (DomElement element : this.getChildElements()) {
            if (!(element instanceof HtmlTableHeader)) continue;
            return (HtmlTableHeader)element;
        }
        return null;
    }

    public HtmlTableFooter getFooter() {
        for (DomElement element : this.getChildElements()) {
            if (!(element instanceof HtmlTableFooter)) continue;
            return (HtmlTableFooter)element;
        }
        return null;
    }

    public List<HtmlTableBody> getBodies() {
        ArrayList<HtmlTableBody> bodies = new ArrayList<HtmlTableBody>();
        for (DomElement element : this.getChildElements()) {
            if (!(element instanceof HtmlTableBody)) continue;
            bodies.add((HtmlTableBody)element);
        }
        return bodies;
    }

    public final String getSummaryAttribute() {
        return this.getAttributeDirect("summary");
    }

    public final String getWidthAttribute() {
        return this.getAttributeDirect("width");
    }

    public final String getBorderAttribute() {
        return this.getAttributeDirect("border");
    }

    public final String getFrameAttribute() {
        return this.getAttributeDirect("frame");
    }

    public final String getRulesAttribute() {
        return this.getAttributeDirect("rules");
    }

    public final String getCellSpacingAttribute() {
        return this.getAttributeDirect("cellspacing");
    }

    public final String getCellPaddingAttribute() {
        return this.getAttributeDirect("cellpadding");
    }

    public final String getAlignAttribute() {
        return this.getAttributeDirect("align");
    }

    public final String getBgcolorAttribute() {
        return this.getAttributeDirect("bgcolor");
    }

    @Override
    protected boolean isEmptyXmlTagExpanded() {
        return true;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.TABLE;
    }

    private class RowIterator
    implements Iterator<HtmlTableRow>,
    Iterable<HtmlTableRow> {
        private HtmlTableRow nextRow_;
        private TableRowGroup currentGroup_;

        RowIterator(HtmlTable htmlTable) {
            this.setNextRow(htmlTable.getFirstChild());
        }

        @Override
        public boolean hasNext() {
            return this.nextRow_ != null;
        }

        @Override
        public HtmlTableRow next() throws NoSuchElementException {
            return this.nextRow();
        }

        @Override
        public void remove() {
            if (this.nextRow_ == null) {
                throw new IllegalStateException();
            }
            DomNode sibling = this.nextRow_.getPreviousSibling();
            if (sibling != null) {
                sibling.remove();
            }
        }

        public HtmlTableRow nextRow() throws NoSuchElementException {
            if (this.nextRow_ != null) {
                HtmlTableRow result = this.nextRow_;
                this.setNextRow(this.nextRow_.getNextSibling());
                return result;
            }
            throw new NoSuchElementException();
        }

        private void setNextRow(DomNode node) {
            this.nextRow_ = null;
            for (DomNode next = node; next != null; next = next.getNextSibling()) {
                if (next instanceof HtmlTableRow) {
                    this.nextRow_ = (HtmlTableRow)next;
                    return;
                }
                if (this.currentGroup_ != null || !(next instanceof TableRowGroup)) continue;
                this.currentGroup_ = (TableRowGroup)next;
                this.setNextRow(next.getFirstChild());
                return;
            }
            if (this.currentGroup_ != null) {
                TableRowGroup group = this.currentGroup_;
                this.currentGroup_ = null;
                this.setNextRow(group.getNextSibling());
            }
        }

        @Override
        public Iterator<HtmlTableRow> iterator() {
            return this;
        }
    }

    private static final class Position {
        private final int posX_;
        private final int posY_;

        Position(int x, int y) {
            this.posX_ = x;
            this.posY_ = y;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.posX_;
            result = 31 * result + this.posY_;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Position other = (Position)obj;
            if (this.posX_ != other.posX_) {
                return false;
            }
            return this.posY_ == other.posY_;
        }
    }
}

