/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit;

import java.io.IOException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.htmlunit.Page;
import org.htmlunit.RefreshHandler;
import org.htmlunit.WaitingRefreshHandler;

public class ThreadedRefreshHandler
implements RefreshHandler {
    private static final Log LOG = LogFactory.getLog(ThreadedRefreshHandler.class);

    @Override
    public void handleRefresh(final Page page, final URL url, final int seconds) {
        Thread thread = new Thread(this, "ThreadedRefreshHandler Thread"){

            @Override
            public void run() {
                try {
                    new WaitingRefreshHandler().handleRefresh(page, url, seconds);
                }
                catch (IOException e) {
                    LOG.error((Object)"Unable to refresh page!", (Throwable)e);
                    throw new RuntimeException("Unable to refresh page!", e);
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }
}

