/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.util;

import com.xceptance.common.lang.StringUtils;
import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.common.util.ProductInformation;
import com.xceptance.common.util.PropertiesUtils;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.api.util.XltRandom;
import com.xceptance.xlt.engine.XltEngine;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.engine.util.PropertyIncludeResolver;
import com.xceptance.xlt.util.PropertiesConfigurationException;
import com.xceptance.xlt.util.PropertiesIOException;
import com.xceptance.xlt.util.PropertyFileNotFoundException;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;

public class XltPropertiesImpl
extends XltProperties {
    private final VarSubstitutionSupportedProperties mergedProperties = new VarSubstitutionSupportedProperties();
    private final LinkedHashMap<String, DetailedProperties> propertyBuckets = new LinkedHashMap();
    private final LinkedHashMap<String, Properties> cachedPropertyBuckets = new LinkedHashMap();
    private long startTime = -1L;
    private String version;
    private Path homeDirectory;
    private Path configDirectory;
    private final boolean collectAdditonalRequestData;
    private final boolean collectUsedIpAddress;
    private final boolean removeUserInfoFromRequestUrl;
    private final boolean devMode;

    public static XltPropertiesImpl createInstance(boolean ignoreMissing, boolean staySilent) {
        return new XltPropertiesImpl(null, null, ignoreMissing, staySilent);
    }

    public static XltPropertiesImpl getInstance() {
        return XltEngine.get().xltProperties;
    }

    public XltPropertiesImpl(FileObject homeDirectory, FileObject configDirectory, boolean ignoreMissingIncludes, boolean staySilent) {
        this(homeDirectory, configDirectory, System.getenv("XLT_HOME") == null && System.getProperty("com.xceptance.xlt.home") == null, ignoreMissingIncludes, staySilent);
    }

    public XltPropertiesImpl(FileObject homeDirectory, FileObject configDirectory, boolean devMode, boolean ignoreMissingIncludes, boolean staySilent) {
        this.devMode = devMode;
        this.initialize(homeDirectory, configDirectory, ignoreMissingIncludes, staySilent);
        this.collectAdditonalRequestData = this.getProperty("XltPropertiesImpl", "XLTNoSuchUser-00000", "com.xceptance.xlt.results.data.request.collectAdditionalRequestInfo").map(Boolean::valueOf).orElse(false);
        this.collectUsedIpAddress = this.getProperty("XltPropertiesImpl", "XLTNoSuchUser-00000", "com.xceptance.xlt.results.data.request.collectUsedIpAddress").map(Boolean::valueOf).orElse(false);
        this.removeUserInfoFromRequestUrl = this.getProperty("XltPropertiesImpl", "XLTNoSuchUser-00000", "com.xceptance.xlt.results.data.request.removeUserInfoFromURL").map(Boolean::valueOf).orElse(true);
    }

    public XltPropertiesImpl() {
        this(Optional.empty());
    }

    public XltPropertiesImpl(Properties properties) {
        this(Optional.ofNullable(properties));
    }

    public XltPropertiesImpl(Optional<Properties> properties) {
        this.homeDirectory = XltExecutionContext.getCurrent().getTestSuiteHomeDir().getPath();
        this.configDirectory = XltExecutionContext.getCurrent().getTestSuiteConfigDir().getPath();
        this.devMode = System.getenv("XLT_HOME") == null && System.getProperty("com.xceptance.xlt.home") == null;
        this.version = ProductInformation.getProductInformation().getVersion();
        this.startTime = GlobalClock.millis();
        this.mergedProperties.putAll(properties.orElse(new Properties()));
        this.collectAdditonalRequestData = false;
        this.collectUsedIpAddress = false;
        this.removeUserInfoFromRequestUrl = true;
    }

    private synchronized void initialize(FileObject homeDirectory, FileObject configDirectory, boolean ignoreMissingIncludes, boolean staySilent) {
        this.clear();
        FileObject hd = homeDirectory == null ? XltExecutionContext.getCurrent().getTestSuiteHomeDir() : homeDirectory;
        FileObject cd = configDirectory == null ? XltExecutionContext.getCurrent().getTestSuiteConfigDir() : configDirectory;
        this.loadProperties(hd, cd, ignoreMissingIncludes, staySilent);
        this.homeDirectory = hd.getPath();
        this.configDirectory = cd.getPath();
        this.version = ProductInformation.getProductInformation().getVersion();
        this.startTime = GlobalClock.millis();
    }

    private void loadProperties(FileObject homeDirectory, FileObject configDirectory, boolean ignoreMissingIncludes, boolean staySilent) {
        this.process(homeDirectory, configDirectory, "default.properties", "DEFAULT", true, ignoreMissingIncludes, s -> s);
        this.process(homeDirectory, configDirectory, "project.properties", "PROJECT", true, ignoreMissingIncludes, s -> s);
        Properties temp = new Properties();
        temp.putAll((Map<?, ?>)this.mergedProperties);
        temp.putAll((Map<?, ?>)System.getProperties());
        String testPropertiesFile = temp.getProperty("com.xceptance.xlt.testPropertiesFile");
        if (testPropertiesFile != null) {
            this.process(homeDirectory, configDirectory, testPropertiesFile, "TEST", false, ignoreMissingIncludes, s -> s);
        } else if (!staySilent) {
            XltLogger.runTimeLogger.warn("No test property file was referenced.", (Object)"com.xceptance.xlt.testPropertiesFile");
        }
        if (this.devMode) {
            this.process(homeDirectory, configDirectory, "dev.properties", "DEVELOPMENT", true, ignoreMissingIncludes, s -> s);
        }
        this.process(homeDirectory, configDirectory, "secret.properties", "SECRET", true, ignoreMissingIncludes, s -> s.startsWith("secret.") ? s : "secret." + s);
        this.mergedProperties.putAll(System.getProperties());
        this.cachedPropertyBuckets.put("SYSTEM", System.getProperties());
        if (XltLogger.runTimeLogger.isTraceEnabled()) {
            XltLogger.runTimeLogger.trace("--- >>> Final Properties ---------------------------------------------");
            this.dumpAllProperties().forEach(s -> XltLogger.runTimeLogger.trace("| " + s));
            XltLogger.runTimeLogger.trace("--- <<< --------------------------------------------------------------");
        }
    }

    private void process(FileObject homeDirectory, FileObject configDirectory, String fileName, String bucketName, boolean ignoreMissing, boolean ignoreMissingIncludes, Function<String, String> keyTransformer) {
        Optional<PropertyIncludeResolver.PropertyInclude> propFile = this.getFile(configDirectory, fileName);
        if (propFile.isEmpty() && !ignoreMissing) {
            throw new PropertyFileNotFoundException(String.format("Unable to locate property file %s.", fileName));
        }
        boolean exists = false;
        try {
            exists = propFile.get().file.exists();
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        if (!exists && !ignoreMissing) {
            throw new PropertyFileNotFoundException(String.format("Property file %s does not exist", XltPropertiesImpl.makeRelativeTo(propFile.get().file, homeDirectory, fileName)));
        }
        if (!exists && ignoreMissing) {
            return;
        }
        if (XltLogger.runTimeLogger.isDebugEnabled()) {
            XltLogger.runTimeLogger.debug(String.format("Trying to evaluate property file: %s ...", propFile.get().file));
        }
        List<PropertyIncludeResolver.PropertyIncludeResult> includeResult = PropertyIncludeResolver.resolve(homeDirectory, configDirectory, List.of(propFile.get()));
        includeResult = this.verifyFiles(includeResult, ignoreMissing, ignoreMissingIncludes);
        Optional firstName = Optional.empty();
        VarSubstitutionSupportedProperties newProperties = new VarSubstitutionSupportedProperties();
        for (PropertyIncludeResolver.PropertyIncludeResult include : includeResult) {
            if (XltLogger.runTimeLogger.isDebugEnabled()) {
                String msg = firstName.isEmpty() ? String.format("Loading from property file: %s ...", include.name) : String.format("Loading from include file %s of %s ...", include.name, firstName.get());
                XltLogger.runTimeLogger.debug(msg);
                firstName = firstName.or(() -> Optional.of(include.name));
            }
            try {
                Properties p = PropertiesUtils.loadProperties(include.file);
                newProperties.putAll(p, keyTransformer);
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error(String.format("Issues loading properties from %s", fileName), (Throwable)e);
                throw new PropertiesIOException(String.format("Issues loading properties from %s", fileName));
            }
        }
        this.propertyBuckets.put(bucketName, new DetailedProperties(fileName, newProperties, includeResult));
        this.cachedPropertyBuckets.put(bucketName, newProperties);
        if (XltLogger.runTimeLogger.isTraceEnabled()) {
            String l = fileName + " ------------------------------------------------";
            XltLogger.runTimeLogger.trace("--- >>> " + l);
            this.dumpProperties(newProperties).forEach(s -> XltLogger.runTimeLogger.trace("| " + s));
            XltLogger.runTimeLogger.trace("--- <<< " + Stream.generate(() -> "-").limit(l.length()).collect(Collectors.joining()));
        }
        this.mergedProperties.putAll(newProperties);
    }

    private List<PropertyIncludeResolver.PropertyIncludeResult> verifyFiles(List<PropertyIncludeResolver.PropertyIncludeResult> files, boolean ignoreMissing, boolean ignoreMissingIncludes) {
        ArrayList<PropertyIncludeResolver.PropertyIncludeResult> newFiles = new ArrayList<PropertyIncludeResolver.PropertyIncludeResult>();
        for (PropertyIncludeResolver.PropertyIncludeResult file : files) {
            String msg;
            if (file.outsideORootDirScope) {
                msg = String.format("File %s is outside of the permitted scope. This error cannot be ignored.", file.name);
                XltLogger.runTimeLogger.error(msg);
                throw new PropertiesConfigurationException(msg);
            }
            if (file.seenBefore) {
                if (ignoreMissingIncludes && file.isInclude) {
                    msg = String.format("File %s has been seen multiple times when resolving properties, this can indicate a cyclic include pattern but also just be a repeated reference. Ignoring for the moment.", file.name);
                    XltLogger.runTimeLogger.warn(msg);
                    continue;
                }
                msg = String.format("File %s has been seen multiple times when resolving properties, this can indicate a cyclic include pattern but also just be a repeated reference.", file.name);
                XltLogger.runTimeLogger.error(msg);
                throw new PropertiesConfigurationException(msg);
            }
            if (!file.exists) {
                if (file.isInclude && ignoreMissingIncludes) {
                    msg = String.format("Property include file %s does not exist. Ignoring.", file.name);
                    XltLogger.runTimeLogger.warn(msg);
                    continue;
                }
                if (ignoreMissing && !file.isInclude) {
                    msg = String.format("Property file %s does not exist. Ignoring.", file.name);
                    XltLogger.runTimeLogger.warn(msg);
                    continue;
                }
                msg = String.format("File %s does not exist", file.name);
                XltLogger.runTimeLogger.error(msg);
                throw new PropertyFileNotFoundException(msg);
            }
            newFiles.add(file);
        }
        return newFiles;
    }

    private Optional<PropertyIncludeResolver.PropertyInclude> getFile(FileObject configDir, String fileName) {
        try {
            FileObject file = configDir.resolveFile(fileName);
            return Optional.of(new PropertyIncludeResolver.PropertyInclude(file, fileName));
        }
        catch (FileSystemException fse) {
            XltLogger.runTimeLogger.error("Unable to read or open property file", (Throwable)fse);
            return Optional.empty();
        }
    }

    public List<String> dumpAllProperties() {
        return this.dumpProperties(this.mergedProperties);
    }

    protected List<String> dumpProperties(Properties source) {
        ArrayList<String> result = new ArrayList<String>(500);
        for (Map.Entry<Object, Object> entry : source.entrySet()) {
            String k = (String)entry.getKey();
            Object v = k.startsWith("secret.") ? "******" : entry.getValue();
            result.add(k + " = " + String.valueOf(v));
        }
        Collections.sort(result);
        return result;
    }

    private static String makeRelativeTo(FileObject file, FileObject targetDirectory, String fallback) {
        try {
            int depthPivot;
            int depthResolved;
            ArrayList<String> pathSegments = new ArrayList<String>();
            FileObject tmp = targetDirectory;
            FileObject tmp2 = file;
            if (depthResolved < depthPivot) {
                for (depthPivot = targetDirectory.getName().getDepth() + 1; depthResolved < depthPivot; --depthPivot) {
                    tmp = tmp.getParent();
                    pathSegments.add("..");
                }
            } else if (depthResolved > depthPivot) {
                for (depthResolved = file.getName().getDepth(); depthResolved > depthPivot; --depthResolved) {
                    tmp2 = tmp2.getParent();
                    pathSegments.add(0, tmp2.getName().getBaseName());
                }
            }
            if (!tmp2.getParent().equals((Object)tmp)) {
                throw new IllegalArgumentException(String.format("Paths '%s' and '%s' do not have a common ancestor.", file.getName().getPath(), targetDirectory.getName().getPath()));
            }
            pathSegments.add(file.getName().getBaseName());
            return pathSegments.stream().collect(Collectors.joining("/"));
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.warn(e.getMessage());
            return fallback;
        }
    }

    @Override
    public boolean containsKey(String key) {
        return this.mergedProperties.containsKey("secret." + key) || this.mergedProperties.containsKey(key);
    }

    @Override
    public final Properties getCopyOfProperties() {
        Properties copy = new Properties();
        for (Object k : this.mergedProperties.keySet()) {
            String key = (String)k;
            copy.setProperty(key, this.mergedProperties.getProperty(key));
        }
        return copy;
    }

    @Override
    public Properties getProperties() {
        return this.mergedProperties;
    }

    @Override
    public Map<String, String> getPropertiesForKey(String domainKey) {
        return PropertiesUtils.getPropertiesForKey(domainKey, this.mergedProperties);
    }

    @Override
    public String getEffectiveKey(Session session, String bareKey) {
        if (session != null) {
            return this.getEffectiveKey(session.getTestCaseClassName(), session.getUserName(), bareKey);
        }
        String nonPrefixedKey = this.getNonPrefixedKey(bareKey);
        return this.getEffectiveKey_Step3(nonPrefixedKey, bareKey);
    }

    private String getNonPrefixedKey(String bareKey) {
        return bareKey.startsWith("secret.") ? bareKey.substring("secret.".length()) : bareKey;
    }

    @Override
    public String getEffectiveKey(String testCaseClassName, String userName, String bareKey) {
        String nonPrefixedKey = this.getNonPrefixedKey(bareKey);
        String userNameQualifiedSecretKey = "secret." + userName + "." + nonPrefixedKey;
        if (this.mergedProperties.containsKey(userNameQualifiedSecretKey)) {
            return userNameQualifiedSecretKey;
        }
        String userNameQualifiedKey = userName + "." + bareKey;
        if (this.mergedProperties.containsKey(userNameQualifiedKey)) {
            return userNameQualifiedKey;
        }
        String classNameQualifiedSecretKey = "secret." + testCaseClassName + "." + nonPrefixedKey;
        if (this.mergedProperties.containsKey(classNameQualifiedSecretKey)) {
            return classNameQualifiedSecretKey;
        }
        String classNameQualifiedKey = testCaseClassName + "." + bareKey;
        if (this.mergedProperties.containsKey(classNameQualifiedKey)) {
            return classNameQualifiedKey;
        }
        return this.getEffectiveKey_Step3(nonPrefixedKey, bareKey);
    }

    private String getEffectiveKey_Step3(String nonPrefixedKey, String bareKey) {
        String secretKey = "secret." + nonPrefixedKey;
        if (this.mergedProperties.containsKey(secretKey)) {
            return secretKey;
        }
        return bareKey;
    }

    @Override
    public Optional<String> getProperty(Session session, String key) {
        return this.getProperty(session.getTestCaseClassName(), session.getUserName(), key);
    }

    public Optional<String> getPropertySessionLess(String key) {
        String nonPrefixedKey = this.getNonPrefixedKey(key);
        String finalKey = this.getEffectiveKey_Step3(nonPrefixedKey, key);
        return Optional.ofNullable(this.mergedProperties.getProperty(finalKey));
    }

    @Override
    public String getProperty(String key) {
        return this.getProperty(Session.getCurrent(), key).orElse(null);
    }

    public Optional<String> getProperty(String testCaseClassName, String userName, String key) {
        String effectiveKey = this.getEffectiveKey(testCaseClassName, userName, key);
        return Optional.ofNullable(this.mergedProperties.getProperty(effectiveKey));
    }

    @Override
    public boolean getProperty(String key, boolean defaultValue) {
        String valueString = this.getProperty(key);
        if (valueString != null) {
            return Boolean.valueOf(valueString);
        }
        return defaultValue;
    }

    @Override
    public int getProperty(String key, int defaultValue) {
        String valueString = this.getProperty(key);
        if (valueString != null) {
            try {
                return Integer.parseInt(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public long getProperty(String key, long defaultValue) {
        String valueString = this.getProperty(key);
        if (valueString != null) {
            try {
                return Long.parseLong(valueString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public String getProperty(String key, String defaultValue) {
        String value = this.getProperty(key);
        return value != null ? value : defaultValue;
    }

    @Override
    public String getPropertyRandomValue(String key, String defaultValue) {
        String value = this.getProperty(key, defaultValue);
        if (value == null) {
            return "";
        }
        String[] values = StringUtils.split(value, "[ ,;]");
        return values[XltRandom.nextInt(values.length)];
    }

    @Override
    public long getStartTime() {
        return this.startTime;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public Path getConfigDirectory() {
        return this.configDirectory;
    }

    @Override
    public Path getDataDirectory() {
        String propDir = this.getProperty("com.xceptance.xlt.data.directory");
        Path path = Paths.get(org.apache.commons.lang3.StringUtils.isBlank((CharSequence)propDir) ? "config/data" : propDir, new String[0]);
        if (!path.isAbsolute()) {
            return this.homeDirectory.resolve(path);
        }
        return path;
    }

    @Override
    public void removeProperty(String key) {
        ParameterCheckUtils.isNotNull(key, "key");
        this.mergedProperties.remove(key);
    }

    @Override
    public void setProperties(Properties newProperties) {
        ParameterCheckUtils.isNotNull(newProperties, "newProperties");
        this.mergedProperties.putAll(newProperties);
    }

    @Override
    public void setProperty(String key, String value) {
        ParameterCheckUtils.isNotNull(key, "key");
        ParameterCheckUtils.isNotNull(value, "value");
        this.mergedProperties.setProperty(key, value);
    }

    @Override
    public LinkedHashMap<String, Properties> getPropertyBuckets() {
        return this.cachedPropertyBuckets;
    }

    public FileObject getTestPropertyFile(boolean fallbackToProjectProperties) {
        DetailedProperties bucket = this.propertyBuckets.get("TEST");
        if (bucket != null && !bucket.propertyChain.isEmpty()) {
            return bucket.propertyChain.get((int)0).file;
        }
        if (fallbackToProjectProperties && (bucket = this.propertyBuckets.get("PROJECT")) != null && !bucket.propertyChain.isEmpty()) {
            return bucket.propertyChain.get((int)0).file;
        }
        return null;
    }

    @Override
    public synchronized XltProperties clear() {
        this.mergedProperties.clear();
        this.cachedPropertyBuckets.clear();
        this.propertyBuckets.clear();
        return this;
    }

    public List<FileObject> getUsedPropertyFiles() {
        ArrayList<FileObject> r = new ArrayList<FileObject>();
        this.propertyBuckets.values().forEach(p -> p.propertyChain.forEach(i -> r.add(i.file)));
        return r;
    }

    public List<String> getUsedPropertyFilesByRelativeName() {
        ArrayList<String> r = new ArrayList<String>();
        this.propertyBuckets.values().forEach(p -> p.propertyChain.forEach(i -> r.add(i.name)));
        return r;
    }

    @Override
    public boolean isDevMode() {
        return this.devMode;
    }

    @Override
    public boolean isLoadTest() {
        return !this.devMode;
    }

    public boolean collectAdditonalRequestData() {
        return XltPropertiesImpl.getInstance().collectAdditonalRequestData;
    }

    public boolean collectUsedIpAddress() {
        return XltPropertiesImpl.getInstance().collectUsedIpAddress;
    }

    public boolean removeUserInfoFromRequestUrl() {
        return XltPropertiesImpl.getInstance().removeUserInfoFromRequestUrl;
    }

    private static class VarSubstitutionSupportedProperties
    extends Properties {
        private static final long serialVersionUID = -9202819207114231133L;

        private VarSubstitutionSupportedProperties() {
        }

        @Override
        public String getProperty(String key) {
            String val = super.getProperty(key);
            return val == null ? null : PropertiesUtils.substituteVariables(val, this);
        }

        @Override
        public Object put(Object key, Object value) {
            if (null == key || null == value) {
                return null;
            }
            return super.put(key, ((String)value).trim());
        }

        @Override
        public void putAll(Map<? extends Object, ? extends Object> map) {
            for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
                this.put(entry.getKey(), entry.getValue());
            }
        }

        public void putAll(Map<? extends Object, ? extends Object> map, Function<String, String> keyTransformer) {
            for (Map.Entry<? extends Object, ? extends Object> entry : map.entrySet()) {
                this.put(keyTransformer.apply((String)entry.getKey()), entry.getValue());
            }
        }
    }

    public static class DetailedProperties {
        public final String relativeName;
        public final Properties properties;
        public final List<PropertyIncludeResolver.PropertyIncludeResult> propertyChain;

        public DetailedProperties(String relativeName, Properties properties, List<PropertyIncludeResolver.PropertyIncludeResult> propertyChain) {
            this.relativeName = relativeName;
            this.properties = properties;
            this.propertyChain = propertyChain;
        }
    }
}

