/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.IntLowPrecisionValueSet;

public class IntMinMaxValue {
    private long accumulatedValue;
    private int maximum = Integer.MIN_VALUE;
    private int minimum = Integer.MAX_VALUE;
    private int valueCount;
    private final IntLowPrecisionValueSet valueSet = new IntLowPrecisionValueSet();

    public IntMinMaxValue(int value) {
        this.valueSet.addValue(value);
        this.accumulatedValue = value;
        this.maximum = value;
        this.minimum = value;
        this.valueCount = 1;
    }

    public long getAccumulatedValue() {
        return this.accumulatedValue;
    }

    public int getAverageValue() {
        return (int)(this.accumulatedValue / (long)this.valueCount);
    }

    public int getMaximumValue() {
        return this.maximum == Integer.MIN_VALUE ? 0 : this.maximum;
    }

    public int getMinimumValue() {
        return this.minimum == Integer.MAX_VALUE ? 0 : this.minimum;
    }

    public int getValue() {
        return this.getAverageValue();
    }

    public double[] getValues() {
        return this.valueSet.getValues();
    }

    public int getValueCount() {
        return this.valueCount;
    }

    IntMinMaxValue merge(IntMinMaxValue item) {
        if (item != null) {
            this.maximum = Math.max(this.maximum, item.maximum);
            this.minimum = Math.min(this.minimum, item.minimum);
            this.accumulatedValue += item.accumulatedValue;
            this.valueCount += item.valueCount;
            this.valueSet.merge(item.valueSet);
        }
        return this;
    }

    public String toString() {
        return this.getValue() + "/" + this.getAccumulatedValue() + "/" + this.getMinimumValue() + "/" + this.getMaximumValue() + "/" + this.getValueCount();
    }

    public void updateValue(int sample) {
        this.valueSet.addValue(sample);
        this.maximum = Math.max(this.maximum, sample);
        this.minimum = Math.min(this.minimum, sample);
        this.accumulatedValue += (long)sample;
        ++this.valueCount;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntMinMaxValue other = (IntMinMaxValue)obj;
        if (this.accumulatedValue != other.accumulatedValue) {
            return false;
        }
        if (this.valueSet == null ? other.valueSet != null : !this.valueSet.equals(other.valueSet)) {
            return false;
        }
        if (this.maximum != other.maximum) {
            return false;
        }
        if (this.minimum != other.minimum) {
            return false;
        }
        return this.valueCount == other.valueCount;
    }
}

