/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.common.collection.FastHashMap;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.RequestData;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.util.XltCharBuffer;
import com.xceptance.xlt.report.providers.RequestMethodReport;
import com.xceptance.xlt.report.providers.RequestMethodsReport;
import java.util.ArrayList;

public class RequestMethodsReportProvider
extends AbstractReportProvider {
    private static final XltCharBuffer UNKNOWN_REQUEST_METHOD = XltCharBuffer.valueOf("(unknown)");
    private final FastHashMap<XltCharBuffer, RequestMethodReport> requestMethodReports = new FastHashMap();

    @Override
    public Object createReportFragment() {
        RequestMethodsReport report = new RequestMethodsReport();
        report.requestMethods = new ArrayList<RequestMethodReport>(this.requestMethodReports.values());
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
        if (data instanceof RequestData) {
            RequestMethodReport requestMethodReport;
            RequestData reqData = (RequestData)data;
            XltCharBuffer method = reqData.getHttpMethod();
            if (method == null || method.length() == 0) {
                method = UNKNOWN_REQUEST_METHOD;
            }
            if ((requestMethodReport = this.requestMethodReports.get(method)) == null) {
                requestMethodReport = new RequestMethodReport();
                requestMethodReport.method = method.toString();
                this.requestMethodReports.put(method, requestMethodReport);
            }
            ++requestMethodReport.count;
        }
    }
}

