/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.providers;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.report.AbstractReportProvider;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.report.ReportGeneratorConfiguration;
import com.xceptance.xlt.report.providers.CustomLogReport;
import com.xceptance.xlt.report.providers.CustomLogsReport;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileType;

public class CustomLogsReportProvider
extends AbstractReportProvider {
    private static final String CUSTOM_DATA = "custom_data_logs";
    private Map<String, ZipOutputStream> foundScopes = new HashMap<String, ZipOutputStream>();
    private String baseDir;
    private Path targetDir = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createReportFragment() {
        CustomLogsReport report = new CustomLogsReport();
        FileObject results = ((ReportGeneratorConfiguration)this.getConfiguration()).getResultsDirectory();
        this.baseDir = results.getName().getBaseName();
        this.targetDir = Paths.get(String.valueOf(this.getConfiguration().getReportDirectory()) + File.separator + CUSTOM_DATA, new String[0]);
        try {
            this.findLogs(results, null);
        }
        catch (IOException e) {
            XltLogger.runTimeLogger.error("Failed to walk file tree searching for custom data logs. Cause: " + e.getMessage());
        }
        finally {
            this.closeAllStreams();
        }
        Set<String> scopes = this.getResult();
        for (String scope : scopes) {
            CustomLogReport clr = new CustomLogReport();
            clr.scope = scope;
            Path targetPath = Paths.get(String.valueOf(this.targetDir) + File.separator + scope + ".zip", new String[0]);
            try {
                clr.size = Files.size(targetPath);
                clr.path = CUSTOM_DATA + File.separator + scope + ".zip";
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error("Unable to collect information for custom data logs for " + scope + ". Cause: " + e.getMessage());
            }
            report.customLogs.add(clr);
        }
        return report;
    }

    @Override
    public void processDataRecord(Data data) {
    }

    @Override
    public boolean wantsDataRecords() {
        return false;
    }

    private void findLogs(FileObject file, String currentPath) throws IOException {
        String filename = file.getName().getBaseName();
        if (file.getType() == FileType.FOLDER) {
            if (!"config".equals(filename)) {
                for (FileObject fo : file.getChildren()) {
                    this.findLogs(fo, this.makePath(currentPath, filename));
                }
            }
        } else if (file.getType() == FileType.FILE && file.getName().getBaseName().toString().startsWith("custom_log_")) {
            ZipOutputStream scopeStream;
            String scopeName = filename.substring("custom_log_".length(), filename.lastIndexOf(46));
            if (this.foundScopes.isEmpty()) {
                this.targetDir.toFile().mkdirs();
            }
            if ((scopeStream = this.foundScopes.get(scopeName)) == null) {
                FileOutputStream fos = new FileOutputStream(this.targetDir.toString() + File.separator + scopeName + ".zip");
                scopeStream = new ZipOutputStream(fos);
                this.foundScopes.put(scopeName, scopeStream);
            }
            scopeStream.putNextEntry(new ZipEntry(this.makePath(currentPath, filename)));
            this.writeDataToZip(file, scopeStream);
            scopeStream.closeEntry();
        }
    }

    private String makePath(String currentPath, String currentFileName) {
        if (currentPath != null) {
            return currentPath + "/" + currentFileName;
        }
        if (this.baseDir.equals(currentFileName)) {
            return null;
        }
        return currentFileName;
    }

    private void writeDataToZip(FileObject file, ZipOutputStream scopeStream) throws IOException {
        int len;
        InputStream in = file.getContent().getInputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) > 0) {
            scopeStream.write(buffer, 0, len);
        }
        in.close();
    }

    private void closeAllStreams() {
        for (ZipOutputStream zos : this.foundScopes.values()) {
            try {
                zos.close();
            }
            catch (IOException e) {
                XltLogger.runTimeLogger.error("Unable to zip custom data logs to report. Cause: " + e.getMessage());
            }
        }
    }

    private Set<String> getResult() {
        if (!this.foundScopes.isEmpty()) {
            XltLogger.runTimeLogger.info("Found custom data logs for scopes: " + String.valueOf(this.foundScopes.keySet()));
        }
        return this.foundScopes.keySet();
    }
}

