/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.external.converter;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.report.external.config.DataFileConfig;
import java.io.File;
import java.io.IOException;

public class ConverterConfiguration
extends AbstractConfiguration {
    private static final Object SYNC = new Object();
    private static boolean INITIALIZED = false;
    private static final String PROP_PREFIX = "com.xceptance.xlt.reportgenerator.";
    private static final String PROP_CHARTS_PREFIX = "com.xceptance.xlt.reportgenerator.charts.";
    private static final String PROP_CHARTS_HEIGHT = "com.xceptance.xlt.reportgenerator.charts.height";
    private static final String PROP_CHARTS_WIDTH = "com.xceptance.xlt.reportgenerator.charts.width";
    private static int chartsWidth;
    private static int chartsHeight;
    private File externalChartsDir;
    private long minimumChartTime;
    private long maximumChartTime;
    private DataFileConfig dataFileConfig;
    private boolean noCharts;

    public ConverterConfiguration() throws IOException {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        if (!INITIALIZED) {
            Object object = SYNC;
            synchronized (object) {
                if (!INITIALIZED) {
                    File configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
                    this.loadProperties(new File(configDirectory, "reportgenerator.properties"));
                    chartsWidth = this.getIntProperty(PROP_CHARTS_WIDTH, 600);
                    chartsHeight = this.getIntProperty(PROP_CHARTS_HEIGHT, 300);
                    INITIALIZED = true;
                }
            }
        }
    }

    public void setChartEndTime(long maximumChartTime) {
        this.maximumChartTime = maximumChartTime;
    }

    public void setChartStartTime(long minimumChartTime) {
        this.minimumChartTime = minimumChartTime;
    }

    public void setChartsDir(File chartsDir) {
        this.externalChartsDir = chartsDir;
    }

    public long getChartEndTime() {
        return this.maximumChartTime;
    }

    public long getChartStartTime() {
        return this.minimumChartTime;
    }

    public int getChartHeight() {
        return chartsHeight;
    }

    public int getChartWidth() {
        return chartsWidth;
    }

    public File getExternalChartsDir() {
        return this.externalChartsDir;
    }

    public String getParserClassName() {
        return this.dataFileConfig.getParserClassName();
    }

    public DataFileConfig getDataFile() {
        return this.dataFileConfig;
    }

    public void setDataFile(DataFileConfig dataFileConfig) {
        this.dataFileConfig = dataFileConfig;
    }

    public boolean shouldChartsGenerated() {
        return !this.noCharts;
    }

    public void disableChartGeneration() {
        this.noCharts = true;
    }
}

