/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.external;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.api.report.external.AbstractLineParser;
import com.xceptance.xlt.api.report.external.ValueSet;
import com.xceptance.xlt.report.AbstractReader;
import com.xceptance.xlt.report.external.converter.AbstractDataConverter;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reader
extends AbstractReader<ValueSet> {
    private static final Logger LOG = LoggerFactory.getLogger(Reader.class);
    private final String fileName;
    private final String encoding;
    private final AbstractLineParser parser;
    private AbstractDataConverter converter;

    public Reader(String fileName, String encoding, AbstractLineParser parser) {
        super("ExternalDataReader");
        ParameterCheckUtils.isNonEmptyString(fileName, "fileName");
        ParameterCheckUtils.isNonEmptyString(encoding, "encoding");
        this.fileName = fileName;
        this.encoding = encoding;
        this.parser = parser;
    }

    public void setConverter(AbstractDataConverter converter) {
        if (this.converter == null) {
            this.converter = converter;
        }
    }

    @Override
    protected ValueSet processLine(String line) {
        try {
            return this.parser.parse(line);
        }
        catch (Exception ex) {
            if (LOG.isErrorEnabled()) {
                LOG.error(String.format("Failed to read file '%s': %s\n", this.getFileName(), ex.getMessage()));
            }
            System.out.println("FAILED: " + ex.getMessage());
            return null;
        }
    }

    @Override
    protected void processLineResult(ValueSet point) {
        long time = point.getTime();
        try {
            this.converter.parse(time, point.getValues());
        }
        catch (Exception e) {
            LOG.warn("Failed to parse external data", (Throwable)e);
            System.err.println("\nFailed to parse external data: " + String.valueOf(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData() {
        this.setOverallStartTime(GlobalClock.millis());
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.getFileName()), this.getEncoding()));){
            this.read(bufferedReader);
            this.waitForDataRecordProcessingToComplete();
        }
        catch (Exception e) {
            System.out.println("Failed to read data records: " + e.getMessage());
            LOG.error("Failed to read data records", (Throwable)e);
        }
        finally {
            this.cleanUp();
        }
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getEncoding() {
        return this.encoding;
    }
}

