/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.diffreport;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.report.util.ElementSpecification;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class DiffReportGeneratorConfiguration
extends AbstractConfiguration {
    private static final String PROP_PREFIX = "com.xceptance.xlt.diffreportgenerator.";
    private static final String PROP_REPORTS_ROOT_DIR = "com.xceptance.xlt.diffreportgenerator.reports";
    private static final String PROP_TRANSFORMATIONS_PREFIX = "com.xceptance.xlt.diffreportgenerator.transformations.";
    private static final String PROP_TRANSFORMATIONS_STYLE_SHEET_FILE_SUFFIX = ".styleSheetFileName";
    private static final String PROP_TRANSFORMATIONS_OUTPUT_FILE_SUFFIX = ".outputFileName";
    private final File configDirectory;
    private final File homeDirectory = XltExecutionContext.getCurrent().getXltHomeDir();
    private final File reportsRootDirectory;
    private final List<String> styleSheetFileNames;
    private final List<String> outputFileNames;

    public DiffReportGeneratorConfiguration() throws IOException {
        this.configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
        this.loadProperties(new File(this.configDirectory, "diffreportgenerator.properties"));
        File reportsRootDir = this.getFileProperty(PROP_REPORTS_ROOT_DIR, new File(this.homeDirectory, "reports"));
        if (!reportsRootDir.isAbsolute()) {
            reportsRootDir = new File(this.homeDirectory, reportsRootDir.getPath());
        }
        this.reportsRootDirectory = reportsRootDir;
        this.outputFileNames = new ArrayList<String>();
        this.styleSheetFileNames = new ArrayList<String>();
        this.readTransformations(this.outputFileNames, this.styleSheetFileNames);
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public List<ElementSpecification> getDiffElementSpecifications() {
        ArrayList<ElementSpecification> specs = new ArrayList<ElementSpecification>();
        specs.add(new ElementSpecification("/testreport/transactions/transaction", "name"));
        specs.add(new ElementSpecification("/testreport/actions/action", "name"));
        specs.add(new ElementSpecification("/testreport/requests/request", "name"));
        specs.add(new ElementSpecification("/testreport/pageLoadTimings/pageLoadTiming", "name"));
        specs.add(new ElementSpecification("/testreport/customTimers/customTimer", "name"));
        specs.add(new ElementSpecification("/testreport/customValues/customValue", "name"));
        specs.add(new ElementSpecification("/testreport/webVitalsList/webVitals", "name"));
        specs.add(new ElementSpecification("/testreport/summary/*", "name"));
        return specs;
    }

    public List<ElementSpecification> getCopyElementSpecifications() {
        ArrayList<ElementSpecification> specs = new ArrayList<ElementSpecification>();
        specs.add(new ElementSpecification("/testreport/general", null));
        specs.add(new ElementSpecification("/testreport/configuration/loadProfile", null));
        specs.add(new ElementSpecification("/testreport/configuration/comments", null));
        specs.add(new ElementSpecification("/testreport/configuration/properties", null));
        specs.add(new ElementSpecification("/testreport/configuration/projectName", null));
        return specs;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public File getReportsRootDirectory() {
        return this.reportsRootDirectory;
    }

    public List<String> getOutputFileNames() {
        return this.outputFileNames;
    }

    public List<String> getStyleSheetFileNames() {
        return this.styleSheetFileNames;
    }

    public void readTransformations(List<String> outputFileNames, List<String> styleSheetFileNames) {
        Set<String> keys = this.getPropertyKeyFragment(PROP_TRANSFORMATIONS_PREFIX);
        for (String key : keys) {
            String propertyPrefix = PROP_TRANSFORMATIONS_PREFIX + key;
            File outputFile = this.getFileProperty(propertyPrefix + PROP_TRANSFORMATIONS_OUTPUT_FILE_SUFFIX);
            File styleSheetFile = this.getFileProperty(propertyPrefix + PROP_TRANSFORMATIONS_STYLE_SHEET_FILE_SUFFIX);
            outputFileNames.add(outputFile.getPath());
            styleSheetFileNames.add(styleSheetFile.getPath());
        }
    }
}

