/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.criteria;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public final class CriteriaDefinition {
    private final List<Criterion> criteria;

    private CriteriaDefinition(List<Criterion> criteria) {
        this.criteria = Collections.unmodifiableList(criteria);
    }

    public static CriteriaDefinition fromJSON(JSONObject jsonObj) throws ValidationError {
        CriteriaDefinition.validateJSON(jsonObj);
        JSONArray _criteria = jsonObj.optJSONArray("criteria");
        ArrayList<Criterion> list = new ArrayList<Criterion>();
        int l = _criteria.length();
        for (int i = 0; i < l; ++i) {
            JSONObject c = _criteria.optJSONObject(i);
            String id = c.optString("id");
            String cond = c.optString("condition");
            String message = StringUtils.defaultString((String)c.optString("message"));
            boolean enabled = !c.has("enabled") || c.optBoolean("enabled");
            list.add(new Criterion(id, enabled, cond, message));
        }
        return new CriteriaDefinition(list);
    }

    private static void validateJSON(JSONObject json) throws ValidationError {
        JSONArray critArr;
        if (!json.has("criteria")) {
            CriteriaDefinition.die("Property 'criteria' does not exist");
        }
        if ((critArr = json.optJSONArray("criteria")) == null) {
            CriteriaDefinition.die("Property 'criteria' is no array");
        }
        LinkedList<String> list = new LinkedList<String>();
        int l = critArr.length();
        for (int i = 0; i < l; ++i) {
            int idx;
            String id;
            JSONObject c = critArr.getJSONObject(i);
            if (c == null) {
                CriteriaDefinition.die("Value at index '" + i + "' of array 'criteria' is not an object");
            }
            if (!c.has("id")) {
                CriteriaDefinition.die("Criterion at index '" + i + "' does not specify a property named 'id'");
            }
            if (StringUtils.isBlank((CharSequence)(id = c.optString("id")))) {
                CriteriaDefinition.die("Criterion at index '" + i + "' must define a non-blank string as value for property 'id'");
            }
            if ((idx = list.indexOf(id)) > -1) {
                CriteriaDefinition.die("Criteria at indices '" + idx + "' and '" + i + "' define the same value '" + id + "' for property 'id'");
            }
            if (!c.has("condition")) {
                CriteriaDefinition.die("Criterion at index '" + i + "' does not specify a property named 'condition'");
            }
            if (StringUtils.isBlank((CharSequence)c.optString("condition"))) {
                CriteriaDefinition.die("Criterion at index '" + i + "' must define a non-blank string as value for property 'condition'");
            }
            list.add(id);
        }
    }

    private static void die(String message) throws ValidationError {
        throw new ValidationError(message);
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    public static class Criterion {
        private final String id;
        private final String condition;
        private final boolean enabled;
        private final String message;

        private Criterion(String id, boolean enabled, String condition, String message) {
            this.id = id;
            this.enabled = enabled;
            this.condition = condition;
            this.message = message;
        }

        public String getId() {
            return this.id;
        }

        public String getCondition() {
            return this.condition;
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.getClass().getSimpleName()).append("[id: '").append(this.getId()).append("', condition: '").append(this.getCondition()).append(", enabled: ").append(this.isEnabled()).append(", message: '").append(this.getMessage()).append("']");
            return sb.toString();
        }
    }

    public static class ValidationError
    extends Exception {
        private static final long serialVersionUID = 1L;

        private ValidationError(String message) {
            super(message);
        }

        private ValidationError(String message, Throwable cause) {
            super(message, cause);
        }

        private ValidationError(Throwable cause) {
            super(cause);
        }

        private ValidationError() {
        }
    }
}

