/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.criteria;

import com.google.common.io.Files;
import com.xceptance.xlt.report.criteria.CriteriaDefinition;
import com.xceptance.xlt.report.criteria.CriteriaResult;
import com.xceptance.xlt.report.criteria.CriterionResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.jaxen.dom.DOMXPath;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CheckCriteriaMain {
    private static final Logger LOG = LoggerFactory.getLogger(CheckCriteriaMain.class);
    private static final String COMMANDLINE_OPTION_CRITERIAFILE = "c";
    private static final String COMMANDLINE_OPTION_OUTPUT = "o";
    private final Options options = this.createCliOptions();
    private List<File> inputFiles;
    private File criteriaFile;
    private File outFile;

    public static void main(String[] args) {
        CheckCriteriaMain main = new CheckCriteriaMain();
        try {
            main.init(args);
        }
        catch (Exception ex) {
            LOG.error("Initialization failed", (Throwable)ex);
            System.err.println("ERROR: " + ex.getMessage());
            main.printUsageInfo();
            System.exit(2);
        }
        try {
            if (main.run()) {
                LOG.info("Criteria checks passed successfully.");
                System.exit(0);
            } else {
                LOG.info("Criteria checks failed.");
                System.exit(3);
            }
        }
        catch (Exception ex) {
            LOG.error("Failed to check criteria", (Throwable)ex);
            System.err.println("ERROR: " + ex.getMessage());
            System.exit(1);
        }
    }

    private CheckCriteriaMain() {
    }

    public void init(String[] args) throws Exception {
        CommandLine cli = new DefaultParser().parse(this.options, args);
        String[] remainingArgs = cli.getArgs();
        if (remainingArgs.length < 1) {
            throw new IllegalArgumentException("Please specify at least one input file");
        }
        LinkedList<File> workList = new LinkedList<File>();
        for (String s : remainingArgs) {
            File f = new File(s);
            CheckCriteriaMain.validateFile(f);
            workList.add(f);
        }
        String critFilePath = cli.getOptionValue(COMMANDLINE_OPTION_CRITERIAFILE);
        if (StringUtils.isBlank((CharSequence)critFilePath)) {
            throw new IllegalArgumentException("Please specify path to criteria file");
        }
        this.criteriaFile = new File(critFilePath);
        CheckCriteriaMain.validateFile(this.criteriaFile);
        this.inputFiles = workList;
        String outFilePath = cli.getOptionValue(COMMANDLINE_OPTION_OUTPUT);
        if (StringUtils.isNotBlank((CharSequence)outFilePath)) {
            this.outFile = new File(outFilePath);
            if (this.outFile.exists()) {
                if (this.outFile.isDirectory()) {
                    throw new IllegalArgumentException("Invalid value for option '-o':  given path denotes a directory");
                }
                if (!this.outFile.canWrite()) {
                    throw new IllegalArgumentException("Cannot write to file '" + this.outFile.getAbsolutePath() + "'");
                }
            }
        }
    }

    public boolean run() throws FileNotFoundException, IOException {
        DocumentBuilder docBuilder;
        CriteriaDefinition criteriaDef;
        JSONObject criteriaJSON;
        try (BufferedReader reader = Files.newReader((File)this.criteriaFile, (Charset)StandardCharsets.UTF_8);){
            criteriaJSON = new JSONObject(new JSONTokener((Reader)reader));
        }
        catch (JSONException je) {
            throw new RuntimeException("Could not parse criteria file '" + this.criteriaFile.getAbsolutePath() + "' as JSON", je);
        }
        try {
            criteriaDef = CriteriaDefinition.fromJSON(criteriaJSON);
        }
        catch (CriteriaDefinition.ValidationError t) {
            throw new RuntimeException("Criteria definition file '" + this.criteriaFile.getAbsolutePath() + "' is malformed\n => " + t.getMessage());
        }
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            docBuilder.setErrorHandler(new DefaultHandler());
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
        LinkedList<CriteriaResult> outcome = new LinkedList<CriteriaResult>();
        boolean passed = true;
        for (File f : this.inputFiles) {
            Document doc;
            try {
                doc = docBuilder.parse(f);
            }
            catch (SAXException saxe) {
                throw new RuntimeException("Failed to parse file '" + f.getAbsolutePath() + "' as XML", saxe);
            }
            CriteriaResult result = new CriteriaResult(f.getAbsolutePath());
            this.checkCriteria(doc, criteriaDef, result);
            if (passed && !result.hasPassed()) {
                passed = false;
            }
            outcome.add(result);
        }
        this.writeJson(criteriaDef, outcome);
        return passed;
    }

    private void writeJson(CriteriaDefinition criteriaDef, List<CriteriaResult> validationResults) throws IOException {
        JSONObject json = new JSONObject();
        json.put("criteria", (Object)new JSONArray(criteriaDef.getCriteria()));
        json.put("checks", (Object)new JSONArray((Object)validationResults.stream().map(CriteriaResult::toJSON).toArray()));
        String output = json.toString(2);
        if (this.outFile != null) {
            try (BufferedWriter writer = Files.newWriter((File)this.outFile, (Charset)StandardCharsets.UTF_8);){
                writer.write(output);
            }
        } else {
            System.out.println(output);
        }
    }

    private void checkCriteria(Document doc, CriteriaDefinition criteriaDef, CriteriaResult result) {
        for (CriteriaDefinition.Criterion c : criteriaDef.getCriteria()) {
            if (!c.isEnabled()) {
                result.add(CriterionResult.skipped(c.getId()));
                continue;
            }
            try {
                if (this.evaluateCondition(doc, c.getCondition())) {
                    result.add(CriterionResult.passed(c.getId()));
                    continue;
                }
                result.add(CriterionResult.failed(c.getId(), (String)StringUtils.defaultIfBlank((CharSequence)c.getMessage(), (CharSequence)"Condition failed")));
            }
            catch (Exception e) {
                result.add(CriterionResult.error(c.getId(), e.getMessage()));
            }
        }
    }

    private boolean evaluateCondition(Document doc, String xPathPredicate) throws Exception {
        if (StringUtils.isBlank((CharSequence)xPathPredicate)) {
            return false;
        }
        try {
            Boolean b = (Boolean)new DOMXPath(xPathPredicate).evaluate((Object)doc);
            return b;
        }
        catch (ClassCastException cce) {
            throw new Exception("Failed to evaluate expression '" + xPathPredicate + "' as boolean");
        }
        catch (JaxenException xee) {
            throw new Exception("Failed to evaluate expression '" + xPathPredicate + "': " + xee.getMessage());
        }
    }

    private Options createCliOptions() {
        Options opts = new Options();
        Option o = new Option(COMMANDLINE_OPTION_OUTPUT, true, "write output to the given file");
        o.setArgName("out.json");
        opts.addOption(o);
        o = new Option(COMMANDLINE_OPTION_CRITERIAFILE, true, "criteria definition file");
        o.setArgName("criteria.json");
        o.setRequired(true);
        opts.addOption(o);
        return opts;
    }

    private void printUsageInfo() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.setSyntaxPrefix("Usage: ");
        formatter.setWidth(79);
        System.out.println();
        formatter.printHelp("check_criteria [<options>] xmlfile1 [xmlfile2 ...]", this.options);
        System.out.println();
    }

    private static void validateFile(File file) {
        String absPath = file.getAbsolutePath();
        if (!file.exists()) {
            throw new IllegalArgumentException("No such file '" + absPath + "'");
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException("Not a regular file: " + absPath);
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException("Cannot read from file '" + absPath + "'");
        }
    }
}

