/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.agentcontroller.AgentController;
import com.xceptance.xlt.agentcontroller.TestResultAmount;
import com.xceptance.xlt.agentcontroller.TestUserConfiguration;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.util.TimerUtils;
import com.xceptance.xlt.mastercontroller.AgentControllerStatusInfo;
import com.xceptance.xlt.mastercontroller.AgentControllerStatusUpdater;
import com.xceptance.xlt.mastercontroller.AgentControllerUpdate;
import com.xceptance.xlt.mastercontroller.AgentControllersInformation;
import com.xceptance.xlt.mastercontroller.MasterControllerConfiguration;
import com.xceptance.xlt.mastercontroller.MasterControllerUI;
import com.xceptance.xlt.mastercontroller.PingResult;
import com.xceptance.xlt.mastercontroller.ReportCreationType;
import com.xceptance.xlt.mastercontroller.ResultDownloader;
import com.xceptance.xlt.mastercontroller.TestCaseLoadProfileConfiguration;
import com.xceptance.xlt.mastercontroller.TestDeployer;
import com.xceptance.xlt.mastercontroller.TestDeployment;
import com.xceptance.xlt.mastercontroller.TestLoadProfileConfiguration;
import com.xceptance.xlt.report.ReportGenerator;
import com.xceptance.xlt.util.AgentControllerException;
import com.xceptance.xlt.util.ConcurrencyUtils;
import com.xceptance.xlt.util.FailedAgentControllerCollection;
import com.xceptance.xlt.util.FileReplicationIndex;
import com.xceptance.xlt.util.FileReplicationUtils;
import com.xceptance.xlt.util.ProgressBar;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.HiddenFileFilter;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MasterController {
    private static final Logger LOG = LoggerFactory.getLogger(MasterController.class);
    private static final FileFilter FILE_FILTER = FileFilterUtils.and((IOFileFilter[])new IOFileFilter[]{HiddenFileFilter.VISIBLE, FileFilterUtils.notFileFilter((IOFileFilter)new NameFileFilter("results"))});
    private final Map<String, AgentController> agentControllerMap;
    private final File agentFilesDirectory;
    private TestLoadProfileConfiguration currentLoadProfile;
    private String currentTestCaseName;
    private File currentTestResultsDir;
    private final TestDeployer testDeployer;
    private final File tempDirectory;
    private MasterControllerUI userInterface;
    private String testComment;
    private final String propertiesFileName;
    private final boolean isAgentControllerConnectionRelaxed;
    private final String reportTimezoneId;
    private final boolean isEmbedded;
    private final ThreadPoolExecutor defaultExecutor;
    private final ThreadPoolExecutor uploadExecutor;
    private final ThreadPoolExecutor downloadExecutor;
    private final File testResultsRootDirectory;
    private final File resultOutputDirectory;
    private boolean stoppedByUser = false;
    private boolean compressedTimerFiles = false;
    private final AgentControllerStatusUpdater agentControllerStatusUpdater;

    public MasterController(Map<String, AgentController> agentControllerMap, MasterControllerConfiguration config, String testPropertyFileName, boolean isAgentControllerConnectionRelaxed, String reportTimezoneId) {
        this.agentControllerMap = agentControllerMap;
        this.testDeployer = new TestDeployer(agentControllerMap);
        this.agentFilesDirectory = config.getAgentFilesDirectory();
        this.tempDirectory = config.getTempDirectory();
        this.propertiesFileName = testPropertyFileName;
        this.isAgentControllerConnectionRelaxed = isAgentControllerConnectionRelaxed;
        this.reportTimezoneId = reportTimezoneId;
        int parallelCommunicationLimit = config.getParallelCommunicationLimit();
        int parallelUploadLimit = config.getParallelUploadLimit();
        int parallelDownloadLimit = config.getParallelDownloadLimit();
        this.defaultExecutor = ConcurrencyUtils.getNewThreadPoolExecutor("AC-default-pool-", parallelCommunicationLimit);
        this.uploadExecutor = ConcurrencyUtils.getNewThreadPoolExecutor("AC-upload-pool-", parallelUploadLimit);
        this.downloadExecutor = ConcurrencyUtils.getNewThreadPoolExecutor("AC-download-pool-", parallelDownloadLimit);
        this.testResultsRootDirectory = config.getTestResultsRootDirectory();
        this.resultOutputDirectory = config.getResultOutputDirectory();
        this.isEmbedded = config.isEmbedded();
        this.compressedTimerFiles = config.isCompressedTimerFiles();
        this.checkTestPropertiesFileName();
        this.agentControllerStatusUpdater = new AgentControllerStatusUpdater(this.defaultExecutor);
    }

    private void checkTestPropertiesFileName() {
        if (StringUtils.isBlank((CharSequence)this.propertiesFileName)) {
            return;
        }
        if (new File(this.propertiesFileName).isAbsolute()) {
            String msg = "Parameter '%s' is invalid, because its value is not a relative path -> [%s]";
            throw new IllegalArgumentException(String.format("Parameter '%s' is invalid, because its value is not a relative path -> [%s]", "testPropertiesFile", this.propertiesFileName));
        }
        File agentConfDir = new File(this.agentFilesDirectory, "config");
        File testPropFile = new File(agentConfDir, this.propertiesFileName);
        ParameterCheckUtils.isReadableFile(testPropFile, "testPropertiesFile");
        boolean valid = false;
        try {
            valid = FileUtils.directoryContains((File)agentConfDir, (File)testPropFile);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!valid) {
            String msg = "Parameter '%s' is invalid, because its value does not point to a file inside directory '%s' -> [%s]";
            throw new IllegalArgumentException(String.format("Parameter '%s' is invalid, because its value does not point to a file inside directory '%s' -> [%s]", "testPropertiesFile", agentConfDir.getAbsolutePath(), this.propertiesFileName));
        }
    }

    public boolean downloadTestResults(TestResultAmount testResultAmount) {
        ArrayList<AgentController> agentControllers;
        int agentControllerSize;
        this.currentTestResultsDir = this.resultOutputDirectory;
        if (this.currentTestResultsDir == null) {
            this.currentTestResultsDir = this.getTestResultsDirectory(this.testResultsRootDirectory, this.currentTestCaseName);
        }
        if (!this.stoppedByUser && this.isAnyAgentRunning_SAFE()) {
            String intermediateResultsPath = this.currentTestResultsDir.getPath() + "-intermediate";
            this.currentTestResultsDir = new File(intermediateResultsPath);
        }
        ProgressBar progress = this.startNewProgressBar((agentControllerSize = (agentControllers = new ArrayList<AgentController>(this.agentControllerMap.values())).size()) > 0 ? 7 * agentControllerSize + 4 : 0);
        ResultDownloader resultDownloader = new ResultDownloader(this.downloadExecutor, this.currentTestResultsDir, this.tempDirectory, agentControllers, progress);
        boolean downloadSuccess = resultDownloader.download(testResultAmount, this.compressedTimerFiles);
        FailedAgentControllerCollection failedAgentControllers = resultDownloader.getFailedAgentControllerCollection();
        this.userInterface.testResultsDownloaded(failedAgentControllers);
        return downloadSuccess && (failedAgentControllers.isEmpty() || this.isAgentControllerConnectionRelaxed && failedAgentControllers.getMap().size() < agentControllerSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean generateReport(ReportCreationType reportCreationType) {
        boolean result = false;
        if (this.currentTestResultsDir != null) {
            TimeZone systemTZ = TimeZone.getDefault();
            TimeZone tz = this.reportTimezoneId != null ? TimeZone.getTimeZone(this.reportTimezoneId) : systemTZ;
            boolean overrideTZ = !systemTZ.equals(tz);
            try {
                if (overrideTZ) {
                    TimeZone.setDefault(tz);
                }
                FileObject testResultDir = VFS.getManager().resolveFile(this.currentTestResultsDir.toURI().toString());
                ReportGenerator reportGenerator = new ReportGenerator(testResultDir, null, false);
                if (reportCreationType.equals((Object)ReportCreationType.ALL)) {
                    reportGenerator.generateReport(false);
                    result = true;
                    return result;
                }
                if (!reportCreationType.equals((Object)ReportCreationType.NO_RAMPUP)) return result;
                reportGenerator.generateReport(true);
                result = true;
                return result;
            }
            catch (Exception ex) {
                LOG.error("Failed to generate report from the results in " + String.valueOf(this.currentTestResultsDir), (Throwable)ex);
                return result;
            }
            finally {
                if (overrideTZ) {
                    TimeZone.setDefault(systemTZ);
                }
            }
        } else {
            LOG.error("There are no downloaded results to generate a report from.");
        }
        return result;
    }

    public Map<String, PingResult> pingAgentControllers() {
        final Map<String, PingResult> pingResults = Collections.synchronizedMap(new TreeMap());
        final CountDownLatch latch = new CountDownLatch(this.agentControllerMap.size());
        for (final AgentController agentcontroller : this.agentControllerMap.values()) {
            this.defaultExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    PingResult pingResult;
                    try {
                        long pingStartTime = TimerUtils.getHighPrecisionTimer().getStartTime();
                        agentcontroller.ping();
                        long pingTime = TimerUtils.getHighPrecisionTimer().getElapsedTime(pingStartTime);
                        pingResult = new PingResult(pingTime);
                    }
                    catch (Exception e) {
                        LOG.error("Failed to ping agent controller: " + String.valueOf(agentcontroller), (Throwable)e);
                        pingResult = new PingResult(e);
                    }
                    pingResults.put(agentcontroller.toString(), pingResult);
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Waiting for ping results to complete has failed", (Throwable)e);
        }
        return pingResults;
    }

    public AgentControllersInformation getAgentControllerInformation() {
        return new AgentControllersInformation(this.agentControllerMap.values(), this.defaultExecutor);
    }

    public Set<String> getActiveTestCaseNames() {
        if (this.currentLoadProfile == null) {
            return Collections.emptySet();
        }
        return this.currentLoadProfile.getActiveTestCaseNames();
    }

    public TestLoadProfileConfiguration getCurrentLoadProfile() {
        return this.currentLoadProfile;
    }

    private TestDeployment getTestDeployment(TestLoadProfileConfiguration loadProfile, String testCaseName) {
        if (testCaseName != null) {
            loadProfile = loadProfile.getTestLoadProfileConfiguration(testCaseName);
        }
        TestDeployment testDeployment = this.testDeployer.createTestDeployment(loadProfile);
        return testDeployment;
    }

    private File getTestResultsDirectory(File testResultsRootDir, String testCaseName) {
        Object dirName = new SimpleDateFormat("yyyyMMdd-HHmmss").format(new Date());
        if (testCaseName != null) {
            dirName = (String)dirName + "-" + testCaseName;
        }
        return new File(testResultsRootDir, (String)dirName);
    }

    public MasterControllerUI getUserInterface() {
        return this.userInterface;
    }

    public void checkAlive() throws AgentControllerException {
        LOG.debug("Check if agents are alive");
        Map<AgentController, Future<Boolean>> agentFutures = this.getAgentRunningState();
        FailedAgentControllerCollection failed = new FailedAgentControllerCollection();
        for (Map.Entry<AgentController, Future<Boolean>> agentFuture : agentFutures.entrySet()) {
            try {
                agentFuture.getValue().get();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                failed.add(agentFuture.getKey(), e);
                LOG.error("Agentcontroller is not alive: " + String.valueOf(agentFuture.getKey()));
            }
        }
        this.checkSuccess(failed, true);
    }

    public Map<AgentController, Future<Boolean>> getAgentRunningState() {
        final CountDownLatch latch = new CountDownLatch(this.agentControllerMap.size());
        HashMap<AgentController, Future<Boolean>> agentFutures = new HashMap<AgentController, Future<Boolean>>();
        for (final AgentController agentcontroller : this.agentControllerMap.values()) {
            agentFutures.put(agentcontroller, this.defaultExecutor.submit(new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    boolean hasRunningAgent;
                    try {
                        hasRunningAgent = agentcontroller.hasRunningAgent();
                    }
                    finally {
                        latch.countDown();
                    }
                    return hasRunningAgent;
                }
            }));
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Waiting for agents running check to complete has failed", (Throwable)e);
        }
        return agentFutures;
    }

    public boolean isAnyAgentRunning() throws AgentControllerException {
        FailedAgentControllerCollection failedAgentControllers = new FailedAgentControllerCollection();
        Map<AgentController, Future<Boolean>> agentFutures = this.getAgentRunningState();
        AtomicBoolean result = new AtomicBoolean();
        for (Map.Entry<AgentController, Future<Boolean>> agentFuture : agentFutures.entrySet()) {
            try {
                if (!agentFuture.getValue().get().booleanValue()) continue;
                result.set(true);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException e) {
                failedAgentControllers.add(agentFuture.getKey(), e);
            }
        }
        this.checkSuccess(failedAgentControllers, true);
        return result.get();
    }

    public boolean isAnyAgentRunning_SAFE() {
        Map<AgentController, Future<Boolean>> agentFutures = this.getAgentRunningState();
        for (Map.Entry<AgentController, Future<Boolean>> agentFuture : agentFutures.entrySet()) {
            try {
                if (!agentFuture.getValue().get().booleanValue()) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    public boolean areAgentsInSync() {
        return this.currentLoadProfile != null && this.currentLoadProfile.getActiveTestCaseNames().size() > 0;
    }

    public void setUserInterface(MasterControllerUI userInterface) {
        this.userInterface = userInterface;
    }

    public boolean startAgents(String testCaseName) throws AgentControllerException, IOException {
        boolean operationCompleted;
        if (this.currentLoadProfile == null) {
            File workDir = this.setUpWorkDir(FILE_FILTER);
            this.currentLoadProfile = this.getTestProfile(workDir);
        }
        this.resetAgentStatuses();
        this.currentTestCaseName = testCaseName;
        final TestDeployment testDeployment = this.getTestDeployment(this.currentLoadProfile, this.currentTestCaseName);
        final FailedAgentControllerCollection failedAgentcontrollers = new FailedAgentControllerCollection();
        int agentControllerSize = this.agentControllerMap.size();
        final CountDownLatch latch = new CountDownLatch(agentControllerSize);
        final ProgressBar progress = this.startNewProgressBar(agentControllerSize);
        for (final AgentController agentController : this.agentControllerMap.values()) {
            this.defaultExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Map<String, List<TestUserConfiguration>> agentControllerLoadProfile = testDeployment.getAgentsUserList(agentController);
                        if (agentControllerLoadProfile == null || agentControllerLoadProfile.isEmpty()) {
                            LOG.info("No need to start agents at " + String.valueOf(agentController));
                        } else {
                            agentController.setReferenceTime(System.currentTimeMillis());
                            LOG.info("Starting agents at " + String.valueOf(agentController));
                            agentController.startAgents(agentControllerLoadProfile);
                        }
                    }
                    catch (Exception ex) {
                        failedAgentcontrollers.add(agentController, ex);
                        LOG.error("Failed starting agents at " + String.valueOf(agentController), (Throwable)ex);
                    }
                    progress.increaseCount();
                    latch.countDown();
                }
            });
        }
        boolean finished = true;
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Waiting for agent to start failed", (Throwable)e);
            finished = false;
        }
        this.checkSuccess(failedAgentcontrollers, true);
        this.userInterface.agentsStarted();
        boolean bl = operationCompleted = finished && (failedAgentcontrollers.isEmpty() || this.isAgentControllerConnectionRelaxed && failedAgentcontrollers.getMap().size() < agentControllerSize);
        if (operationCompleted) {
            this.stoppedByUser = false;
        }
        return operationCompleted;
    }

    public boolean stopAgents() throws AgentControllerException {
        boolean operationCompleted;
        final FailedAgentControllerCollection failedAgentcontrollers = new FailedAgentControllerCollection();
        int agentControllerSize = this.agentControllerMap.size();
        final CountDownLatch latch = new CountDownLatch(agentControllerSize);
        final ProgressBar progress = this.startNewProgressBar(agentControllerSize);
        for (final AgentController agentController : this.agentControllerMap.values()) {
            this.defaultExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    LOG.info("Stopping agents at " + String.valueOf(agentController));
                    try {
                        agentController.stopAgents();
                    }
                    catch (Exception ex) {
                        failedAgentcontrollers.add(agentController, ex);
                        LOG.error("Failed stopping agent at " + String.valueOf(agentController), (Throwable)ex);
                    }
                    progress.increaseCount();
                    latch.countDown();
                }
            });
        }
        boolean finished = true;
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            finished = false;
        }
        this.checkSuccess(failedAgentcontrollers, false);
        this.userInterface.agentsStopped();
        boolean bl = operationCompleted = finished && (failedAgentcontrollers.isEmpty() || this.isAgentControllerConnectionRelaxed && failedAgentcontrollers.getMap().size() < agentControllerSize);
        if (operationCompleted) {
            this.stoppedByUser = true;
        }
        return operationCompleted;
    }

    public void updateAgentFiles() throws AgentControllerException, IOException, IllegalStateException {
        System.out.print("    Preparing:");
        ProgressBar progressPrepare = this.startNewProgressBar(this.agentControllerMap.size() + 5);
        LOG.info("Cleanup");
        this.resetAgentStatuses();
        progressPrepare.increaseCount();
        LOG.info("Read target test suite");
        File workDir = this.setUpWorkDir(FILE_FILTER);
        progressPrepare.increaseCount();
        this.currentLoadProfile = this.getTestProfile(workDir);
        progressPrepare.increaseCount();
        if (this.currentLoadProfile.getActiveTestCaseNames().size() <= 0) {
            String msg = "No test case configured.";
            XltLogger.runTimeLogger.warn("No test case configured.");
            throw new IllegalStateException("No test case configured.");
        }
        LOG.info("Considering files in '" + String.valueOf(workDir) + "' for upload ...");
        FileReplicationIndex localIndex = FileReplicationUtils.getIndex(workDir, FILE_FILTER);
        progressPrepare.increaseCount();
        AgentControllerUpdate updater = new AgentControllerUpdate(this.agentControllerMap.values(), this.uploadExecutor, this.downloadExecutor, this.tempDirectory);
        updater.prepare(progressPrepare);
        System.out.println("- OK");
        System.out.print("    Uploading:");
        ProgressBar progressUpload = this.startNewProgressBar(4 * this.agentControllerMap.size() + 1);
        updater.update(workDir, localIndex, progressUpload);
        LOG.info("Clean up");
        if (workDir != this.agentFilesDirectory) {
            FileUtils.deleteQuietly((File)workDir);
        }
        progressUpload.increaseCount();
        this.checkSuccess(updater.getFailedAgentControllers(), true);
        this.userInterface.agentFilesUploaded();
    }

    private File setUpWorkDir(FileFilter fileFilter) {
        File workDir;
        if (StringUtils.isBlank((CharSequence)this.propertiesFileName)) {
            workDir = this.agentFilesDirectory;
        } else {
            try {
                workDir = File.createTempFile("xlt-", "", this.tempDirectory);
                FileUtils.forceDelete((File)workDir);
                FileUtils.forceMkdir((File)workDir);
                FileUtils.copyDirectory((File)this.agentFilesDirectory, (File)workDir, (FileFilter)fileFilter);
                File projectPropertiesFile = new File(new File(workDir, "config"), "project.properties");
                PropertiesConfiguration config = new PropertiesConfiguration();
                config.setIOFactory((PropertiesConfiguration.IOFactory)new PropertiesConfiguration.JupIOFactory());
                FileHandler fileHandler = new FileHandler((FileBased)config);
                fileHandler.load(projectPropertiesFile);
                config.setProperty("com.xceptance.xlt.testPropertiesFile", (Object)this.propertiesFileName);
                fileHandler.save(projectPropertiesFile);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to make a copy of the agent files", e);
            }
        }
        return workDir;
    }

    private TestLoadProfileConfiguration getTestProfile(File agentTemplateDir) throws IOException {
        FileObject testPropertiesFile;
        TestLoadProfileConfiguration testConfig;
        File agentTemplateConfigDir = new File(agentTemplateDir, "config");
        try {
            XltPropertiesImpl properties = TestLoadProfileConfiguration.readProperties(agentTemplateDir, agentTemplateConfigDir);
            testConfig = new TestLoadProfileConfiguration(properties);
            this.postProcessLoadProfile(testConfig);
        }
        catch (Throwable ex) {
            throw new RuntimeException("Load profile configuration failed using directory: '" + String.valueOf(agentTemplateConfigDir) + "'. " + MasterController.getDetailedMessage(ex), ex);
        }
        String testPropertiesFileName = testConfig.getProperties().getProperty("com.xceptance.xlt.testPropertiesFile");
        if (!(!StringUtils.isNotBlank((CharSequence)testPropertiesFileName) || (testPropertiesFile = VFS.getManager().resolveFile(agentTemplateConfigDir, testPropertiesFileName)).exists() && testPropertiesFile.isFile() && testPropertiesFile.isReadable())) {
            throw new IOException("Unable to load test properties file.");
        }
        return testConfig;
    }

    protected static String getDetailedMessage(Throwable throwable) {
        LinkedList<String> messages = new LinkedList<String>();
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            String msg = t.getMessage();
            if (msg == null) continue;
            messages.add(msg);
        }
        return StringUtils.join(messages, (String)" :: ");
    }

    void setTestComment(String comment) {
        this.testComment = comment != null ? comment.trim() : null;
        LOG.debug("Test comment set to: " + StringUtils.defaultString((String)comment, (String)"<NULL>"));
    }

    File getCurrentTestResultsDirectory() {
        return this.currentTestResultsDir;
    }

    public String getTestComment() {
        return this.testComment;
    }

    void setTestComment4DownloadedResults() {
        block9: {
            if (StringUtils.isBlank((CharSequence)this.getTestComment())) {
                return;
            }
            FileObject testPropFile = MasterController.getTestPropertyFile(this.currentTestResultsDir);
            try {
                if (testPropFile == null || !testPropFile.exists()) break block9;
                try (BufferedWriter w = new BufferedWriter(new OutputStreamWriter(testPropFile.getContent().getOutputStream(true)));){
                    w.newLine();
                    w.write("# Command line comment (AUTOMATICALLY INSERTED)\n");
                    w.write("com.xceptance.xlt.loadtests.comment.commandLine = " + this.getTestComment());
                }
            }
            catch (Exception e) {
                if (testPropFile != null) {
                    LOG.error("Unable to write comment from CLI to '" + testPropFile.getPublicURIString() + "'.", (Throwable)e);
                }
                LOG.error("Unable to write comment from CLI. File information missing", (Throwable)e);
            }
        }
    }

    public String getTestCommentPropertyValue() {
        try {
            FileSystemManager fsMgr = VFS.getManager();
            XltPropertiesImpl props = new XltPropertiesImpl(fsMgr.resolveFile(this.currentTestResultsDir.getAbsolutePath()), fsMgr.resolveFile(MasterController.getConfigDir(this.currentTestResultsDir).getAbsolutePath()), false, true);
            String testCommentPropValue = ((XltProperties)props).getProperties().getProperty("com.xceptance.xlt.loadtests.comment");
            return testCommentPropValue;
        }
        catch (Exception e) {
            LOG.error("Failed to read/parse test configuration from '" + String.valueOf(this.currentTestResultsDir) + "'", (Throwable)e);
            return null;
        }
    }

    public static FileObject getTestPropertyFile(File testResultsDir) {
        try {
            FileSystemManager fsMgr = VFS.getManager();
            File confDir = MasterController.getConfigDir(testResultsDir);
            XltPropertiesImpl props = new XltPropertiesImpl(fsMgr.resolveFile(testResultsDir.getAbsolutePath()), fsMgr.resolveFile(confDir.getAbsolutePath()), false, true);
            return props.getTestPropertyFile(true);
        }
        catch (Exception e) {
            LOG.error("Failed to read/parse test configuration from '" + String.valueOf(testResultsDir) + "'");
            return null;
        }
    }

    public void shutdown() {
        this.defaultExecutor.shutdownNow();
        this.uploadExecutor.shutdownNow();
        this.downloadExecutor.shutdownNow();
    }

    public void init() {
        this.agentControllerStatusUpdater.clearAgentControllerStatusMap();
    }

    private ProgressBar startNewProgressBar(int total) {
        ProgressBar progress = new ProgressBar(total);
        System.out.print("    ");
        progress.start();
        return progress;
    }

    private void resetAgentStatuses() throws AgentControllerException {
        final FailedAgentControllerCollection failedAgentControllers = new FailedAgentControllerCollection();
        final CountDownLatch latch = new CountDownLatch(this.agentControllerMap.size());
        for (final AgentController agentController : this.agentControllerMap.values()) {
            this.defaultExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        agentController.resetAgentsStatus();
                    }
                    catch (Exception e) {
                        failedAgentControllers.add(agentController, e);
                    }
                    latch.countDown();
                }
            });
        }
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            LOG.error("Waiting for resetting agent status to complete has failed");
        }
        this.agentControllerStatusUpdater.clearAgentControllerStatusMap();
        this.checkSuccess(failedAgentControllers, true);
    }

    private void checkSuccess(FailedAgentControllerCollection failedAgentControllers, boolean keepLivingAgentControllersOnly) throws AgentControllerException {
        if (failedAgentControllers != null && !failedAgentControllers.isEmpty()) {
            if (this.isAgentControllerConnectionRelaxed) {
                this.userInterface.skipAgentControllerConnections(failedAgentControllers);
                if (keepLivingAgentControllersOnly) {
                    for (AgentController ac : failedAgentControllers.getAgentControllers()) {
                        this.agentControllerMap.remove(ac.getName());
                    }
                }
                if (this.agentControllerMap.isEmpty()) {
                    throw new IllegalStateException("No living AgentController left.");
                }
            } else {
                throw new AgentControllerException(failedAgentControllers);
            }
        }
    }

    private static File getConfigDir(File inputDir) {
        File configDir = new File(inputDir, "config");
        if (configDir != null && configDir.exists() && configDir.canRead() && configDir.isDirectory()) {
            return configDir;
        }
        return inputDir;
    }

    private void postProcessLoadProfile(TestLoadProfileConfiguration loadProfile) {
        boolean haveCPTests = false;
        boolean haveLoadTests = false;
        for (TestCaseLoadProfileConfiguration testConfig : loadProfile.getLoadTestConfiguration()) {
            haveCPTests = haveCPTests || testConfig.isCPTest();
            boolean bl = haveLoadTests = haveLoadTests || !testConfig.isCPTest();
            if (!this.isEmbedded) continue;
            testConfig.setCPTest(false);
        }
        if (!this.isEmbedded) {
            boolean haveLoadAC;
            int acCount = this.agentControllerMap.size();
            int nbCPACs = 0;
            for (AgentController ac : this.agentControllerMap.values()) {
                if (!ac.runsClientPerformanceTests()) continue;
                ++nbCPACs;
            }
            int diff = acCount - nbCPACs;
            boolean haveCPAC = diff != acCount;
            boolean bl = haveLoadAC = diff > 0;
            if (haveCPTests && !haveCPAC) {
                throw new IllegalArgumentException("There is at least one client-performance test configured but no agent controller capable to run client-performance tests could be found.");
            }
            if (haveLoadTests && !haveLoadAC) {
                throw new IllegalArgumentException("There is at least one load/performance test configured but no agent controller capable to run load/performance tests could be found.");
            }
        }
    }

    public void startAgentControllerStatusUpdates() {
        long interval = (long)this.userInterface.getStatusListUpdateInterval() * 1000L;
        this.agentControllerStatusUpdater.start(this.agentControllerMap.values(), interval);
    }

    public void stopAgentControllerStatusUpdates() {
        this.agentControllerStatusUpdater.stop();
    }

    public List<AgentControllerStatusInfo> getAgentControllerStatusList() {
        FailedAgentControllerCollection failedAgentcontrollers = new FailedAgentControllerCollection();
        this.userInterface.receivingAgentStatus();
        Map<String, AgentControllerStatusInfo> agentControllerStatusMap = this.agentControllerStatusUpdater.getAgentControllerStatusMap();
        for (AgentController agentController : this.agentControllerMap.values()) {
            Exception e;
            AgentControllerStatusInfo agentControllerStatus = agentControllerStatusMap.get(agentController.getName());
            if (agentControllerStatus == null || (e = agentControllerStatus.getException()) == null) continue;
            failedAgentcontrollers.add(agentController, e);
        }
        this.userInterface.agentStatusReceived(failedAgentcontrollers);
        return new ArrayList<AgentControllerStatusInfo>(agentControllerStatusMap.values());
    }
}

