/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.cloud.compute.v1.Instance;
import com.google.cloud.compute.v1.InstanceGroup;
import com.xceptance.xlt.gce.GceAdminUtils;
import com.xceptance.xlt.gce.GceClient;
import java.io.File;
import java.util.List;

class OpListInstancesByGroupNonInteractively {
    private final GceClient gceClient;

    OpListInstancesByGroupNonInteractively(GceClient gceClient) {
        this.gceClient = gceClient;
    }

    void execute(String regionName, String instanceGroupName, File outputFile) {
        try {
            InstanceGroup instanceGroup = this.gceClient.getInstanceGroup(regionName, instanceGroupName);
            List<Instance> instances = this.gceClient.getInstancesInGroup(instanceGroup);
            GceAdminUtils.outputAgentControllerConnectionProperties(instances, outputFile);
        }
        catch (Exception e) {
            GceAdminUtils.dieWithMessage(String.format("Failed to list the instances of instance group '%s' in region '%s'", instanceGroupName, regionName), e);
        }
    }
}

