/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.gce;

import com.google.cloud.compute.v1.InstanceGroup;
import com.xceptance.xlt.gce.GceAdminUtils;
import com.xceptance.xlt.gce.GceClient;

class OpDeleteInstanceGroupNonInteractively {
    private final GceClient gceClient;

    OpDeleteInstanceGroupNonInteractively(GceClient gceClient) {
        this.gceClient = gceClient;
    }

    void execute(String regionName, String instanceGroupName) {
        try {
            InstanceGroup instanceGroup = this.gceClient.getInstanceGroup(regionName, instanceGroupName);
            this.gceClient.deleteInstanceGroup(instanceGroup);
        }
        catch (Exception e) {
            GceAdminUtils.dieWithMessage(String.format("Failed to delete instance group '%s' in region '%s", instanceGroupName, regionName), e);
        }
    }
}

