/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.xltdriver;

import com.xceptance.xlt.engine.scripting.htmlunit.HtmlUnitElementUtils;
import com.xceptance.xlt.engine.xltdriver.HtmlUnitDriver;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.ScriptResult;
import org.htmlunit.corejs.javascript.ScriptRuntime;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.htmlunit.html.DisabledElement;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlButton;
import org.htmlunit.html.HtmlCheckBoxInput;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlForm;
import org.htmlunit.html.HtmlImageInput;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.HtmlOption;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.html.HtmlRadioButtonInput;
import org.htmlunit.html.HtmlSelect;
import org.htmlunit.html.HtmlSubmitInput;
import org.htmlunit.html.HtmlTextArea;
import org.htmlunit.html.impl.SelectableTextInput;
import org.htmlunit.javascript.host.css.CSSStyleDeclaration;
import org.htmlunit.javascript.host.dom.DOMTokenList;
import org.htmlunit.javascript.host.html.HTMLElement;
import org.openqa.selenium.By;
import org.openqa.selenium.Dimension;
import org.openqa.selenium.ElementNotInteractableException;
import org.openqa.selenium.InvalidElementStateException;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.Rectangle;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.WrapsDriver;
import org.openqa.selenium.WrapsElement;
import org.openqa.selenium.interactions.Coordinates;
import org.openqa.selenium.interactions.Locatable;
import org.openqa.selenium.remote.Dialect;
import org.openqa.selenium.support.Color;
import org.openqa.selenium.support.Colors;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;

public class HtmlUnitWebElement
implements WrapsDriver,
WebElement,
Coordinates,
Locatable {
    private static final String[] booleanAttributes = new String[]{"async", "autofocus", "autoplay", "checked", "compact", "complete", "controls", "declare", "defaultchecked", "defaultselected", "defer", "disabled", "draggable", "ended", "formnovalidate", "hidden", "indeterminate", "iscontenteditable", "ismap", "itemscope", "loop", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "paused", "pubdate", "readonly", "required", "reversed", "scoped", "seamless", "seeking", "selected", "spellcheck", "truespeed", "willvalidate"};
    private final HtmlUnitDriver driver_;
    private final int id_;
    private final DomElement element_;
    private String toString_;

    public HtmlUnitWebElement(HtmlUnitDriver driver, int id, DomElement element) {
        this.driver_ = driver;
        this.id_ = id;
        this.element_ = element;
    }

    public void click() {
        this.verifyCanInteractWithElement(false);
        this.driver_.click(this.element_, true);
    }

    public void submit() {
        this.driver_.submit(this);
    }

    void submitImpl() {
        try {
            if (this.element_ instanceof HtmlForm) {
                this.submitForm((HtmlForm)this.element_);
            } else if (this.element_ instanceof HtmlSubmitInput || this.element_ instanceof HtmlImageInput) {
                this.element_.click();
            } else if (this.element_ instanceof HtmlInput) {
                HtmlForm form = ((HtmlElement)this.element_).getEnclosingForm();
                if (form == null) {
                    throw new UnsupportedOperationException("To submit an element, it must be nested inside a form element");
                }
                this.submitForm(form);
            } else {
                HtmlUnitWebElement form = this.findParentForm();
                if (form == null) {
                    throw new UnsupportedOperationException("To submit an element, it must be nested inside a form element");
                }
                form.submitImpl();
            }
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private void submitForm(HtmlForm form) {
        this.assertElementNotStale();
        ArrayList allElements = new ArrayList();
        allElements.addAll(form.getElementsByTagName("input"));
        allElements.addAll(form.getElementsByTagName("button"));
        HtmlElement submit = null;
        for (HtmlElement e : allElements) {
            if (!HtmlUnitWebElement.isSubmitElement(e) || submit != null) continue;
            submit = e;
        }
        if (submit == null) {
            if (this.driver_.isJavascriptEnabled()) {
                ScriptResult eventResult = form.fireEvent("submit");
                if (!ScriptResult.isFalse(eventResult)) {
                    this.driver_.executeScript("arguments[0].submit()", form);
                }
                return;
            }
            throw new WebDriverException("Cannot locate element used to submit form");
        }
        try {
            submit.click(false, false, false, true, true, true, false);
        }
        catch (IOException e) {
            throw new WebDriverException((Throwable)e);
        }
    }

    private static boolean isSubmitElement(HtmlElement element) {
        HtmlButton button;
        HtmlElement candidate = null;
        if (element instanceof HtmlSubmitInput && !((HtmlSubmitInput)element).isDisabled()) {
            candidate = element;
        } else if (element instanceof HtmlImageInput && !((HtmlImageInput)element).isDisabled()) {
            candidate = element;
        } else if (element instanceof HtmlButton && "submit".equalsIgnoreCase((button = (HtmlButton)element).getTypeAttribute()) && !button.isDisabled()) {
            candidate = element;
        }
        return candidate != null;
    }

    public void clear() {
        this.assertElementNotStale();
        if (this.element_ instanceof HtmlInput) {
            HtmlInput htmlInput = (HtmlInput)this.element_;
            if (htmlInput.isReadOnly()) {
                throw new InvalidElementStateException("You may only edit editable elements");
            }
            if (htmlInput.isDisabled()) {
                throw new InvalidElementStateException("You may only interact with enabled elements");
            }
            htmlInput.setValue("");
            if (htmlInput instanceof SelectableTextInput) {
                ((SelectableTextInput)((Object)htmlInput)).setSelectionEnd(0);
            }
            htmlInput.fireEvent("change");
        } else if (this.element_ instanceof HtmlTextArea) {
            HtmlTextArea htmlTextArea = (HtmlTextArea)this.element_;
            if (htmlTextArea.isReadOnly()) {
                throw new InvalidElementStateException("You may only edit editable elements");
            }
            if (htmlTextArea.isDisabled()) {
                throw new InvalidElementStateException("You may only interact with enabled elements");
            }
            htmlTextArea.setText("");
        } else if (!this.element_.getAttribute("contenteditable").equals(DomElement.ATTRIBUTE_NOT_DEFINED)) {
            this.element_.setTextContent("");
        }
    }

    void verifyCanInteractWithElement(boolean ignoreDisabled) {
        this.assertElementNotStale();
        Boolean displayed = this.driver_.implicitlyWaitFor(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return HtmlUnitWebElement.this.isDisplayed();
            }
        });
        if (displayed == null || !displayed.booleanValue()) {
            throw new ElementNotInteractableException("You may only interact with visible elements");
        }
        if (!ignoreDisabled && !this.isEnabled()) {
            throw new InvalidElementStateException("You may only interact with enabled elements");
        }
    }

    void switchFocusToThisIfNeeded() {
    }

    public void sendKeys(CharSequence ... value) {
        if (value == null) {
            throw new IllegalArgumentException("Keys to send should nor be null");
        }
        this.driver_.sendKeys(this, value);
    }

    public String getTagName() {
        this.assertElementNotStale();
        return this.element_.getNodeName();
    }

    public String getAttribute(String name) {
        Object slotVal;
        Object scriptable;
        this.assertElementNotStale();
        String lowerName = name.toLowerCase();
        if (this.element_ instanceof HtmlInput && ("selected".equals(lowerName) || "checked".equals(lowerName))) {
            return HtmlUnitWebElement.trueOrNull(((HtmlInput)this.element_).isChecked());
        }
        if ("href".equals(lowerName)) {
            String href = this.element_.getAttribute(name);
            if (DomElement.ATTRIBUTE_NOT_DEFINED == href) {
                return null;
            }
            HtmlPage page = (HtmlPage)this.element_.getPage();
            try {
                return page.getFullyQualifiedUrl(href.trim()).toString();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if ("src".equals(lowerName)) {
            String link = this.element_.getAttribute(name);
            if (DomElement.ATTRIBUTE_NOT_DEFINED == link) {
                return "";
            }
            HtmlPage page = (HtmlPage)this.element_.getPage();
            try {
                return page.getFullyQualifiedUrl(link.trim()).toString();
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if ("value".equals(lowerName)) {
            if (this.element_ instanceof HtmlInput) {
                return ((HtmlInput)this.element_).getValue();
            }
            if (this.element_ instanceof HtmlTextArea) {
                return ((HtmlTextArea)this.element_).getText();
            }
            if (this.element_ instanceof HtmlOption && !this.element_.hasAttribute("value")) {
                return this.getText();
            }
            String attributeValue = this.element_.getAttribute(name);
            if (DomElement.ATTRIBUTE_NOT_DEFINED == attributeValue) {
                return null;
            }
            return attributeValue;
        }
        if ("disabled".equals(lowerName)) {
            if (this.element_ instanceof DisabledElement) {
                return HtmlUnitWebElement.trueOrNull(((DisabledElement)((Object)this.element_)).isDisabled());
            }
            return "true";
        }
        if ("multiple".equals(lowerName) && this.element_ instanceof HtmlSelect) {
            String multipleAttribute = ((HtmlSelect)this.element_).getMultipleAttribute();
            if ("".equals(multipleAttribute)) {
                return HtmlUnitWebElement.trueOrNull(this.element_.hasAttribute("multiple"));
            }
            return "true";
        }
        if ("index".equals(lowerName) && this.element_ instanceof HtmlOption) {
            HtmlSelect select = ((HtmlOption)this.element_).getEnclosingSelect();
            List<HtmlOption> allOptions = select.getOptions();
            for (int i = 0; i < allOptions.size(); ++i) {
                HtmlOption option = select.getOption(i);
                if (!this.element_.equals(option)) continue;
                return String.valueOf(i);
            }
            return null;
        }
        for (String booleanAttribute : booleanAttributes) {
            if (!booleanAttribute.equals(lowerName)) continue;
            return HtmlUnitWebElement.trueOrNull(this.element_.hasAttribute(lowerName));
        }
        String attributeValue = this.element_.getAttribute(name);
        if (!attributeValue.isEmpty()) {
            return attributeValue;
        }
        if (this.element_.hasAttribute(name)) {
            return "";
        }
        if (this.driver_.getWebClient().isJavaScriptEngineEnabled() && (scriptable = this.element_.getScriptableObject()) != null && (slotVal = ScriptableObject.getProperty(scriptable, (String)name)) instanceof String) {
            return (String)slotVal;
        }
        return null;
    }

    public String getDomProperty(String name) {
        String value;
        this.assertElementNotStale();
        Object scriptable = this.element_.getScriptableObject();
        if (scriptable != null) {
            Object propValue = ScriptableObject.getProperty(scriptable, (String)name);
            if (Scriptable.NOT_FOUND == propValue) {
                return null;
            }
            if (propValue instanceof CSSStyleDeclaration) {
                return ((CSSStyleDeclaration)propValue).getCssText();
            }
            if (propValue instanceof DOMTokenList) {
                String value2 = ((DOMTokenList)propValue).getValue();
                if (value2 != null) {
                    return "[" + String.join((CharSequence)", ", StringUtils.split((String)value2, (String)" \t\r\n\f")) + "]";
                }
                return "";
            }
            return ScriptRuntime.toString((Object)propValue);
        }
        if ("disabled".equals(name) && this.element_ instanceof DisabledElement) {
            return HtmlUnitWebElement.trueOrFalse(((DisabledElement)((Object)this.element_)).isDisabled());
        }
        if ("checked".equals(name)) {
            if (this.element_ instanceof HtmlCheckBoxInput) {
                return HtmlUnitWebElement.trueOrFalse(((HtmlCheckBoxInput)this.element_).isChecked());
            }
            if (this.element_ instanceof HtmlRadioButtonInput) {
                return HtmlUnitWebElement.trueOrFalse(((HtmlRadioButtonInput)this.element_).isChecked());
            }
        }
        if (DomElement.ATTRIBUTE_NOT_DEFINED == (value = this.element_.getAttribute(name))) {
            return null;
        }
        if (DomElement.ATTRIBUTE_VALUE_EMPTY == value) {
            return null;
        }
        return value;
    }

    public String getDomAttribute(String name) {
        this.assertElementNotStale();
        String lowerName = name.toLowerCase();
        String value = this.element_.getAttribute(lowerName);
        if (DomElement.ATTRIBUTE_NOT_DEFINED == value) {
            return null;
        }
        if ("disabled".equals(lowerName) && this.element_ instanceof DisabledElement) {
            return HtmlUnitWebElement.trueOrNull(((DisabledElement)((Object)this.element_)).isDisabled());
        }
        if ("checked".equals(lowerName)) {
            if (this.element_ instanceof HtmlCheckBoxInput) {
                return HtmlUnitWebElement.trueOrNull(((HtmlCheckBoxInput)this.element_).isChecked());
            }
            if (this.element_ instanceof HtmlRadioButtonInput) {
                return HtmlUnitWebElement.trueOrNull(((HtmlRadioButtonInput)this.element_).isChecked());
            }
        }
        if ("multiple".equals(lowerName) && this.element_ instanceof HtmlSelect) {
            return "true";
        }
        if ("selected".equals(lowerName) && this.element_ instanceof HtmlOption) {
            return HtmlUnitWebElement.trueOrNull(((HtmlOption)this.element_).isSelected());
        }
        return value;
    }

    private static String trueOrNull(boolean condition) {
        return condition ? "true" : null;
    }

    private static String trueOrFalse(boolean condition) {
        return condition ? "true" : "false";
    }

    public boolean isSelected() {
        this.assertElementNotStale();
        if (this.element_ instanceof HtmlInput) {
            return ((HtmlInput)this.element_).isChecked();
        }
        if (this.element_ instanceof HtmlOption) {
            return ((HtmlOption)this.element_).isSelected();
        }
        throw new UnsupportedOperationException("Unable to determine if element is selected. Tag name is: " + this.element_.getTagName());
    }

    public boolean isEnabled() {
        this.assertElementNotStale();
        if (this.element_ instanceof DisabledElement) {
            return !((DisabledElement)((Object)this.element_)).isDisabled();
        }
        return true;
    }

    public boolean isDisplayed() {
        this.assertElementNotStale();
        return HtmlUnitElementUtils.isVisible(this.element_);
    }

    public Point getLocation() {
        this.assertElementNotStale();
        int[] position = HtmlUnitElementUtils.getPosition(this.getElement());
        return new Point(position[0], position[1]);
    }

    public Dimension getSize() {
        this.assertElementNotStale();
        try {
            int width = this.readAndRound("width");
            int height = this.readAndRound("height");
            return new Dimension(width, height);
        }
        catch (Exception e) {
            throw new WebDriverException("Cannot determine size of element", (Throwable)e);
        }
    }

    public Rectangle getRect() {
        return new Rectangle(this.getLocation(), this.getSize());
    }

    private int readAndRound(String property) {
        String cssValue = this.getCssValue(property).replaceAll("[^0-9\\.]", "");
        if (cssValue.isEmpty()) {
            return 5;
        }
        return Math.round(Float.parseFloat(cssValue));
    }

    public String getText() {
        this.assertElementNotStale();
        return HtmlUnitElementUtils.computeText(this.element_);
    }

    protected HtmlUnitDriver getDriver() {
        return this.driver_;
    }

    public DomElement getElement() {
        return this.element_;
    }

    @Deprecated
    public List<WebElement> getElementsByTagName(String tagName) {
        this.assertElementNotStale();
        List allChildren = this.element_.getByXPath(".//" + tagName);
        ArrayList<WebElement> elements = new ArrayList<WebElement>();
        for (Object o : allChildren) {
            if (!(o instanceof HtmlElement)) continue;
            HtmlElement child = (HtmlElement)o;
            elements.add(this.getDriver().toWebElement(child));
        }
        return elements;
    }

    public WebElement findElement(By by) {
        this.driver_.getAlert().ensureUnlocked();
        return this.driver_.implicitlyWaitFor(() -> {
            this.assertElementNotStale();
            return this.driver_.findElement(this, by);
        });
    }

    public List<WebElement> findElements(By by) {
        this.driver_.getAlert().ensureUnlocked();
        return this.driver_.implicitlyWaitFor(() -> {
            this.assertElementNotStale();
            return this.driver_.findElements(this, by);
        });
    }

    private HtmlUnitWebElement findParentForm() {
        DomNode current;
        for (current = this.element_; current != null && !(current instanceof HtmlForm); current = current.getParentNode()) {
        }
        return this.getDriver().toWebElement((HtmlForm)current);
    }

    public String toString() {
        if (this.toString_ == null) {
            StringBuilder sb = new StringBuilder();
            sb.append('<').append(this.element_.getTagName());
            NamedNodeMap attributes = this.element_.getAttributes();
            int n = attributes.getLength();
            for (int i = 0; i < n; ++i) {
                Attr a = (Attr)attributes.item(i);
                sb.append(' ').append(a.getName()).append("=\"").append(a.getValue().replace("\"", "&quot;")).append("\"");
            }
            if (this.element_.hasChildNodes()) {
                sb.append('>');
            } else {
                sb.append(" />");
            }
            this.toString_ = sb.toString();
        }
        return this.toString_;
    }

    protected void assertElementNotStale() {
        this.driver_.assertElementNotStale(this.element_);
    }

    public String getCssValue(String propertyName) {
        this.assertElementNotStale();
        HTMLElement elem = (HTMLElement)this.element_.getScriptableObject();
        String style = elem.getWindow().getComputedStyle(elem, null).getPropertyValue(propertyName);
        return HtmlUnitWebElement.getColor(style);
    }

    private static String getColor(String name) {
        if ("null".equals(name)) {
            return "transparent";
        }
        if (name.startsWith("rgb(")) {
            return Color.fromString((String)name).asRgba();
        }
        Colors colors = HtmlUnitWebElement.getColorsOf(name);
        if (colors != null) {
            return colors.getColorValue().asRgba();
        }
        return name;
    }

    private static Colors getColorsOf(String name) {
        name = name.toUpperCase();
        for (Colors colors : Colors.values()) {
            if (!colors.name().equals(name)) continue;
            return colors;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof WebElement)) {
            return false;
        }
        WebElement other = (WebElement)obj;
        if (other instanceof WrapsElement) {
            other = ((WrapsElement)obj).getWrappedElement();
        }
        return other instanceof HtmlUnitWebElement && this.element_.equals(((HtmlUnitWebElement)other).element_);
    }

    public int hashCode() {
        return this.element_.hashCode();
    }

    public WebDriver getWrappedDriver() {
        return this.driver_;
    }

    public Coordinates getCoordinates() {
        return this;
    }

    public Point onScreen() {
        throw new UnsupportedOperationException("Not displayed, no screen location.");
    }

    public Point inViewPort() {
        return this.getLocation();
    }

    public Point onPage() {
        return this.getLocation();
    }

    public Object getAuxiliary() {
        return this.element_;
    }

    public <X> X getScreenshotAs(OutputType<X> outputType) throws WebDriverException {
        throw new UnsupportedOperationException("Screenshots are not enabled for HtmlUnitDriver");
    }

    public int getId() {
        return this.id_;
    }

    public Map<String, Object> toJson() {
        return Map.of(Dialect.W3C.getEncodedElementKey(), this.getId());
    }
}

