/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.htmlunit.corejs.javascript.Context;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSBeautifier {
    private static final Logger LOG = LoggerFactory.getLogger(JSBeautifier.class);
    private final String js_beautify;
    private static final Map<String, Object> OPTIONS = JSBeautifier._createOptionMap();

    private JSBeautifier() {
        String content = null;
        try (InputStream is = this.getClass().getResourceAsStream("beautify.js");){
            if (is != null) {
                content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            }
        }
        catch (IOException ioe) {
            LOG.error("Failed to read content of file 'beautify.js'", (Throwable)ioe);
        }
        this.js_beautify = content;
    }

    private static Map<String, Object> _createOptionMap() {
        HashMap<String, Object> opts = new HashMap<String, Object>();
        opts.put("indent_size", "2");
        opts.put("ident_char", " ");
        opts.put("preserve_newlines", true);
        opts.put("indent_level", 0);
        opts.put("space_after_anon_function", true);
        opts.put("brace_style", "expand");
        return opts;
    }

    public static String beautify(String inputJS) {
        return Singleton_Holder._INSTANCE.doBeautify(inputJS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doBeautify(String input) {
        try {
            Context ctx = Context.enter();
            ctx.setDebugger(null, null);
            ctx.setLanguageVersion(160);
            ScriptableObject scope = ctx.initStandardObjects();
            scope.put("global", (Scriptable)scope, (Object)ctx.newObject((Scriptable)scope));
            ctx.evaluateString((Scriptable)scope, this.js_beautify, "JSBeautify", 1, null);
            Scriptable options = ctx.newObject((Scriptable)scope);
            for (String key : OPTIONS.keySet()) {
                options.put(key, options, OPTIONS.get(key));
            }
            scope.put("opts", (Scriptable)scope, (Object)options);
            scope.put("input", (Scriptable)scope, (Object)input);
            ctx.evaluateString((Scriptable)scope, "var result = global.js_beautify(input, opts);", "JSBeautify", 1, null);
            Object result = scope.get("result", (Scriptable)scope);
            String string = result.toString();
            return string;
        }
        finally {
            Context.exit();
        }
    }

    private static final class Singleton_Holder {
        private static final JSBeautifier _INSTANCE = new JSBeautifier();

        private Singleton_Holder() {
        }
    }
}

