/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.scripting.webdriver;

import com.xceptance.xlt.engine.scripting.util.TextMatchingUtils;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverFinder;
import com.xceptance.xlt.engine.scripting.webdriver.WebDriverUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import org.openqa.selenium.InvalidSelectorException;
import org.openqa.selenium.NoSuchWindowException;
import org.openqa.selenium.WebDriver;

class WindowFinder {
    private static final Strategy IMPLICIT_STRATEGY = new ImplicitStrategy();
    private static final Strategy NAME_STRATEGY = new NameStrategy();
    private static final Strategy TITLE_STRATEGY = new TitleStrategy();
    private final Map<String, Strategy> strategies = new HashMap<String, Strategy>();

    WindowFinder() {
        this.strategies.put("name", NAME_STRATEGY);
        this.strategies.put("title", TITLE_STRATEGY);
        this.strategies.put("implicit", IMPLICIT_STRATEGY);
    }

    String find(WebDriver webDriver, String windowLocator, boolean switchBack) {
        String value;
        String strategyName;
        Matcher m = WebDriverFinder.STRATEGY_PATTERN.matcher(windowLocator);
        if (m.matches()) {
            strategyName = m.group(1);
            value = m.group(2);
        } else {
            strategyName = "implicit";
            value = windowLocator;
        }
        Strategy strategy = this.strategies.get(strategyName);
        if (strategy == null) {
            throw new InvalidSelectorException("Unknown window locator strategy: " + strategyName);
        }
        String windowHandle = strategy.find(webDriver, value, switchBack);
        if (windowHandle == null) {
            throw new NoSuchWindowException("No window found for locator: " + windowLocator);
        }
        return windowHandle;
    }

    private static abstract class Strategy {
        private Strategy() {
        }

        protected abstract String find(WebDriver var1, String var2, boolean var3);
    }

    private static final class ImplicitStrategy
    extends Strategy {
        private ImplicitStrategy() {
        }

        @Override
        protected String find(WebDriver webDriver, String nameOrTitle, boolean switchBack) {
            String windowHandle = NAME_STRATEGY.find(webDriver, nameOrTitle, switchBack);
            if (windowHandle == null) {
                windowHandle = TITLE_STRATEGY.find(webDriver, nameOrTitle, switchBack);
            }
            return windowHandle;
        }
    }

    private static final class NameStrategy
    extends AbstractStrategy {
        private NameStrategy() {
        }

        @Override
        protected boolean checkCurrentWindow(WebDriver webDriver, String name) {
            String windowName = WebDriverUtils.getCurrentWindowName(webDriver);
            return TextMatchingUtils.isAMatch(windowName, name, true, true);
        }
    }

    private static final class TitleStrategy
    extends AbstractStrategy {
        private TitleStrategy() {
        }

        @Override
        protected boolean checkCurrentWindow(WebDriver webDriver, String title) {
            return TextMatchingUtils.isAMatch(webDriver.getTitle(), title, true, true);
        }
    }

    private static abstract class AbstractStrategy
    extends Strategy {
        private AbstractStrategy() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected String find(WebDriver webDriver, String criterion, boolean switchBack) {
            String currentWindow = null;
            if (switchBack) {
                currentWindow = webDriver.getWindowHandle();
            }
            try {
                for (String windowHandle : webDriver.getWindowHandles()) {
                    webDriver.switchTo().window(windowHandle);
                    if (!this.checkCurrentWindow(webDriver, criterion)) continue;
                    String string = windowHandle;
                    return string;
                }
                Iterator iterator = null;
                return iterator;
            }
            finally {
                if (switchBack) {
                    webDriver.switchTo().window(currentWindow);
                }
            }
        }

        protected abstract boolean checkCurrentWindow(WebDriver var1, String var2);
    }
}

