/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.xceptance.xlt.engine.XltWebClient;
import com.xceptance.xlt.engine.util.URLCleaner;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.WebResponse;
import org.htmlunit.WebWindow;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlHead;
import org.htmlunit.html.HtmlPage;
import org.htmlunit.util.UrlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class PageDOMClone {
    private final Document doc;
    private final Map<Element, PageDOMClone> frames;
    private final WebResponse response;
    private final URL baseURL;

    public PageDOMClone(HtmlPage htmlPage, Document document) {
        this.doc = document;
        this.frames = new HashMap<Element, PageDOMClone>();
        this.response = htmlPage.getWebResponse();
        this.baseURL = URLCleaner.removeUserInfoIfNecessaryAsURL(this.determineBaseURL(htmlPage));
    }

    public Document getDocument() {
        return this.doc;
    }

    public synchronized void addFrame(Element element, PageDOMClone frame) {
        this.frames.put(element, frame);
    }

    public Map<Element, PageDOMClone> getFrames() {
        return Collections.unmodifiableMap(this.frames);
    }

    public WebResponse getResponse() {
        return this.response;
    }

    public URL getFullyQualifiedUrl(String relativeUrl) {
        while (((String)relativeUrl).startsWith("http:") && !((String)relativeUrl).startsWith("http://")) {
            relativeUrl = "http:/" + ((String)relativeUrl).substring(5);
        }
        return XltWebClient.makeUrlAbsolute(this.baseURL, (String)relativeUrl);
    }

    private URL determineBaseURL(HtmlPage page) {
        HtmlElement docElement = page.getDocumentElement();
        NodeList baseElements = docElement != null ? docElement.getElementsByTagName("base") : null;
        URL baseUrl = this.getResponse().getWebRequest().getUrl();
        if (baseElements == null || baseElements.isEmpty()) {
            WebWindow window = page.getEnclosingWindow();
            if (window != null && window != window.getTopWindow()) {
                boolean frameSrcIsNotSet = baseUrl == UrlUtils.URL_ABOUT_BLANK;
                boolean frameSrcIsJs = "javascript".equals(baseUrl.getProtocol());
                if (frameSrcIsNotSet || frameSrcIsJs) {
                    baseUrl = ((HtmlPage)page.getEnclosingWindow().getTopWindow().getEnclosedPage()).getWebResponse().getWebRequest().getUrl();
                }
            }
        } else {
            URL u;
            HtmlElement base = (HtmlElement)baseElements.get(0);
            boolean insideHead = false;
            for (DomNode parent = base.getParentNode(); parent != null; parent = parent.getParentNode()) {
                if (!(parent instanceof HtmlHead)) continue;
                insideHead = true;
                break;
            }
            String href = base.getAttribute("href");
            if (insideHead && StringUtils.isNotBlank((CharSequence)href) && (u = XltWebClient.makeUrlAbsolute(baseUrl, href)) != null) {
                baseUrl = u;
            }
        }
        return baseUrl;
    }
}

