/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.common.util.ParseUtils;
import com.xceptance.common.util.RegExUtils;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.SessionImpl;
import com.xceptance.xlt.engine.XltEngine;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.codec.digest.DigestUtils;

public class ErrorCounter {
    private static final String LIMITER_PROPERTY = "com.xceptance.xlt.output2disk.onError.limiter";
    static final String MAX_DUMP_COUNT_PROPERTY = "com.xceptance.xlt.output2disk.onError.limiter.maxDumps";
    static final String COUNTER_RESET_INTERVAL_PROPERTY = "com.xceptance.xlt.output2disk.onError.limiter.resetInterval";
    static final String MAX_DIFFERENT_ERRORS_PROPERTY = "com.xceptance.xlt.output2disk.onError.limiter.maxDifferentErrors";
    static final int MAX_DIFFERENT_ERRORS_DEFAULT = 500;
    static final int MAX_DUMPS_PER_ERROR_DEFAULT = 10;
    static final int COUNTER_RESET_INTERVAL_DEFAULT = 3600;
    private final long resetInterval;
    private final int maxDiffErrors;
    private final int maxDumpCount;
    private final ConcurrentHashMap<String, AtomicInteger> errorCounter = new ConcurrentHashMap();
    private final Timer timer;

    public static ErrorCounter get() {
        return XltEngine.get().errorCounter;
    }

    public static ErrorCounter createInstance(XltPropertiesImpl properties) {
        return new ErrorCounter(properties);
    }

    private ErrorCounter(XltPropertiesImpl properties) {
        this.maxDiffErrors = properties.getPropertySessionLess(MAX_DIFFERENT_ERRORS_PROPERTY).flatMap(ParseNumbers::parseOptionalInt).orElse(500);
        this.maxDumpCount = properties.getPropertySessionLess(MAX_DUMP_COUNT_PROPERTY).flatMap(ParseNumbers::parseOptionalInt).orElse(10);
        String intervalString = properties.getPropertySessionLess(COUNTER_RESET_INTERVAL_PROPERTY).orElse(String.valueOf(3600));
        long tmpInterval = 0L;
        try {
            tmpInterval = ParseUtils.parseTimePeriod(intervalString);
        }
        catch (Exception e) {
            XltLogger.runTimeLogger.warn("The value '{}' of property '{}' cannot be resolved or parsed as time period. Disabling error limiter reset interval, keeping count limitation.", (Object)intervalString, (Object)COUNTER_RESET_INTERVAL_PROPERTY);
        }
        this.resetInterval = tmpInterval * 1000L;
        this.timer = this.resetInterval > 0L ? new Timer("ErrorCounter-ResetTimer", true) : null;
    }

    static String getErrorKey(String userName, Throwable reason) {
        Object key;
        if (reason != null) {
            String r = ThrowableUtils.getMinifiedStackTrace(reason);
            key = RegExUtils.removeAll(r, " \\(user: '(.+)', output: '([0-9]+)'\\)");
            key = userName + "|" + (String)key;
        } else {
            key = userName;
        }
        return DigestUtils.md5Hex((String)key);
    }

    public boolean countDumpIfOpen(SessionImpl session) {
        if (this.maxDiffErrors < 0) {
            return true;
        }
        if (session.hasFailed()) {
            String key = ErrorCounter.getErrorKey(session.getUserName() + "|" + session.getFailedActionName(), session.getFailReason());
            AtomicInteger count = this.errorCounter.get(key);
            if (count == null) {
                if (this.errorCounter.size() >= this.maxDiffErrors) {
                    return false;
                }
                count = this.errorCounter.computeIfAbsent(key, k -> {
                    if (this.timer != null) {
                        this.timer.schedule((TimerTask)new RemovalTask(key), this.resetInterval);
                    }
                    return new AtomicInteger();
                });
            }
            if (this.maxDumpCount == -1) {
                return true;
            }
            if (count.get() < this.maxDumpCount) {
                count.incrementAndGet();
                return true;
            }
        }
        return false;
    }

    public long getResetInterval() {
        return this.resetInterval;
    }

    public long getMaxDifferentErrors() {
        return this.maxDiffErrors;
    }

    public long getMaxDumpCount() {
        return this.maxDumpCount;
    }

    public long getDifferentErrorCount() {
        return this.errorCounter.size();
    }

    private class RemovalTask
    extends TimerTask {
        private final String key;

        public RemovalTask(String key) {
            this.key = key;
        }

        @Override
        public void run() {
            ErrorCounter.this.errorCounter.remove(this.key);
        }
    }
}

