/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.resultbrowser;

import com.xceptance.common.lang.StringUtils;
import com.xceptance.xlt.engine.resultbrowser.UrlMapping;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.htmlunit.util.UrlUtils;

final class CrcUrlMapping
implements UrlMapping {
    CrcUrlMapping() {
    }

    @Override
    public String map(URL url) {
        int port = url.getPort();
        if (port != -1 && port == url.getDefaultPort()) {
            try {
                url = UrlUtils.getUrlWithNewPort(url, -1);
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        return StringUtils.crc32(UrlUtils.encodeUrl(url, StandardCharsets.UTF_8).toString()) + this.getFileSuffix(url);
    }

    @Override
    public String map(String urlString) {
        try {
            return this.map(new URL(urlString));
        }
        catch (MalformedURLException mue) {
            return null;
        }
    }

    private String getFileSuffix(URL url) {
        String path = org.apache.commons.lang3.StringUtils.substringBefore((String)url.getPath(), (String)";");
        Object suffix = org.apache.commons.lang3.StringUtils.substringAfterLast((String)path, (String)".");
        if (suffix == null || ((String)suffix).indexOf(47) != -1) {
            suffix = "";
        }
        if (((String)suffix).length() > 0) {
            suffix = "." + (String)suffix;
        }
        return suffix;
    }
}

