/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.metrics.otel;

import com.xceptance.xlt.api.util.XltProperties;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.sdk.autoconfigure.AutoConfiguredOpenTelemetrySdk;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public final class OpenTelemetryFactory {
    private OpenTelemetryFactory() {
    }

    public static OpenTelemetry create(XltProperties props, Consumer<Map<String, String>> propsCustomizer) {
        Map<String, String> otelProps = OpenTelemetryFactory.lookupProperties(props);
        if (propsCustomizer != null) {
            propsCustomizer.accept(otelProps);
        }
        return OpenTelemetryFactory.create(otelProps);
    }

    public static OpenTelemetry create(XltProperties props) {
        return OpenTelemetryFactory.create(props, null);
    }

    public static OpenTelemetry create(Map<String, String> properties) {
        return AutoConfiguredOpenTelemetrySdk.builder().addPropertiesSupplier(() -> properties).build().getOpenTelemetrySdk();
    }

    private static Map<String, String> lookupProperties(XltProperties props) {
        return props.getProperties().stringPropertyNames().stream().filter(OpenTelemetryFactory::isOTelProp).collect(Collectors.toMap(k -> StringUtils.removeStart((String)k, (String)"secret."), props::getProperty));
    }

    private static boolean isOTelProp(String key) {
        String otelPropPrefix = "otel.";
        return StringUtils.startsWithAny((CharSequence)key, (CharSequence[])new CharSequence[]{"otel.", "secret.otel."});
    }
}

