/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.metrics.graphite;

import com.xceptance.xlt.api.engine.GlobalClock;
import com.xceptance.xlt.engine.metrics.CounterMetric;
import com.xceptance.xlt.engine.metrics.Metric;
import com.xceptance.xlt.engine.metrics.RateMetric;
import com.xceptance.xlt.engine.metrics.ValueMetric;
import com.xceptance.xlt.engine.metrics.graphite.PlainTextCarbonClient;
import com.xceptance.xlt.engine.util.TimerUtils;
import java.io.IOException;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GraphiteReporter {
    private static final Logger log = LoggerFactory.getLogger(GraphiteReporter.class);
    private final PlainTextCarbonClient carbonClient;
    private final String metricNamePrefix;
    private final Map<String, Metric> metrics;
    private int metricCount;
    private final long interval;
    private volatile long lastReportingTime;

    public GraphiteReporter(PlainTextCarbonClient carbonClient, Map<String, Metric> metrics, String metricNamePrefix, int interval) {
        this.metrics = metrics;
        this.carbonClient = carbonClient;
        this.metricNamePrefix = metricNamePrefix;
        this.interval = interval;
        this.lastReportingTime = GlobalClock.millis();
    }

    public void start() {
        final Timer timer = new Timer("GraphiteReporter", true);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                timer.cancel();
                GraphiteReporter.this.report(GraphiteReporter.this.lastReportingTime + GraphiteReporter.this.interval);
            }
        });
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                GraphiteReporter.this.lastReportingTime = GlobalClock.millis();
                GraphiteReporter.this.report(GraphiteReporter.this.lastReportingTime);
            }
        };
        long initialDelay = (long)(Math.random() * (double)this.interval);
        timer.schedule(timerTask, initialDelay, this.interval);
    }

    private void report(long time) {
        this.metricCount = 0;
        try {
            long connectTime = 0L;
            long sentTime = 0L;
            long closeTime = 0L;
            long connectStart = TimerUtils.get().getStartTime();
            this.carbonClient.connect();
            connectTime = TimerUtils.get().getElapsedTime(connectStart);
            long timestamp = time / 1000L;
            long sendStart = TimerUtils.get().getStartTime();
            for (Map.Entry<String, Metric> entry : this.metrics.entrySet()) {
                String metricName = entry.getKey();
                Metric metric = entry.getValue();
                if (metric instanceof ValueMetric) {
                    this.reportTimerMetric(metricName, (ValueMetric)metric, timestamp);
                    continue;
                }
                if (metric instanceof CounterMetric) {
                    this.reportCounterMetric(metricName, (CounterMetric)metric, timestamp);
                    continue;
                }
                if (metric instanceof RateMetric) {
                    this.reportRateMetric(metricName, (RateMetric)metric, timestamp);
                    continue;
                }
                if (!log.isWarnEnabled()) continue;
                log.warn("Skipping unknown metric class: " + metric.getClass().getName());
            }
            sentTime = TimerUtils.get().getElapsedTime(sendStart);
            long closeStart = TimerUtils.get().getStartTime();
            this.carbonClient.close();
            closeTime = TimerUtils.get().getElapsedTime(closeStart);
            if (log.isDebugEnabled()) {
                log.debug(String.format("%d metrics sent within %d ms (%d/%d/%d)", this.metricCount, connectTime + sentTime + closeTime, connectTime, sentTime, closeTime));
            }
        }
        catch (IOException e) {
            this.carbonClient.close();
            log.warn("Failed to report to Graphite: " + String.valueOf(e));
        }
    }

    private void reportTimerMetric(String metricName, ValueMetric metric, long timestamp) throws IOException {
        ValueMetric.Snapshot snapshot = metric.getSnapshotAndClear();
        if (snapshot.getCount() > 0L) {
            this.carbonClient.send(this.prefix(metricName, "mean"), this.format(snapshot.getMean()), timestamp);
            this.carbonClient.send(this.prefix(metricName, "max"), this.format(snapshot.getMaximum()), timestamp);
            this.carbonClient.send(this.prefix(metricName, "min"), this.format(snapshot.getMinimum()), timestamp);
            this.metricCount += 3;
        }
    }

    private void reportCounterMetric(String metricName, CounterMetric metric, long timestamp) throws IOException {
        Long count = metric.getCountAndClear();
        if (count != null) {
            this.carbonClient.send(this.prefix(metricName), this.format(count), timestamp);
            ++this.metricCount;
        }
    }

    private void reportRateMetric(String metricName, RateMetric metric, long timestamp) throws IOException {
        Double rate = metric.getRateAndClear();
        if (rate != null) {
            this.carbonClient.send(this.prefix(metricName), this.format(rate), timestamp);
            ++this.metricCount;
        }
    }

    private String prefix(String ... components) {
        return this.metricNamePrefix + StringUtils.join((Object[])components, (char)'.');
    }

    private String format(long value) {
        return Long.toString(value);
    }

    private String format(double value) {
        return String.format("%.2f", value);
    }
}

