/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.metrics;

import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.engine.Session;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.metrics.MetricsReporter;
import com.xceptance.xlt.engine.metrics.graphite.GraphiteMetricsReporter;
import com.xceptance.xlt.engine.metrics.otel.OpenTelemetryFactory;
import com.xceptance.xlt.engine.metrics.otel.OtelMetricsReporter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    protected static final String PROP_REP_PREFIX = "xlt.reporting.";
    private static final String PROP_REP_ENABLED = "xlt.reporting.enabled";
    private static final String PROP_REP_INTERVAL = "xlt.reporting.interval";
    private static final String PROP_REP_METRIC_NAME_PREFIX = "xlt.reporting.metricNamePrefix";
    private static final String PROP_REP_PREFIX_GRAPHITE = "xlt.reporting.graphite.";
    private static final String PROP_REP_GRAPHITE_SERVER = "xlt.reporting.graphite.host";
    private static final String PROP_REP_GRAPHITE_PORT = "xlt.reporting.graphite.port";
    private static final String PROP_REP_PREFIX_OTEL = "xlt.reporting.otel.";
    private static final Logger log = LoggerFactory.getLogger(Metrics.class);
    private final List<MetricsReporter> _reporters;

    public static Metrics getInstance() {
        return LazySingletonHolder.metrics;
    }

    protected Metrics() {
        XltProperties props = XltProperties.getInstance();
        boolean enabled = props.getProperty(PROP_REP_ENABLED, false);
        int reportingInterval = props.getProperty(PROP_REP_INTERVAL, 5);
        String metricsNamePrefix = props.getProperty(PROP_REP_METRIC_NAME_PREFIX, "");
        boolean graphiteEnabled = props.getProperty("xlt.reporting.graphite.enabled", enabled);
        String graphiteHost = props.getProperty(PROP_REP_GRAPHITE_SERVER, "localhost");
        int graphitePort = props.getProperty(PROP_REP_GRAPHITE_PORT, 2003);
        boolean otelEnabled = props.getProperty("xlt.reporting.otel.enabled", false);
        ArrayList reporters = new ArrayList();
        if (Session.getCurrent().isLoadTest()) {
            if (graphiteEnabled) {
                Metrics.create("graphite", () -> new GraphiteMetricsReporter(reportingInterval, graphiteHost, graphitePort, metricsNamePrefix)).ifPresent(reporters::add);
            }
            if (otelEnabled) {
                Metrics.create("otel", () -> new OtelMetricsReporter(OpenTelemetryFactory.create(props, Metrics::defaultOtelProps))).ifPresent(reporters::add);
            }
        } else {
            log.info("XLT does not run in load-test mode");
        }
        this._reporters = List.copyOf(reporters);
    }

    public void updateMetrics(Data data) {
        this._reporters.forEach(r -> r.reportMetrics(data));
    }

    private static void defaultOtelProps(Map<String, String> otelProps) {
        otelProps.putIfAbsent("otel.sdk.disabled", String.valueOf(false));
        otelProps.putIfAbsent("otel.logs.exporter", "otlp");
        otelProps.putIfAbsent("otel.exporter.otlp.endpoint", "http://localhost:4318");
        otelProps.putIfAbsent("otel.exporter.otlp.protocol", "http/protobuf");
        otelProps.putIfAbsent("otel.blrp.schedule.delay", String.valueOf(2000));
    }

    private static Optional<MetricsReporter> create(String str, Callable<MetricsReporter> reporterSupplier) {
        try {
            return Optional.ofNullable(reporterSupplier.call());
        }
        catch (Exception e) {
            log.error("Failed to start metrics reporter '{}'", (Object)str, (Object)e);
            return Optional.empty();
        }
    }

    private static class LazySingletonHolder {
        private static final Metrics metrics = new Metrics();

        private LazySingletonHolder() {
        }
    }
}

