/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine.har.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.util.ISO8601Utils;
import com.xceptance.xlt.engine.har.model.HarCache;
import com.xceptance.xlt.engine.har.model.HarRequest;
import com.xceptance.xlt.engine.har.model.HarResponse;
import com.xceptance.xlt.engine.har.model.HarTimings;
import java.util.Date;

@JsonPropertyOrder(value={"pageref", "startedDateTime", "time", "request", "response", "cache", "timings", "serverIPAddress", "connection", "comment"})
public class HarEntry {
    private final String pageref;
    private final String startedDateTime;
    private final long time;
    private final HarRequest request;
    private HarResponse response;
    private final HarCache cache;
    private final HarTimings timings;
    private final String serverIPAddress;
    private final String connection;
    private final String comment;

    @JsonCreator
    public HarEntry(@JsonProperty(value="pageref") String pageref, @JsonProperty(value="startedDateTime") String startedDateTime, @JsonProperty(value="time") long time, @JsonProperty(value="request") HarRequest request, @JsonProperty(value="response") HarResponse response, @JsonProperty(value="cache") HarCache cache, @JsonProperty(value="timings") HarTimings timings, @JsonProperty(value="serverIPAddress") String serverIPAddress, @JsonProperty(value="connection") String connection, @JsonProperty(value="comment") String comment) {
        this.pageref = pageref;
        this.startedDateTime = startedDateTime;
        this.time = time;
        this.request = request;
        this.response = response;
        this.cache = cache;
        this.timings = timings;
        this.serverIPAddress = serverIPAddress;
        this.connection = connection;
        this.comment = comment;
    }

    public String getPageref() {
        return this.pageref;
    }

    public String getStartedDateTime() {
        return this.startedDateTime;
    }

    public long getTime() {
        return this.time;
    }

    public HarRequest getRequest() {
        return this.request;
    }

    public HarResponse getResponse() {
        return this.response;
    }

    public HarCache getCache() {
        return this.cache;
    }

    public HarTimings getTimings() {
        return this.timings;
    }

    public String getServerIPAddress() {
        return this.serverIPAddress;
    }

    public String getConnection() {
        return this.connection;
    }

    public String getComment() {
        return this.comment;
    }

    public String toString() {
        return "HarEntry [response = " + String.valueOf(this.response) + ", connection = " + this.connection + ", time = " + this.time + ", pageref = " + this.pageref + ", cache = " + String.valueOf(this.cache) + ", timings = " + String.valueOf(this.timings) + ", request = " + String.valueOf(this.request) + ", comment = " + this.comment + ", serverIPAddress = " + this.serverIPAddress + ", startedDateTime = " + this.startedDateTime + "]";
    }

    public static class Builder {
        private String pageref;
        private String startedDateTime;
        private long time;
        private HarRequest request;
        private HarResponse response;
        private HarCache cache = new HarCache(null, null, null);
        private HarTimings timings;
        private String serverIPAddress;
        private String connection;
        private String comment;

        public Builder withPageref(String pageref) {
            this.pageref = pageref;
            return this;
        }

        public Builder withStartedDateTime(String startedDateTime) {
            this.startedDateTime = startedDateTime;
            return this;
        }

        public Builder withStartedDateTime(Date startedDateTime) {
            this.startedDateTime = ISO8601Utils.format((Date)startedDateTime, (boolean)true);
            return this;
        }

        public Builder withTime(long time) {
            this.time = time;
            return this;
        }

        public Builder withRequest(HarRequest request) {
            this.request = request;
            return this;
        }

        public Builder withResponse(HarResponse response) {
            this.response = response;
            return this;
        }

        public Builder withCache(HarCache cache) {
            this.cache = cache;
            return this;
        }

        public Builder withTimings(HarTimings timings) {
            this.timings = timings;
            return this;
        }

        public Builder withServerIPAddress(String serverIPAddress) {
            this.serverIPAddress = serverIPAddress;
            return this;
        }

        public Builder withConnection(String connection) {
            this.connection = connection;
            return this;
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        public HarEntry build() {
            return new HarEntry(this.pageref, this.startedDateTime, this.time, this.request, this.response, this.cache, this.timings, this.serverIPAddress, this.connection, this.comment);
        }
    }
}

