/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.engine;

import com.xceptance.xlt.engine.resultbrowser.ErrorCounter;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;

public class XltEngine {
    private static XltEngine instance = new XltEngine(true, true);
    private static final VarHandle instanceHandle;
    public final XltPropertiesImpl xltProperties;
    public final ErrorCounter errorCounter;

    private XltEngine(boolean ignoreMissingProperties, boolean staySilent) {
        this(XltPropertiesImpl.createInstance(ignoreMissingProperties, staySilent));
    }

    private XltEngine(XltPropertiesImpl properties) {
        this.xltProperties = properties;
        this.errorCounter = ErrorCounter.createInstance(this.xltProperties);
    }

    public static XltEngine get() {
        return instance;
    }

    public static XltEngine reset(XltPropertiesImpl properties) {
        XltEngine.set(new XltEngine(properties));
        return XltEngine.get();
    }

    public static XltEngine reset() {
        XltEngine.set(new XltEngine(false, false));
        return XltEngine.get();
    }

    private static XltEngine set(XltEngine newInstance) {
        instanceHandle.setVolatile(newInstance);
        return newInstance;
    }

    static {
        try {
            instanceHandle = MethodHandles.lookup().findStaticVarHandle(XltEngine.class, "instance", XltEngine.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

