/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.ec2;

import com.google.common.collect.Sets;
import com.xceptance.common.util.ConsoleUiUtils;
import com.xceptance.xlt.ec2.AbstractEC2Client;
import com.xceptance.xlt.ec2.MachineInfo;
import com.xceptance.xlt.ec2.MachineInfoPrinter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.services.ec2.model.AvailabilityZone;
import software.amazon.awssdk.services.ec2.model.DescribeTagsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeTagsResponse;
import software.amazon.awssdk.services.ec2.model.Filter;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.InstanceStateName;
import software.amazon.awssdk.services.ec2.model.InstanceType;
import software.amazon.awssdk.services.ec2.model.KeyPairInfo;
import software.amazon.awssdk.services.ec2.model.Region;
import software.amazon.awssdk.services.ec2.model.ResourceType;
import software.amazon.awssdk.services.ec2.model.SecurityGroup;
import software.amazon.awssdk.services.ec2.model.Subnet;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagDescription;
import software.amazon.awssdk.services.ec2.model.Vpc;

public class Main
extends AbstractEC2Client {
    private static final String AGENT_CONTROLLER_LINE_FORMAT = "com.xceptance.xlt.mastercontroller.agentcontrollers.ac%03d_%s.url = https://%s:8500";
    private static final Map<String, String> FRIENDLY_REGION_NAMES = new HashMap<String, String>();
    private static final String[] INSTANCE_TYPE_DESCRIPTIONS;
    private static final String[] INSTANCE_TYPES;
    private static final String[] OPERATION_DESCRIPTIONS;
    private static final String[] OPERATION_KEYS;
    private static final String[] OPERATIONS;
    private static final long EVENTUAL_CONSISTENCY_TIMEOUT = 10000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        Options options = Main.createCommandLineOptions();
        CommandLine commandLine = AbstractEC2Client.parseCommandLine(options, args);
        if (commandLine.hasOption("help")) {
            Main.printUsageInfo(options);
        } else {
            Main ec2Admin = null;
            try {
                ec2Admin = new Main();
            }
            catch (Exception e) {
                System.exit(1);
            }
            try {
                if (commandLine.getArgs().length > 0) {
                    String firstArg = (String)commandLine.getArgList().get(0);
                    if (OPERATIONS[0].equals(firstArg) || OPERATIONS[1].equals(firstArg)) {
                        ec2Admin.startNonInteractiveMode(commandLine);
                    } else {
                        Main.printUsageInfo(options);
                        System.exit(2);
                    }
                } else {
                    ec2Admin.administrate(commandLine);
                }
            }
            catch (Exception e) {
                System.err.println("An unexpected error occurred: " + e.getMessage());
                log.error("Unexpected error", (Throwable)e);
                System.exit(1);
            }
            finally {
                ec2Admin.shutdown();
            }
        }
    }

    private void administrate(CommandLine commandLine) {
        while (true) {
            try {
                while (true) {
                    String operation;
                    if ((operation = this.selectOperation()).equals("list")) {
                        this.listInstances();
                        continue;
                    }
                    if (operation.equals("show details")) {
                        this.listMoreDetails();
                        continue;
                    }
                    if (operation.equals("run")) {
                        this.runInstances(commandLine);
                        continue;
                    }
                    if (operation.equals("terminate")) {
                        this.terminateInstances();
                        continue;
                    }
                    if (operation.equals("quit")) break;
                }
                return;
            }
            catch (Exception e) {
                System.err.println("Failed to execute operation: " + e.getMessage());
                log.error("Failed to execute operation", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private void listMoreDetails() {
        List<Region> regions = this.multiSelectRegions();
        List<TagDescription> tags = this.multiSelectTags(regions);
        System.out.print("\nQuerying ");
        this.listInstanceDetails(regions, tags, false);
    }

    private void listInstanceDetails(List<Region> regions, List<TagDescription> tags, boolean runningOrPendingOnly) {
        StringBuilder sb = new StringBuilder();
        String indentStr = StringUtils.repeat((char)' ', (int)2);
        String indent2Str = StringUtils.repeat((char)' ', (int)4);
        if (tags.isEmpty()) {
            sb.append("*all* ");
        }
        sb.append("instances ");
        if (!tags.isEmpty()) {
            sb.append("tagged with:");
            if (tags.size() == 1) {
                TagDescription tag = tags.get(0);
                sb.append(indentStr).append(tag.key()).append("=").append(tag.value()).append("\n");
            } else {
                sb.append('\n');
                for (TagDescription tag : tags) {
                    sb.append(indent2Str).append(tag.key()).append("=").append(tag.value()).append('\n');
                }
            }
            sb.append('\n').append(indentStr);
        }
        sb.append("in region");
        if (regions.size() > 1) {
            sb.append("s:\n");
        } else {
            sb.append(": ");
        }
        System.out.print(sb.toString());
        if (regions.size() == 1) {
            Region singleRegion = regions.get(0);
            System.out.printf("%s ... ", singleRegion.regionName());
            try {
                String s = this.getInstances(singleRegion, tags, indent2Str, runningOrPendingOnly);
                System.out.println("OK\n");
                System.out.println(s);
            }
            catch (Exception e) {
                log.error("Failed to retrieve instances", (Throwable)e);
                System.out.println("Failed: " + e.getMessage());
            }
        } else {
            for (Region region : regions) {
                System.out.printf("\n%s%s ... ", indentStr, region.regionName());
                try {
                    String s = this.getInstances(region, tags, indent2Str, runningOrPendingOnly);
                    System.out.println("OK\n");
                    System.out.println(s);
                }
                catch (Exception e) {
                    System.out.println("Failed: " + e.getMessage());
                }
            }
        }
    }

    private static Options createCommandLineOptions() {
        Options options = new Options();
        options.addOption(null, "help", false, "Show help.");
        options.addOption("o", "outputFile", true, "The file that will contain the agent controller connection properties corresponding to the started instances. If no such file is specified, the properties will be printed to the console.");
        options.addOption("p", "password", true, "The password that is later used when starting the agent controller on the machines.");
        options.addOption("pf", "passwordFile", true, "File that contains the password to pass to the instance.");
        options.addOption("h", "hostData", true, "The host data to pass to the instance. This option will override option 'hf'.");
        options.addOption("hf", "hostDataFile", true, "File that contains the host data to pass to the instance.");
        options.addOption("u", "userData", true, "The user data to pass to the instance. This option will override option 'uf'. Can only be used if no host data or password is set.");
        options.addOption("uf", "userDataFile", true, "File that contains the user data to pass to the instance. Can only be used if no host data or password is set.");
        Option key = new Option("k", "key", true, "Key-pair name for SSH login");
        key.setArgName("key-pair name");
        options.addOption(key);
        options.addOption("nk", "noKey", false, "Start instance without any SSH key.");
        return options;
    }

    private void listInstances() {
        List<Region> regions = this.multiSelectRegions();
        List<TagDescription> tags = this.multiSelectTags(regions);
        this.listInstances(regions, tags);
    }

    private void listInstances(List<Region> regions, List<TagDescription> tags) {
        System.out.println();
        ArrayList<String> agentControllerLines = new ArrayList<String>();
        int pendingInstanceCount = 0;
        int runningInstanceCount = 0;
        for (Region region : regions) {
            String regionName = region.regionName();
            try {
                System.out.printf("Querying all instances in region '%s' ... ", regionName);
                for (Instance instance : this.getInstances(region, tags)) {
                    InstanceStateName state = instance.state().name();
                    if (state == InstanceStateName.RUNNING) {
                        String address = this.getAddress(instance);
                        String agentControllerLine = String.format(AGENT_CONTROLLER_LINE_FORMAT, ++runningInstanceCount, regionName, address);
                        agentControllerLines.add(agentControllerLine);
                        continue;
                    }
                    if (state != InstanceStateName.PENDING) continue;
                    ++pendingInstanceCount;
                }
                System.out.println("OK.");
            }
            catch (SdkException e) {
                System.out.println("Failed: " + e.getMessage());
            }
        }
        System.out.printf("\n%d running and %d pending instance(s) found.\n\n", runningInstanceCount, pendingInstanceCount);
        if (runningInstanceCount > 0) {
            System.out.println("--- Master controller configuration ---");
            for (String agentControllerLine : agentControllerLines) {
                System.out.println(agentControllerLine);
            }
        }
    }

    private String getAddress(Instance instance) {
        String address = instance.publicDnsName();
        if (StringUtils.isBlank((CharSequence)address) && StringUtils.isBlank((CharSequence)(address = instance.publicIpAddress())) && StringUtils.isBlank((CharSequence)(address = instance.privateIpAddress()))) {
            address = "<not available yet>";
        }
        return address;
    }

    private List<Region> multiSelectRegions() {
        List<Region> regions = this.getRegions(new String[0]);
        ArrayList<String> regionNames = new ArrayList<String>();
        for (Region region : regions) {
            regionNames.add(this.getFriendlyRegionName(region));
        }
        return ConsoleUiUtils.multiSelectItems("\nSelect one or more regions:", regionNames, regions, true);
    }

    private List<TagDescription> multiSelectTags(List<Region> regions) {
        TreeMap<CallSite, TagDescription> tags = new TreeMap<CallSite, TagDescription>();
        for (Region region : regions) {
            DescribeTagsRequest describeTagsRequest = (DescribeTagsRequest)DescribeTagsRequest.builder().filters(new Filter[]{(Filter)Filter.builder().name("resource-type").values(new String[]{ResourceType.INSTANCE.toString()}).build()}).build();
            DescribeTagsResponse describeTagsResponse = this.getClient(region).describeTags(describeTagsRequest);
            for (TagDescription tagDescription : describeTagsResponse.tags()) {
                String tagDisplayName = tagDescription.key() + "=" + tagDescription.value();
                tags.put((CallSite)((Object)tagDisplayName), tagDescription);
            }
        }
        if (!tags.isEmpty()) {
            return ConsoleUiUtils.multiSelectItems("\nFilter instances by one or more tags:", new ArrayList<String>(tags.keySet()), new ArrayList(tags.values()), false, "Do not filter (select all)");
        }
        return Collections.emptyList();
    }

    private int readInstanceCount() {
        return ConsoleUiUtils.readInt("\nEnter the number of instances to start:");
    }

    private String getPassword(CommandLine commandLine) {
        String password = this.getPasswordFromCommandLine(commandLine);
        if (StringUtils.isBlank((CharSequence)password)) {
            password = this.queryPassword();
        }
        return password;
    }

    private String queryPassword() {
        return ConsoleUiUtils.readLine("\nEnter agent controller password");
    }

    private String getPasswordFromCommandLine(CommandLine commandLine) {
        String passwordFilePath;
        String password = commandLine.getOptionValue("p");
        if (StringUtils.isBlank((CharSequence)password) && StringUtils.isNotBlank((CharSequence)(passwordFilePath = commandLine.getOptionValue("pf")))) {
            try (BufferedReader br = new BufferedReader(new FileReader(passwordFilePath));){
                password = br.readLine().trim();
                if (br.readLine() != null) {
                    password = null;
                    throw new IOException("Password file must not contain more than one line.");
                }
            }
            catch (IOException e) {
                this.logError("\tCould not read password from file: " + passwordFilePath + ".\n\t>> " + e.getMessage());
            }
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)password, null);
    }

    private String getHostData(CommandLine commandLine) {
        String hostData = this.getHostDataFromCommandLine(commandLine);
        if (StringUtils.isBlank((CharSequence)hostData)) {
            hostData = this.queryHostData();
        }
        return hostData;
    }

    private String getHostDataFromCommandLine(CommandLine commandLine) {
        String hostDatafilePath;
        String hostData = commandLine.getOptionValue("h");
        if (StringUtils.isBlank((CharSequence)hostData) && StringUtils.isNotBlank((CharSequence)(hostDatafilePath = commandLine.getOptionValue("hf")))) {
            try (BufferedReader br = new BufferedReader(new FileReader(hostDatafilePath));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                hostData = sb.toString();
                if (!hostData.isEmpty()) {
                    hostData = hostData.substring(0, hostData.lastIndexOf("\n"));
                }
            }
            catch (IOException e) {
                this.logError("\tCould not read host data from file: " + hostDatafilePath + ".\n\t>> " + e.getMessage());
            }
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)hostData, null);
    }

    private String queryHostData() {
        return ConsoleUiUtils.readLine("\nEnter host data (mark line break with '\\n')");
    }

    private String getUserData(CommandLine commandLine) {
        String userData = this.getUserDataFromCommandLine(commandLine);
        if (StringUtils.isBlank((CharSequence)userData)) {
            userData = this.queryUserData();
        }
        return userData;
    }

    private String getUserDataFromCommandLine(CommandLine commandLine) {
        String userDatafilePath;
        String userData = commandLine.getOptionValue("u");
        if (StringUtils.isBlank((CharSequence)userData) && StringUtils.isNotBlank((CharSequence)(userDatafilePath = commandLine.getOptionValue("uf")))) {
            try (BufferedReader br = new BufferedReader(new FileReader(userDatafilePath));){
                String line;
                StringBuilder sb = new StringBuilder();
                while ((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                userData = sb.toString();
                if (!userData.isEmpty()) {
                    userData = userData.substring(0, userData.lastIndexOf("\n"));
                }
            }
            catch (IOException e) {
                this.logError("\tCould not read user data from file: " + userDatafilePath + ".\n\t>> " + e.getMessage());
            }
        }
        return (String)StringUtils.defaultIfBlank((CharSequence)userData, null);
    }

    private String queryUserData() {
        return ConsoleUiUtils.readLine("\nEnter user data (mark line break with '\\n')");
    }

    private String readInstanceName() {
        return ConsoleUiUtils.readLine("\nEnter the instance name:");
    }

    private void runInstances(CommandLine commandLine) {
        block10: {
            String userData;
            Boolean showUserData;
            AvailabilityZone availabilityZone;
            Region region = this.selectRegion();
            VpcSubnetPair vsp = this.selectVpcAndSubnet(region, availabilityZone = this.selectAvailabilityZone(region));
            if (vsp == null) {
                this.logError("No subnet available for desired region and availability zone.");
                return;
            }
            Image image = this.selectImage(region);
            String instanceType = this.selectInstanceType(region.regionName());
            int instanceCount = this.readInstanceCount();
            String name = this.readInstanceName();
            Collection<String> securityGroupIds = this.getSecurityGroupIDs(commandLine, region);
            String password = this.getPassword(commandLine);
            String hostData = this.getHostData(commandLine);
            if (StringUtils.isBlank((CharSequence)password) && StringUtils.isBlank((CharSequence)hostData)) {
                showUserData = true;
                userData = this.getUserData(commandLine);
            } else {
                showUserData = false;
                userData = null;
            }
            String keyPairName = this.getKeyPairName(commandLine, region);
            StringBuilder sb = new StringBuilder();
            sb.append("\nConfiguration:\n");
            sb.append("  AMI               : ").append(image.imageId()).append(" - ").append(this.describeImage(image)).append("\n");
            sb.append("  Region            : ").append(region.regionName()).append("\n");
            sb.append("  Availability zone : ").append(availabilityZone != null ? availabilityZone.zoneName() : "<unspecified>").append("\n");
            sb.append("  VPC               : ").append(this.getVpcDisplayName(vsp.vpc)).append("\n");
            sb.append("  Subnet            : ").append(this.getSubnetDisplayName(vsp.subnet)).append("\n");
            sb.append("  Type              : ").append(instanceType).append("\n");
            sb.append("  Count             : ").append(instanceCount).append("\n");
            sb.append("  Name              : ").append(name).append("\n");
            sb.append("  Key-pair          : ").append(StringUtils.isBlank((CharSequence)keyPairName) ? "<none>" : keyPairName).append("\n");
            sb.append("  Password          : ").append(StringUtils.isBlank((CharSequence)password) ? "<none>" : password).append("\n");
            sb.append("  Host data         : ").append(StringUtils.isBlank((CharSequence)hostData) ? "<none>" : hostData).append("\n");
            if (showUserData.booleanValue()) {
                sb.append("  User data         : ").append(StringUtils.isBlank((CharSequence)userData) ? "<none>" : userData).append("\n");
            }
            sb.append("\n");
            sb.append("Do you want to run the instance(s) with the above configuration?");
            if (ConsoleUiUtils.confirm(sb.toString())) {
                boolean instancesStarted = false;
                String warnMsg = "\n\n  WARNING: Despite of the previous error, some instances might have been started nevertheless.\n           Please check their status. Also note that some of them might not be tagged with any name.";
                String errMsg = "Failed to start " + instanceCount + " instances in region '" + region.regionName() + "'";
                try {
                    System.out.println("\nStarting instances in region '" + region.regionName() + "'");
                    System.out.printf(" - creating instances     ... ", new Object[0]);
                    List<Instance> instances = this.runInstances(region, vsp.subnet, image, instanceType, instanceCount, securityGroupIds, keyPairName, this.buildUserData(password, hostData, userData));
                    System.out.println("OK");
                    instancesStarted = true;
                    boolean checkAvailability = true;
                    do {
                        try {
                            System.out.printf(" - checking availability  ... ", new Object[0]);
                            this.waitForInstancesToEventuallyExist(region, instances, 10000L);
                            System.out.println("OK");
                            checkAvailability = false;
                        }
                        catch (Exception e) {
                            System.out.println("Failed: " + e.getMessage());
                            if (ConsoleUiUtils.confirm("\nWait a bit longer for all instances to become available? (recommended)")) continue;
                            log.error(errMsg, (Throwable)e);
                            System.out.println("\n\n  WARNING: Despite of the previous error, some instances might have been started nevertheless.\n           Please check their status. Also note that some of them might not be tagged with any name.");
                            return;
                        }
                    } while (checkAvailability);
                    System.out.printf(" - applying 'Name' tag    ... ", new Object[0]);
                    this.setInstanceName(region, instances, name);
                    System.out.println("OK");
                }
                catch (Exception e) {
                    log.error(errMsg, (Throwable)e);
                    System.out.println("Failed: " + e.getMessage());
                    if (!instancesStarted) break block10;
                    System.out.println("\n\n  WARNING: Despite of the previous error, some instances might have been started nevertheless.\n           Please check their status. Also note that some of them might not be tagged with any name.");
                }
            }
        }
    }

    private VpcSubnetPair selectVpcAndSubnet(Region region, AvailabilityZone availabilityZone) {
        List<Subnet> allSubnets = this.getSubnets(region, availabilityZone, null);
        if (allSubnets.isEmpty()) {
            return null;
        }
        List<String> vpcIds = allSubnets.stream().map(net -> net.vpcId()).distinct().collect(Collectors.toList());
        Vpc vpc = this.selectVpc(region, vpcIds);
        String vpcId = vpc.vpcId();
        List<Subnet> vpcSubnets = allSubnets.stream().filter(net -> vpcId.equals(net.vpcId())).collect(Collectors.toList());
        Subnet subnet = this.selectSubnet(vpcSubnets);
        return new VpcSubnetPair(vpc, subnet);
    }

    private Subnet selectSubnet(List<Subnet> subnets) {
        if (subnets.size() > 1) {
            List<String> displayNames = subnets.stream().map(this::getSubnetDisplayName).collect(Collectors.toList());
            return ConsoleUiUtils.selectItem("\nWhich subnet should the instance(s) be launched into?", displayNames, subnets);
        }
        return subnets.isEmpty() ? null : subnets.get(0);
    }

    private String getKeyPairName(CommandLine commandLine, Region region) {
        String keyPairName = null;
        if (!commandLine.hasOption("nk")) {
            keyPairName = this.getKeyPairNameFromCommandLine(commandLine);
            if (StringUtils.isBlank((CharSequence)keyPairName)) {
                keyPairName = this.awsConfiguration.getSshKey(region.regionName());
                if (StringUtils.isBlank((CharSequence)keyPairName)) {
                    keyPairName = this.getKeypairNameFromUser(region);
                } else if (!this.doesKeyPairExist(keyPairName, region)) {
                    System.out.printf("\nThe configured key-pair '%s' does not exist for region '%s'.", keyPairName, region.regionName());
                    keyPairName = this.getKeypairNameFromUser(region);
                }
            } else if (!this.doesKeyPairExist(keyPairName, region)) {
                System.out.printf("\nThe key-pair '%s' does not exist for region '%s'.", keyPairName, region.regionName());
                keyPairName = this.getKeypairNameFromUser(region);
            }
        }
        return keyPairName;
    }

    private String getKeyPairNameFromCommandLine(CommandLine commandLine) {
        return commandLine.hasOption("nk") ? null : commandLine.getOptionValue("k");
    }

    private String getKeypairNameFromUser(Region region) {
        KeyPairInfo keyPairInfo = this.selectKeyPair(region);
        return keyPairInfo != null ? keyPairInfo.keyName() : null;
    }

    private boolean doesKeyPairExist(String keyPairName, Region region) {
        for (KeyPairInfo keyPairInfo : this.getKeyPairs(region)) {
            if (!keyPairInfo.keyName().equals(keyPairName)) continue;
            return true;
        }
        return false;
    }

    private Collection<String> getSecurityGroupIDs(CommandLine commandLine, Region region) {
        Collection<String> securityGroups = this.getSecurityGroupIDsFromCommandLine(commandLine);
        if (securityGroups == null) {
            // empty if block
        }
        return securityGroups;
    }

    private Collection<String> getSecurityGroupIDsFromCommandLine(CommandLine commandLine) {
        String securityGroupsString = commandLine.getOptionValue("s");
        if (StringUtils.isNotBlank((CharSequence)securityGroupsString)) {
            return Sets.newHashSet((Object[])securityGroupsString.split(","));
        }
        return null;
    }

    private Collection<String> selectSecurityGroupIDs(Region region) {
        List<SecurityGroup> securityGroups = this.getSecurityGroupIDs(region);
        ArrayList<String> displayNames = new ArrayList<String>();
        for (SecurityGroup securityGroup : securityGroups) {
            if (!StringUtils.isBlank((CharSequence)securityGroup.vpcId())) continue;
            displayNames.add(securityGroup.groupName() + " - " + securityGroup.description() + " (" + securityGroup.groupId() + ")");
        }
        List<SecurityGroup> selectedGroups = ConsoleUiUtils.multiSelectItems("\nSelect the security group to use for the new EC2 instances:", displayNames, securityGroups, true);
        HashSet<String> groupIDs = new HashSet<String>();
        for (SecurityGroup selectedGroup : selectedGroups) {
            groupIDs.add(selectedGroup.groupId());
        }
        return groupIDs;
    }

    private void setInstanceName(Region region, List<Instance> instances, String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            List<String> instanceIDs = this.getInstanceIds(instances);
            this.setNameTag(region, instanceIDs, name);
        }
    }

    private AvailabilityZone selectAvailabilityZone(Region region) {
        ArrayList<String> displayNames = new ArrayList<String>();
        List<AvailabilityZone> availabilityZones = this.getAvailabilityZones(region);
        for (AvailabilityZone availabilityZone : availabilityZones) {
            displayNames.add(availabilityZone.zoneName());
        }
        displayNames.add(0, "<unspecified>");
        availabilityZones.add(0, null);
        return ConsoleUiUtils.selectItem("\nSelect the availability zone to use for the new EC2 instances:", displayNames, availabilityZones);
    }

    private Image selectImage(Region region) {
        ArrayList<String> displayNames = new ArrayList<String>();
        List<Image> images = this.getImages(region, new String[0]);
        Optional imageWithLongestId = images.stream().max((i1, i2) -> Integer.compare(i1.imageId().length(), i2.imageId().length()));
        int maxIdLength = imageWithLongestId.isPresent() ? ((Image)imageWithLongestId.get()).imageId().length() : 21;
        Collections.sort(images, (i1, i2) -> this.describeImage((Image)i1).compareTo(this.describeImage((Image)i2)));
        for (Image image : images) {
            displayNames.add(StringUtils.rightPad((String)image.imageId(), (int)maxIdLength) + " - " + this.describeImage(image));
        }
        return ConsoleUiUtils.selectItem("\nSelect the machine image to use for the new EC2 instances:", displayNames, images);
    }

    private KeyPairInfo selectKeyPair(Region region) {
        ArrayList<String> displayNames = new ArrayList<String>();
        List<KeyPairInfo> keyPairInfos = this.getKeyPairs(region);
        for (KeyPairInfo keyPairInfo : keyPairInfos) {
            displayNames.add(keyPairInfo.keyName());
        }
        displayNames.add(0, "<none>");
        keyPairInfos.add(0, null);
        return ConsoleUiUtils.selectItem("\nSelect the key-pair to use for the new EC2 instances:", displayNames, keyPairInfos);
    }

    private String selectInstanceType(String regionName) {
        ArrayList<String> displayNames = new ArrayList<String>();
        for (int i = 0; i < INSTANCE_TYPES.length; ++i) {
            displayNames.add(String.format("%-11s - %s", INSTANCE_TYPES[i], INSTANCE_TYPE_DESCRIPTIONS[i]));
        }
        return ConsoleUiUtils.selectItem("\nSelect the instance type to use for the new EC2 instances:", displayNames, Arrays.asList(INSTANCE_TYPES));
    }

    private String selectOperation() {
        return ConsoleUiUtils.selectItem("\nWhat do you want to do?", Arrays.asList(OPERATION_KEYS), Arrays.asList(OPERATION_DESCRIPTIONS), Arrays.asList(OPERATIONS));
    }

    private Region selectRegion() {
        List<Region> regions = this.getRegions(new String[0]);
        ArrayList<String> regionNames = new ArrayList<String>();
        for (Region region : regions) {
            regionNames.add(this.getFriendlyRegionName(region));
        }
        return ConsoleUiUtils.selectItem("\nSelect a region:", regionNames, regions);
    }

    private String getFriendlyRegionName(Region region) {
        String regionName = region.regionName();
        String friendlyRegionName = FRIENDLY_REGION_NAMES.get(regionName);
        if (friendlyRegionName == null) {
            friendlyRegionName = FRIENDLY_REGION_NAMES.get("");
        }
        return friendlyRegionName + " (" + regionName + ")";
    }

    private void terminateInstances() {
        List<Region> regions = this.multiSelectRegions();
        List<TagDescription> tags = this.multiSelectTags(regions);
        System.out.print("\nYou selected to terminate ");
        this.listInstanceDetails(regions, tags, true);
        if (ConsoleUiUtils.confirm("\nAre you sure?")) {
            this.terminateInstances(regions, tags);
        }
    }

    private String getInstances(Region region, List<TagDescription> tags, String lineOffset, boolean runningPendingOnly) throws SdkException {
        StringBuilder output = new StringBuilder();
        int pendingInstanceCount = 0;
        int runningInstanceCount = 0;
        int stoppedInstanceCount = 0;
        LinkedList<MachineInfo> runningMachines = new LinkedList<MachineInfo>();
        HashMap<String, Image> imagesById = new HashMap<String, Image>();
        for (Instance instance : this.getInstances(region, tags)) {
            InstanceStateName state = instance.state().name();
            if (state == InstanceStateName.TERMINATED || state == InstanceStateName.SHUTTING_DOWN) continue;
            if (state == InstanceStateName.RUNNING) {
                ++runningInstanceCount;
            } else if (state == InstanceStateName.PENDING) {
                ++pendingInstanceCount;
            } else if (state == InstanceStateName.STOPPED || state == InstanceStateName.STOPPING) {
                if (runningPendingOnly) continue;
                ++stoppedInstanceCount;
            }
            String imageId = instance.imageId();
            Image image = (Image)imagesById.get(imageId);
            if (image == null && (image = this.getImage(region, imageId)) != null) {
                imagesById.put(imageId, image);
            }
            MachineInfo currentMachineInfo = MachineInfo.createMachineInfo(instance, image);
            runningMachines.add(currentMachineInfo);
        }
        output.append(lineOffset);
        if (runningInstanceCount + pendingInstanceCount + stoppedInstanceCount > 0) {
            if (runningPendingOnly) {
                output.append(String.format("%d running and %d pending instance(s) found.\n", runningInstanceCount, pendingInstanceCount));
            } else {
                output.append(String.format("%d running, %d pending and %d stopped instance(s) found.\n", runningInstanceCount, pendingInstanceCount, stoppedInstanceCount));
            }
            output.append(MachineInfoPrinter.prettyPrint(runningMachines, lineOffset));
        } else if (runningPendingOnly) {
            output.append("No running or pending instance(s) found.\n");
        } else {
            output.append("No running, pending or stopped instance(s) found.\n");
        }
        return output.toString();
    }

    private void startNonInteractiveMode(CommandLine commandLine) {
        String[] args = commandLine.getArgs();
        String executeCommand = args[0];
        if (executeCommand.equals(OPERATIONS[0])) {
            if (args.length == 6) {
                String outputFileString = commandLine.getOptionValue("o");
                Collection<String> securityGroupIDs = null;
                String password = this.getPasswordFromCommandLine(commandLine);
                String hostData = this.getHostDataFromCommandLine(commandLine);
                String userData = StringUtils.isBlank((CharSequence)password) && StringUtils.isBlank((CharSequence)hostData) ? this.getUserDataFromCommandLine(commandLine) : null;
                String keyPairName = this.getKeyPairNameFromCommandLine(commandLine);
                File outputFile = outputFileString != null ? new File(outputFileString) : null;
                this.runInstancesNonInteractiveMode(args[1], args[2], args[3], args[4], args[5], outputFile, securityGroupIDs, keyPairName, password, hostData, userData);
            } else {
                this.dieWithMessage("Use \"run <region> <ami> <type> <count> <nameTag>\"");
            }
        } else if (executeCommand.equals(OPERATIONS[1])) {
            if (args.length == 3) {
                this.terminateInstancesNonInteractiveMode(args[1], args[2]);
            } else {
                this.dieWithMessage("Use \"terminate <region> <nameTag>\"");
            }
        } else {
            this.dieWithMessage("Unknown command: " + executeCommand);
        }
    }

    private void runInstancesNonInteractiveMode(String regionName, String imageName, String type, String instanceCountAsString, String nameTag, File outputFile, Collection<String> securityGroupIDs, String keyPairName, String password, String hostData, String userData) {
        Region region;
        Image image;
        if (!FRIENDLY_REGION_NAMES.containsKey(regionName)) {
            this.dieWithMessage("Region '" + regionName + "' is unknown.");
        }
        if (StringUtils.isBlank((CharSequence)imageName)) {
            this.dieWithMessage("Image must not be blank.");
        }
        if (!this.isInstanceTypeSupported(type)) {
            this.dieWithMessage("Instance type '" + type + "' is not supported.");
        }
        int instanceCount = 0;
        try {
            instanceCount = Integer.parseInt(instanceCountAsString);
            if (instanceCount < 1) {
                this.dieWithMessage("The instance count '" + instanceCountAsString + "' must be a positive integer value greater than zero.");
            }
        }
        catch (NumberFormatException e) {
            this.dieWithMessage("The instance count '" + instanceCountAsString + "' must be a positive integer value greater than zero.");
        }
        if (StringUtils.isBlank((CharSequence)nameTag)) {
            this.dieWithMessage("The tag name must not be blank.");
        }
        if ((image = this.getImage(region = this.getRegion(regionName), imageName)) == null) {
            this.dieWithMessage("Image '" + imageName + "' not available in this region.");
        }
        String nameOfRegion = region.regionName();
        System.out.printf("\nStarting instances in region '%s' ... ", nameOfRegion);
        ArrayList<String> agentControllerConnectionProperties = new ArrayList<String>();
        try {
            List<Instance> instances = this.runInstances(region, null, image, type, instanceCount, securityGroupIDs, keyPairName, this.buildUserData(password, hostData, userData));
            long timeout = Math.max((long)this.awsConfiguration.getInstanceConnectTimeout(), 10000L);
            long deadline = System.currentTimeMillis() + timeout;
            this.waitForInstancesToEventuallyExist(region, instances, timeout);
            this.setInstanceName(region, instances, nameTag);
            for (int i = 0; i < instances.size(); ++i) {
                Instance instance = instances.get(i);
                long remainingTimeout = deadline - System.currentTimeMillis();
                Instance startedInstance = this.waitForInstanceState(region, instance, InstanceStateName.RUNNING, remainingTimeout);
                agentControllerConnectionProperties.add(String.format(AGENT_CONTROLLER_LINE_FORMAT, i + 1, nameOfRegion, this.getAddress(startedInstance)));
            }
            System.out.println("OK.");
        }
        catch (Exception e) {
            this.dieWithMessage("Failed: " + e.getMessage());
        }
        this.outputAgentControllerConnectionProperties(agentControllerConnectionProperties, outputFile);
    }

    private void outputAgentControllerConnectionProperties(List<String> agentControllerConnectionProperties, File outputFile) {
        if (outputFile != null) {
            this.outputToFile(agentControllerConnectionProperties, outputFile);
        } else {
            this.outputToConsole(agentControllerConnectionProperties);
        }
    }

    private void terminateInstancesNonInteractiveMode(String regionName, String nameTag) {
        if (StringUtils.isBlank((CharSequence)regionName) || !FRIENDLY_REGION_NAMES.containsKey(regionName)) {
            this.dieWithMessage("Region '" + regionName + "' is unknown.");
        }
        if (StringUtils.isBlank((CharSequence)nameTag)) {
            this.dieWithMessage("Tag name must not be '" + regionName + "' blank.");
        }
        Region region = this.getRegion(regionName);
        ArrayList<TagDescription> tagDescriptions = new ArrayList<TagDescription>();
        DescribeTagsResponse describeTagsResponse = this.getClient(region).describeTags((DescribeTagsRequest)DescribeTagsRequest.builder().build());
        for (TagDescription tagDescription : describeTagsResponse.tags()) {
            if (tagDescription.resourceType() != ResourceType.INSTANCE || !tagDescription.value().equals(nameTag)) continue;
            tagDescriptions.add(tagDescription);
            break;
        }
        if (tagDescriptions.isEmpty()) {
            this.dieWithMessage("There are no instances with the specified tag name '" + nameTag + "' in region '" + regionName + "'.");
        }
        ArrayList<Region> regions = new ArrayList<Region>();
        regions.add(region);
        this.terminateInstances(regions, tagDescriptions);
    }

    private void outputToFile(List<String> publicDnsNames, File outputFile) {
        try {
            FileUtils.writeLines((File)outputFile, publicDnsNames);
        }
        catch (IOException e) {
            this.logError(e.getMessage());
        }
    }

    private void outputToConsole(List<String> agentControllerConnectionProperties) {
        StringBuilder sb = new StringBuilder();
        for (String property : agentControllerConnectionProperties) {
            sb.append(property).append("\n");
        }
        System.out.println(sb.toString().trim());
    }

    private void logError(String errorMessage) {
        System.err.println("\nError:");
        System.err.println(errorMessage);
        log.error(errorMessage);
    }

    private void dieWithMessage(String msg) {
        this.logError(msg);
        System.exit(1);
    }

    private boolean isInstanceTypeSupported(String instanceType) {
        return ArrayUtils.contains((Object[])INSTANCE_TYPES, (Object)instanceType);
    }

    private String describeImage(Image image) {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.getNameTagValue(image.tags()).orElse(null), (CharSequence)((String)StringUtils.defaultIfBlank((CharSequence)image.description(), (CharSequence)"(no description)")));
    }

    private String buildUserData(String password, String hostData, String userData) {
        if (StringUtils.isNotBlank((CharSequence)password) || StringUtils.isNotBlank((CharSequence)hostData)) {
            JSONObject userDataObj = new JSONObject();
            userDataObj.put("acPassword", (Object)(StringUtils.isNotBlank((CharSequence)password) ? password : ""));
            userDataObj.put("hostData", (Object)(StringUtils.isNotBlank((CharSequence)hostData) ? hostData.replaceAll("\\\\n", "\n") : ""));
            return userDataObj.toString();
        }
        return userData;
    }

    private Vpc selectVpc(Region region, List<String> vpcIds) {
        List<Vpc> vpcs = this.getVpcs(region, vpcIds);
        if (vpcs.size() > 1) {
            List<String> vpcNames = vpcs.stream().map(this::getVpcDisplayName).collect(Collectors.toList());
            return ConsoleUiUtils.selectItem("\nMultiple VPCs found for selected region.\nPlease select the desired one:", vpcNames, vpcs);
        }
        return vpcs.isEmpty() ? null : vpcs.get(0);
    }

    private String getVpcDisplayName(Vpc vpc) {
        StringBuilder sb = new StringBuilder(vpc.vpcId());
        Optional<String> nameTag = this.getNameTagValue(vpc.tags());
        if (nameTag.isPresent()) {
            sb.append(" | ").append(nameTag.get());
        }
        if (vpc.isDefault().booleanValue()) {
            sb.append(" *default*");
        }
        return sb.toString();
    }

    private String getSubnetDisplayName(Subnet subnet) {
        StringBuilder sb = new StringBuilder(subnet.subnetId());
        sb.append(" (").append(subnet.availabilityZone()).append(")");
        Optional<String> nameTag = this.getNameTagValue(subnet.tags());
        if (nameTag.isPresent()) {
            sb.append(" | ").append(nameTag.get());
        }
        sb.append(" [").append(subnet.cidrBlock()).append("]");
        if (subnet.defaultForAz().booleanValue()) {
            sb.append(" *default*");
        }
        return sb.toString();
    }

    protected Optional<String> getNameTagValue(List<Tag> tags) {
        if (tags != null) {
            return tags.stream().filter(t -> "Name".equals(t.key())).findFirst().map(t -> t.value());
        }
        return Optional.empty();
    }

    static {
        FRIENDLY_REGION_NAMES.put("af-south-1", "Africa        - Cape Town       ");
        FRIENDLY_REGION_NAMES.put("ap-east-1", "Asia Pacific  - Hong Kong       ");
        FRIENDLY_REGION_NAMES.put("ap-northeast-1", "Asia Pacific  - Tokyo           ");
        FRIENDLY_REGION_NAMES.put("ap-northeast-2", "Asia Pacific  - Seoul           ");
        FRIENDLY_REGION_NAMES.put("ap-northeast-3", "Asia Pacific  - Osaka           ");
        FRIENDLY_REGION_NAMES.put("ap-south-1", "Asia Pacific  - Mumbai          ");
        FRIENDLY_REGION_NAMES.put("ap-south-2", "Asia Pacific  - Hyderabad       ");
        FRIENDLY_REGION_NAMES.put("ap-southeast-1", "Asia Pacific  - Singapore       ");
        FRIENDLY_REGION_NAMES.put("ap-southeast-2", "Asia Pacific  - Sydney          ");
        FRIENDLY_REGION_NAMES.put("ap-southeast-3", "Asia Pacific  - Jakarta         ");
        FRIENDLY_REGION_NAMES.put("ap-southeast-4", "Asia Pacific  - Melbourne       ");
        FRIENDLY_REGION_NAMES.put("ca-central-1", "Canada        - Central         ");
        FRIENDLY_REGION_NAMES.put("eu-central-1", "Europe        - Frankfurt       ");
        FRIENDLY_REGION_NAMES.put("eu-central-2", "Europe        - Zurich          ");
        FRIENDLY_REGION_NAMES.put("eu-north-1", "Europe        - Stockholm       ");
        FRIENDLY_REGION_NAMES.put("eu-south-1", "Europe        - Milan           ");
        FRIENDLY_REGION_NAMES.put("eu-south-2", "Europe        - Spain           ");
        FRIENDLY_REGION_NAMES.put("eu-west-1", "Europe        - Ireland         ");
        FRIENDLY_REGION_NAMES.put("eu-west-2", "Europe        - London          ");
        FRIENDLY_REGION_NAMES.put("eu-west-3", "Europe        - Paris           ");
        FRIENDLY_REGION_NAMES.put("il-central-1", "Israel        - Tel Aviv        ");
        FRIENDLY_REGION_NAMES.put("me-central-1", "Middle East   - UAE             ");
        FRIENDLY_REGION_NAMES.put("me-south-1", "Middle East   - Bahrain         ");
        FRIENDLY_REGION_NAMES.put("sa-east-1", "South America - Sao Paulo       ");
        FRIENDLY_REGION_NAMES.put("us-east-1", "US East       - North Virginia  ");
        FRIENDLY_REGION_NAMES.put("us-east-2", "US East       - Ohio            ");
        FRIENDLY_REGION_NAMES.put("us-west-1", "US West       - North California");
        FRIENDLY_REGION_NAMES.put("us-west-2", "US West       - Oregon          ");
        FRIENDLY_REGION_NAMES.put("", "<unknown>     - <unknown>       ");
        INSTANCE_TYPE_DESCRIPTIONS = new String[]{" 2 cores,   8.0 compute units,   3.75 GB RAM, EBS-only", " 4 cores,  16.0 compute units,   7.50 GB RAM, EBS-only", " 8 cores,  31.0 compute units,  15.00 GB RAM, EBS-only", "16 cores,  62.0 compute units,  30.00 GB RAM, EBS-only", "36 cores, 132.0 compute units,  60.00 GB RAM, EBS-only", " 2 cores,   9.0 compute units,   4.00 GB RAM, EBS-only", " 4 cores,  17.0 compute units,   8.00 GB RAM, EBS-only", " 8 cores,  34.0 compute units,  16.00 GB RAM, EBS-only", "16 cores,  68.0 compute units,  32.00 GB RAM, EBS-only", "36 cores, 141.0 compute units,  72.00 GB RAM, EBS-only", "72 cores, 281.0 compute units, 144.00 GB RAM, EBS-only", " 2 cores,   6.5 compute units,   8.00 GB RAM, EBS-only", " 4 cores,  13.0 compute units,  16.00 GB RAM, EBS-only", " 8 cores,  26.0 compute units,  32.00 GB RAM, EBS-only", "16 cores,  53.5 compute units,  64.00 GB RAM, EBS-only", " 2 cores,   8.0 compute units,   8.00 GB RAM, EBS-only", " 4 cores,  16.0 compute units,  16.00 GB RAM, EBS-only", " 8 cores,  31.0 compute units,  32.00 GB RAM, EBS-only", "16 cores,  60.0 compute units,  64.00 GB RAM, EBS-only", " 2 cores,   7.0 compute units,  15.25 GB RAM, EBS-only", " 4 cores,  13.5 compute units,  30.50 GB RAM, EBS-only", " 8 cores,  27.0 compute units,  61.00 GB RAM, EBS-only", "16 cores,  53.0 compute units, 122.00 GB RAM, EBS-only", " 2 cores,   8.0 compute units,  16.00 GB RAM, EBS-only", " 4 cores,  16.0 compute units,  32.00 GB RAM, EBS-only", " 8 cores,  31.0 compute units,  64.00 GB RAM, EBS-only", "16 cores,  60.0 compute units, 128.00 GB RAM, EBS-only"};
        INSTANCE_TYPES = new String[]{InstanceType.C4_LARGE.toString(), InstanceType.C4_XLARGE.toString(), InstanceType.C4_2_XLARGE.toString(), InstanceType.C4_4_XLARGE.toString(), InstanceType.C4_8_XLARGE.toString(), InstanceType.C5_LARGE.toString(), InstanceType.C5_XLARGE.toString(), InstanceType.C5_2_XLARGE.toString(), InstanceType.C5_4_XLARGE.toString(), InstanceType.C5_9_XLARGE.toString(), InstanceType.C5_18_XLARGE.toString(), InstanceType.M4_LARGE.toString(), InstanceType.M4_XLARGE.toString(), InstanceType.M4_2_XLARGE.toString(), InstanceType.M4_4_XLARGE.toString(), InstanceType.M5_LARGE.toString(), InstanceType.M5_XLARGE.toString(), InstanceType.M5_2_XLARGE.toString(), InstanceType.M5_4_XLARGE.toString(), InstanceType.R4_LARGE.toString(), InstanceType.R4_XLARGE.toString(), InstanceType.R4_2_XLARGE.toString(), InstanceType.R4_4_XLARGE.toString(), InstanceType.R5_LARGE.toString(), InstanceType.R5_XLARGE.toString(), InstanceType.R5_2_XLARGE.toString(), InstanceType.R5_4_XLARGE.toString()};
        OPERATION_DESCRIPTIONS = new String[]{"Run new instances", "Terminate instances", "List running instances", "Show instance details", "Quit"};
        OPERATION_KEYS = new String[]{"r", "t", "l", "d", "q"};
        OPERATIONS = new String[]{"run", "terminate", "list", "show details", "quit"};
    }

    private static class VpcSubnetPair {
        private final Vpc vpc;
        private final Subnet subnet;

        private VpcSubnetPair(Vpc aVpc, Subnet aSubnet) {
            this.vpc = aVpc;
            this.subnet = aSubnet;
        }
    }
}

