/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.ec2;

import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import software.amazon.awssdk.services.ec2.model.Image;
import software.amazon.awssdk.services.ec2.model.Instance;
import software.amazon.awssdk.services.ec2.model.Tag;

public class MachineInfo {
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd HH:mm");
    private final String host;
    private final String launchTime;
    private final String nameTag;
    private final String type;
    private final long runtime;
    private final String upTime;
    private final String keyName;
    private final String securityGroups;
    private final String state;
    private final String imageName;

    public String getHost() {
        return this.host;
    }

    public String getLaunchTime() {
        return this.launchTime;
    }

    public String getNameTag() {
        return this.nameTag;
    }

    public String getType() {
        return this.type;
    }

    public String getUpTime() {
        return this.upTime;
    }

    public long getRuntime() {
        return this.runtime;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getSecurityGroups() {
        return this.securityGroups;
    }

    public String getState() {
        return this.state;
    }

    private MachineInfo(String nameTag, String host, String launchTime, long runtime, String type, String keyName, String imageName, String securityGroups, String state) {
        this.nameTag = nameTag;
        this.host = host;
        this.launchTime = launchTime;
        this.runtime = runtime;
        this.type = type;
        this.keyName = keyName;
        this.imageName = imageName;
        this.securityGroups = securityGroups;
        this.state = state;
        this.upTime = MachineInfo.getUptimeStr(runtime);
    }

    public static MachineInfo createMachineInfo(Instance instance, Image image) {
        String name = MachineInfo.getNameFromTags(instance.tags()).orElse("<not tagged>");
        String address = instance.publicIpAddress();
        if (StringUtils.isBlank((CharSequence)address)) {
            address = (String)StringUtils.defaultIfBlank((CharSequence)instance.publicDnsName(), (CharSequence)"<unknown>");
        }
        Instant launchStart = instance.launchTime();
        Duration diffToNow = Duration.between(launchStart, Instant.now());
        long runTime = diffToNow.toMinutes();
        List secGroups = instance.securityGroups().stream().map(g -> g.groupName()).collect(Collectors.toList());
        String imageName = (String)StringUtils.defaultIfBlank((CharSequence)MachineInfo.getImageName(image), (CharSequence)instance.imageId());
        return new MachineInfo(name, address, TIME_FORMATTER.format(Date.from(launchStart)), runTime, instance.instanceType().toString(), StringUtils.defaultString((String)instance.keyName(), (String)"<none>"), imageName, secGroups.isEmpty() ? "<none>" : StringUtils.join(secGroups, (String)"; "), instance.state().name().toString());
    }

    private static String getImageName(Image image) {
        if (image == null) {
            return null;
        }
        return MachineInfo.getNameFromTags(image.tags()).orElse((String)StringUtils.defaultIfBlank((CharSequence)image.name(), (CharSequence)image.description()));
    }

    private static Optional<String> getNameFromTags(List<Tag> tags) {
        return tags.stream().filter(tag -> tag.key().equals("Name")).map(tag -> tag.value()).findAny();
    }

    private static String getUptimeStr(long runtimeInMinutes) {
        StringBuilder sb = new StringBuilder();
        if (runtimeInMinutes > 0L) {
            long min = runtimeInMinutes % 60L;
            long hrs = runtimeInMinutes / 60L;
            long days = hrs / 24L;
            hrs %= 24L;
            if (days > 0L) {
                sb.append(days).append("d ");
            }
            if (hrs < 10L) {
                sb.append(0);
            }
            sb.append(hrs).append(":");
            if (min < 10L) {
                sb.append(0);
            }
            sb.append(min);
        }
        return sb.toString();
    }

    static {
        TIME_FORMATTER.setTimeZone(TimeZone.getTimeZone("UTC"));
    }
}

