/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.engine;

import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.xlt.api.engine.Data;
import com.xceptance.xlt.api.util.XltCharBuffer;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractData
implements Data {
    private long time;
    private char typeCode;
    private String name;
    private String transactionName;
    private String agentName;

    public AbstractData(String name, char typeCode) {
        this.name = name;
        this.typeCode = typeCode;
    }

    public AbstractData(char typeCode) {
        this(null, typeCode);
    }

    public final void setAllValues(List<XltCharBuffer> values) {
        this.setBaseValues(values);
        this.setRemainingValues(values);
    }

    @Override
    public void setBaseValues(List<XltCharBuffer> values) {
        if (values.get(0).charAt(0) == this.typeCode) {
            this.name = values.get(1).toString();
            this.name.hashCode();
            this.time = ParseNumbers.parseLong(values.get(2));
            if (this.time <= 0L) {
                throw new IllegalArgumentException(String.format("Invalid time value: %d", this.time));
            }
        } else {
            throw new IllegalArgumentException("Cannot recreate the object state. The read type code '" + String.valueOf(values.get(0)) + "' does not match the expected type code '" + this.typeCode + "'.");
        }
    }

    @Override
    public String getAgentName() {
        return this.agentName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getTime() {
        return this.time;
    }

    @Override
    public String getTransactionName() {
        return this.transactionName;
    }

    @Override
    public char getTypeCode() {
        return this.typeCode;
    }

    @Override
    public void setAgentName(String agentName) {
        this.agentName = agentName;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setTime(long time) {
        this.time = time;
    }

    @Override
    public void setTransactionName(String transactionName) {
        this.transactionName = transactionName;
    }

    @Override
    public List<String> toList() {
        ArrayList<String> fields = new ArrayList<String>(20);
        fields.add(String.valueOf(this.typeCode));
        fields.add(this.name);
        fields.add(Long.toString(this.time));
        return fields;
    }
}

