/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.api.data;

import com.xceptance.xlt.api.util.XltRandom;
import java.util.LinkedList;

public class DataPool<T> {
    private volatile int max = 10;
    private volatile int expirationRate = 50;
    private final LinkedList<T> dataPool = new LinkedList();

    public DataPool(int max, int expirationRate) {
        this.max = Math.max(1, max);
        this.expirationRate = expirationRate;
    }

    public DataPool() {
    }

    public synchronized T getDataElement() {
        return this.dataPool.poll();
    }

    public synchronized boolean add(T element, int rate) {
        if (this.expirationRate == 100) {
            return false;
        }
        if (this.expirationRate == 0 || rate > this.expirationRate) {
            if (this.dataPool.size() >= this.max) {
                this.dataPool.poll();
            }
            this.dataPool.offer(element);
            return true;
        }
        return false;
    }

    public boolean add(T element) {
        return this.add(element, XltRandom.nextInt(100));
    }

    public int getExpireRate() {
        return this.expirationRate;
    }

    public void setExpireRate(int rate) {
        this.expirationRate = rate;
    }

    public int getMax() {
        return this.max;
    }

    public synchronized int getSize() {
        return this.dataPool.size();
    }

    public synchronized void setMax(int max) {
        this.max = Math.max(1, max);
        while (this.max < this.dataPool.size()) {
            this.dataPool.poll();
        }
    }

    public synchronized void clear() {
        this.dataPool.clear();
    }
}

