/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agentcontroller;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;

public class ResultArchives {
    private State state = State.CLEAN;
    private ArchiveToken archiveToken;
    private Map<String, File> archives = new HashMap<String, File>();

    public synchronized ArchiveToken requestCreating() {
        if (!this.state.equals((Object)State.IN_PROGRESS)) {
            this.clear();
            this.state = State.IN_PROGRESS;
            return this.archiveToken;
        }
        return null;
    }

    public synchronized boolean update(String agentID, File archiveFile, ArchiveToken archiveToken) {
        if (!this.validate(archiveToken)) {
            return false;
        }
        if (!this.state.equals((Object)State.IN_PROGRESS)) {
            throw new IllegalStateException("Update result archive map for state " + String.valueOf((Object)State.IN_PROGRESS) + " only.");
        }
        this.archives.put(agentID, archiveFile);
        return true;
    }

    public synchronized boolean setReadyForDownload(ArchiveToken archiveToken) {
        if (!this.validate(archiveToken)) {
            return false;
        }
        this.state = State.READY_FOR_DOWNLOAD;
        return true;
    }

    public synchronized State getState() {
        return this.state;
    }

    public synchronized Map<String, String> getArchives() {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this.state.equals((Object)State.READY_FOR_DOWNLOAD)) {
            for (Map.Entry<String, File> archive : this.archives.entrySet()) {
                map.put(archive.getKey(), archive.getValue().getName());
            }
        }
        return map;
    }

    public synchronized void clear() {
        for (File archiveFile : this.archives.values()) {
            FileUtils.deleteQuietly((File)archiveFile);
        }
        this.archives.clear();
        this.archiveToken = new ArchiveToken();
        this.state = State.CLEAN;
    }

    private boolean validate(ArchiveToken archiveToken) {
        if (this.archiveToken != null) {
            return this.archiveToken.equals(archiveToken);
        }
        return false;
    }

    public static enum State {
        CLEAN,
        IN_PROGRESS,
        READY_FOR_DOWNLOAD;

    }

    public static class ArchiveToken {
        private String tokenCode = UUID.randomUUID().toString();

        private ArchiveToken() {
        }

        public String toString() {
            return this.tokenCode;
        }

        public boolean equals(Object token) {
            if (token != null && token instanceof ArchiveToken) {
                return this.tokenCode.equals(((ArchiveToken)token).tokenCode);
            }
            return false;
        }

        public int hashCode() {
            return this.tokenCode.hashCode();
        }
    }
}

