/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.agent;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.api.util.XltProperties;
import com.xceptance.xlt.engine.XltExecutionContext;
import java.io.File;

public class AgentConfiguration
extends AbstractConfiguration {
    private static final String PROP_PREFIX = "com.xceptance.xlt.";
    private static final String PROP_MAX_ERRORS = "com.xceptance.xlt.maxErrors";
    private static final String PROP_USE_MASTER_CONTROLLER_TIME = "com.xceptance.xlt.useMasterControllerTime";
    private static final String PROP_RESULT_DIR = "com.xceptance.xlt.result-dir";
    private int maxErrors;
    private File resultsDirectory;
    private boolean useMasterControllerTime;

    public AgentConfiguration() {
        try {
            String agentHome = System.getProperty("com.xceptance.xlt.agent.home");
            File homeDirectory = new File(agentHome);
            XltExecutionContext.getCurrent().setTestSuiteHomeDir(homeDirectory);
            this.addProperties(XltProperties.getInstance().getProperties());
            this.maxErrors = this.getIntProperty(PROP_MAX_ERRORS, 1000);
            this.useMasterControllerTime = this.getBooleanProperty(PROP_USE_MASTER_CONTROLLER_TIME, true);
            String resultDir = this.getStringProperty(PROP_RESULT_DIR, "results");
            this.resultsDirectory = new File(resultDir);
            if (!this.resultsDirectory.isAbsolute()) {
                this.resultsDirectory = new File(homeDirectory, resultDir);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to read agent configuration", ex);
        }
    }

    public int getMaxErrors() {
        return this.maxErrors;
    }

    public File getResultsDirectory() {
        return this.resultsDirectory;
    }

    public boolean getUseMasterControllerTime() {
        return this.useMasterControllerTime;
    }
}

