/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public abstract class AbstractDomPrinter {
    private static final Logger log = LoggerFactory.getLogger(AbstractDomPrinter.class);
    protected final String defaultIndentation;
    protected final boolean prettyPrinting;

    public AbstractDomPrinter() {
        this(-1);
    }

    public AbstractDomPrinter(int spaces) {
        this.defaultIndentation = StringUtils.repeat((String)" ", (int)spaces);
        this.prettyPrinting = spaces >= 0;
    }

    public final String printNode(Node node) {
        StringWriter out = new StringWriter();
        this.printNode(node, out);
        return out.toString();
    }

    public final void printNode(Node node, OutputStream out) {
        try {
            this.printNode(node, new OutputStreamWriter(out, "UTF-8"));
        }
        catch (UnsupportedEncodingException uee) {
            log.warn("Failed to print node using 'UTF-8' encoding!");
        }
    }

    public void printNode(Node node, Writer out) {
        PrintWriter printWriter = new PrintWriter(out);
        this.printNode(node, "", printWriter);
        printWriter.flush();
    }

    protected void printAttributes(Element element, PrintWriter printWriter) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            printWriter.print(" " + StringEscapeUtils.escapeXml10((String)attribute.getName()) + "=\"" + StringEscapeUtils.escapeXml10((String)attribute.getValue()) + "\"");
        }
    }

    protected void printCDataSection(CDATASection cdataSection, String indentation, PrintWriter printWriter) {
        printWriter.print(indentation + "<![CDATA[" + cdataSection.getData() + "]]>");
        if (this.prettyPrinting) {
            printWriter.println();
        }
    }

    protected void printComment(Comment comment, String indentation, PrintWriter printWriter) {
        printWriter.print(indentation + "<!--" + comment.getData() + "-->");
        if (this.prettyPrinting) {
            printWriter.println();
        }
    }

    protected void printDocument(Document document, PrintWriter printWriter) {
        for (Node child = document.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.printNode(child, "", printWriter);
        }
    }

    protected void printDocumentFragment(DocumentFragment documentFragment, String indentation, PrintWriter printWriter) {
        for (Node child = documentFragment.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.printNode(child, indentation, printWriter);
        }
    }

    protected void printDocumentType(DocumentType documentType, PrintWriter printWriter) {
        printWriter.printf("<!DOCTYPE %s PUBLIC \"%s\" \"%s\">\n", documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
    }

    protected void printElement(Element element, String indentation, PrintWriter printWriter) {
        String tagName = element.getTagName();
        printWriter.print(indentation + "<" + tagName);
        this.printAttributes(element, printWriter);
        if (element.hasChildNodes()) {
            printWriter.print(">");
            if (this.prettyPrinting) {
                printWriter.println();
            }
            for (Node child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
                this.printNode(child, indentation + this.defaultIndentation, printWriter);
            }
            printWriter.print(indentation + "</" + tagName + ">");
        } else {
            this.printEmptyElementClosing(element, printWriter);
        }
        if (this.prettyPrinting) {
            printWriter.println();
        }
    }

    protected abstract void printEmptyElementClosing(Element var1, PrintWriter var2);

    protected void printNode(Node node, String indentation, PrintWriter printWriter) {
        short nodeType = node.getNodeType();
        switch (nodeType) {
            case 4: {
                this.printCDataSection((CDATASection)node, indentation, printWriter);
                break;
            }
            case 8: {
                this.printComment((Comment)node, indentation, printWriter);
                break;
            }
            case 11: {
                this.printDocumentFragment((DocumentFragment)node, indentation, printWriter);
                break;
            }
            case 9: {
                this.printDocument((Document)node, printWriter);
                break;
            }
            case 10: {
                this.printDocumentType((DocumentType)node, printWriter);
                break;
            }
            case 1: {
                this.printElement((Element)node, indentation, printWriter);
                break;
            }
            case 3: {
                this.printText((Text)node, indentation, printWriter);
                break;
            }
            default: {
                log.warn("Don't know how to print this node: " + String.valueOf(node.getClass()));
            }
        }
    }

    protected void printText(Text text, String indentation, PrintWriter printWriter) {
        String s = StringEscapeUtils.escapeXml10((String)text.getData());
        if (this.prettyPrinting) {
            if ((s = s.trim()).length() > 0) {
                printWriter.println(indentation + s);
            }
        } else {
            printWriter.print(s);
        }
    }
}

