/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.common.lang;

import com.xceptance.common.lang.Parameter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public final class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static boolean classHasOnlyPrivateConstructors(Class<?> theClass) {
        for (Constructor<?> c : theClass.getDeclaredConstructors()) {
            if (ReflectionUtils.isPrivate(c.getModifiers())) continue;
            return false;
        }
        return true;
    }

    public static <T> T readInstanceField(Object object, String fieldName) {
        return ReflectionUtils.readField(object.getClass(), object, fieldName);
    }

    public static <T> T readStaticField(Class<?> clazz, String fieldName) {
        return ReflectionUtils.readField(clazz, null, fieldName);
    }

    public static void writeInstanceField(Object object, String fieldName, Object value) {
        ReflectionUtils.writeField(object.getClass(), object, fieldName, value);
    }

    public static void writeStaticField(Class<?> clazz, String fieldName, Object value) {
        ReflectionUtils.writeField(clazz, null, fieldName, value);
    }

    public static <T> T getNewInstance(Class<T> classForWhichToReturnAnInstance, Object ... parameters) {
        boolean isParameterLess;
        Class[] parameterTypes = null;
        boolean bl = isParameterLess = parameters == null || parameters.length == 0;
        if (!isParameterLess) {
            parameterTypes = new Class[parameters.length];
            for (int i = 0; i < parameters.length; ++i) {
                Object o = parameters[i];
                parameterTypes[i] = o.getClass();
                if (!(o instanceof Parameter)) continue;
                Parameter p = (Parameter)o;
                parameterTypes[i] = p.getDeclaredParameterClass();
                parameters[i] = p.getValue();
            }
        }
        return ReflectionUtils.getNewInstance(classForWhichToReturnAnInstance, parameterTypes, isParameterLess, parameters);
    }

    private static <T> T getNewInstance(Class<T> classForWhichToReturnAnInstance, Class<?>[] parameterTypes, boolean isParameterLess, Object ... parameters) {
        String className = classForWhichToReturnAnInstance.getName();
        try {
            Constructor<T> constructor = isParameterLess ? classForWhichToReturnAnInstance.getDeclaredConstructor(new Class[0]) : classForWhichToReturnAnInstance.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return parameterTypes != null ? constructor.newInstance(parameters) : constructor.newInstance(new Object[0]);
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Constructor in \"" + className + "\"can not be accessed due to security restrictions!");
        }
        catch (NoSuchMethodException e) {
            String message = isParameterLess ? "Parameter less constructor from class \"" + className + "\" not in place!" : "Constructor from class \"" + className + "\" for parameter types " + Arrays.toString(parameterTypes) + " not in place!";
            e.printStackTrace();
            throw new IllegalStateException(message);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Wrong type or wrong argument type for constructor of class \"" + className + "\"!");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Constructor of class \"" + className + "\" can not be accessed this should never happen!");
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("Error instantiating class \"" + className + "\"!");
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Error instantiating class \"" + className + "\"!");
        }
    }

    public static void resetFieldToNull(Class<?> classWithFieldToReset, String fieldName) {
        try {
            Field instanceField = classWithFieldToReset.getDeclaredField(fieldName);
            instanceField.setAccessible(true);
            if (instanceField.getType().isPrimitive()) {
                ReflectionUtils.resetPrimitiveField(instanceField);
            } else {
                instanceField.set(null, null);
            }
        }
        catch (SecurityException e) {
            throw new IllegalStateException("Field \"" + fieldName + "\"can not be accessed due to security restrictions!");
        }
        catch (NoSuchFieldException e) {
            throw new IllegalStateException("Singleton instance field has been renamed! Expected it to have the name \"" + fieldName + "\"!");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Wrong type or wrong argument type for field with name \"" + fieldName + "\"!");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Field \"" + fieldName + "\"can not be accessed this should never happen!");
        }
    }

    public static Class<?> getNestedClass(Class<?> parent, String nestedClassName) {
        Class<?>[] classes;
        for (Class<?> c : classes = parent.getDeclaredClasses()) {
            if (!c.getName().endsWith(nestedClassName)) continue;
            return c;
        }
        throw new IllegalStateException("Class \"" + nestedClassName + "\" has been renamed or removed. Aborting test with error!");
    }

    public static Method getMethod(Class<?> declaringClass, String methodName, Class<?> ... parameterTypes) {
        String className = declaringClass.getName();
        try {
            return ReflectionUtils.getMethodWithFallback(declaringClass, methodName, parameterTypes);
        }
        catch (SecurityException e) {
            throw new SecurityException("Method \"" + methodName + "\" in class \"" + className + "\" can't be accessed! Aborting test with error!", e);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Method \"" + methodName + "\" not found in class \"" + className + "\"! Aborting test with error!", e);
        }
    }

    private static Method getMethodWithFallback(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws SecurityException, NoSuchMethodException {
        Method method;
        try {
            method = clazz.getDeclaredMethod(methodName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            method = clazz.getMethod(methodName, parameterTypes);
        }
        method.setAccessible(true);
        return method;
    }

    public static <T> T invokeMethod(Object o, Method m, Object ... args) {
        String className = o.getClass().getName();
        String name = m.getName();
        try {
            return (T)m.invoke(o, args);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Method \"" + name + "\" of \"" + className + "\" was not accessible! Aborting test with error!", e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException("Exception occurred when invoking \"" + name + "\" from \"" + className + "\"! Aborting test with error!", e);
        }
    }

    public static <T> T readField(Class<?> clazz, Object object, String fieldName) {
        try {
            return (T)ReflectionUtils.getFieldAndMakeAccessible(clazz, fieldName).get(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lookup/read field: " + fieldName, e);
        }
    }

    public static void resetPrimitiveField(Field fieldToSet) throws IllegalArgumentException, IllegalAccessException {
        Class<?> type = fieldToSet.getType();
        if (type == Boolean.TYPE) {
            fieldToSet.set(null, Boolean.FALSE);
            return;
        }
        if (type == Byte.TYPE) {
            fieldToSet.set(null, (byte)0);
            return;
        }
        if (type == Character.TYPE) {
            fieldToSet.set(null, Character.valueOf('\u0000'));
            return;
        }
        if (type == Double.TYPE) {
            fieldToSet.set(null, 0.0);
            return;
        }
        if (type == Float.TYPE) {
            fieldToSet.set(null, Float.valueOf(0.0f));
            return;
        }
        if (type == Integer.TYPE) {
            fieldToSet.set(null, 0);
            return;
        }
        if (type == Long.TYPE) {
            fieldToSet.set(null, 0L);
            return;
        }
        if (type == Short.TYPE) {
            fieldToSet.set(null, (short)0);
            return;
        }
        throw new IllegalArgumentException("Illegal attempt to assign a void field! This should never happen cause you can not define a member of type \"void\"!");
    }

    public static void writeField(Class<?> clazz, Object object, String fieldName, Object value) {
        try {
            Field field = ReflectionUtils.getFieldAndMakeAccessible(clazz, fieldName);
            field.set(object, value);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lookup/write field: " + fieldName, e);
        }
    }

    private static Field getFieldAndMakeAccessible(Class<?> clazz, String fieldName) throws SecurityException, NoSuchFieldException {
        Field field = null;
        while (clazz != null && clazz != Object.class) {
            try {
                field = clazz.getDeclaredField(fieldName);
                break;
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        if (field == null) {
            throw new NoSuchFieldException(fieldName);
        }
        field.setAccessible(true);
        return field;
    }

    public static Field getField(Class<?> clazz, String fieldName) throws SecurityException, NoSuchFieldException {
        Field field;
        try {
            field = clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            field = clazz.getField(fieldName);
        }
        return field;
    }

    public static <T> T callStaticMethod(Class<?> clazz, String methodName, Object ... args) {
        return (T)ReflectionUtils.callMethod(clazz, null, methodName, args);
    }

    public static Object callMethod(Class<?> clazz, Object object, String methodName, Object ... args) {
        Class[] parameterTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            parameterTypes[i] = args[i].getClass();
        }
        try {
            return ReflectionUtils.getMethodWithFallback(clazz, methodName, parameterTypes).invoke(object, args);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to lookup/call method: " + methodName, e);
        }
    }

    public static Object callMethod(Object object, String methodName, Object ... args) {
        return ReflectionUtils.callMethod(object.getClass(), object, methodName, args);
    }

    private static boolean isPrivate(int modifiers) {
        return Modifier.isPrivate(modifiers);
    }
}

