/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.html;

import org.apache.commons.lang3.ArrayUtils;
import org.htmlunit.html.HtmlParagraph;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.JsxSetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.html.HTMLElement;

@JsxClass(domClass=HtmlParagraph.class)
public class HTMLParagraphElement
extends HTMLElement {
    private static final String[] VALID_CLEAR_VALUES = new String[]{"left", "right", "all", "none"};

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
        super.jsConstructor();
    }

    @JsxGetter
    public String getAlign() {
        return this.getAlign(true);
    }

    @JsxSetter
    public void setAlign(String align) {
        this.setAlign(align, false);
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public String getClear() {
        String clear = this.getDomNodeOrDie().getAttributeDirect("clear");
        if (!ArrayUtils.contains((Object[])VALID_CLEAR_VALUES, (Object)clear)) {
            return "";
        }
        return clear;
    }

    @JsxSetter(value={SupportedBrowser.IE})
    public void setClear(String clear) {
        if (!ArrayUtils.contains((Object[])VALID_CLEAR_VALUES, (Object)clear)) {
            throw JavaScriptEngine.reportRuntimeError("Invalid clear property value: '" + clear + "'.");
        }
        this.getDomNodeOrDie().setAttribute("clear", clear);
    }
}

