/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.javascript.host.dom;

import java.util.Arrays;
import java.util.HashSet;
import org.apache.commons.lang3.StringUtils;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.corejs.javascript.Undefined;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomElement;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxConstructor;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.htmlunit.javascript.host.dom.Node;

@JsxClass
public class DOMTokenList
extends HtmlUnitScriptable {
    private static final String WHITESPACE_CHARS = " \t\r\n\f";
    private static final String WHITESPACE_CHARS_IE_11 = " \t\r\n\f\u000b";
    private String attributeName_;

    public DOMTokenList() {
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public void jsConstructor() {
    }

    public DOMTokenList(Node node, String attributeName) {
        this.setDomNode(node.getDomNodeOrDie(), false);
        this.setParentScope(node.getParentScope());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributeName_ = attributeName;
    }

    @JsxGetter
    public int getLength() {
        String value = this.getAttribValue();
        if (StringUtils.isBlank((CharSequence)value)) {
            return 0;
        }
        String[] parts = StringUtils.split((String)value, (String)this.whitespaceChars());
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_LENGTH_IGNORES_DUPLICATES)) {
            HashSet<String> elements = new HashSet<String>(parts.length);
            elements.addAll(Arrays.asList(parts));
            return elements.size();
        }
        return parts.length;
    }

    private String getAttribValue() {
        DomAttr attr;
        DomNode node = this.getDomNodeOrNull();
        if (node != null && (attr = (DomAttr)node.getAttributes().getNamedItem(this.attributeName_)) != null) {
            return attr.getValue();
        }
        return null;
    }

    @Override
    public String getDefaultValue(Class<?> hint) {
        if (this.getPrototype() == null) {
            return (String)super.getDefaultValue(hint);
        }
        String value = this.getAttribValue();
        if (value != null) {
            return String.join((CharSequence)" ", StringUtils.split((String)value, (String)this.whitespaceChars()));
        }
        return "";
    }

    @JsxFunction
    public void add(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)this.whitespaceChars())) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        boolean changed = false;
        Object value = this.getAttribValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = token;
            changed = true;
        } else if (this.position((String)(value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)this.whitespaceChars()))), token) < 0) {
            if (((String)value).length() != 0 && !this.isWhitespace(((String)value).charAt(((String)value).length() - 1))) {
                value = (String)value + " ";
            }
            value = (String)value + token;
            changed = true;
        } else if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_REMOVE_WHITESPACE_CHARS_ON_ADD)) {
            value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)this.whitespaceChars()));
            changed = true;
        }
        if (changed) {
            this.updateAttribute((String)value);
        }
    }

    @JsxFunction
    public void remove(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)this.whitespaceChars())) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        String oldValue = this.getAttribValue();
        if (oldValue == null) {
            return;
        }
        String value = String.join((CharSequence)" ", StringUtils.split((String)oldValue, (String)this.whitespaceChars()));
        boolean changed = false;
        int pos = this.position(value, token);
        while (pos != -1) {
            int from;
            int to = pos + token.length();
            for (from = pos; from > 0 && this.isWhitespace(value.charAt(from - 1)); --from) {
            }
            while (to < value.length() - 1 && this.isWhitespace(value.charAt(to))) {
                ++to;
            }
            StringBuilder result = new StringBuilder();
            if (from > 0) {
                result.append(value, 0, from);
                if (to < value.length()) {
                    result.append(' ');
                }
            }
            result.append(value, to, value.length());
            value = result.toString();
            changed = true;
            pos = this.position(value, token);
        }
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_REMOVE_WHITESPACE_CHARS_ON_REMOVE)) {
            value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)this.whitespaceChars()));
            changed = true;
        }
        if (changed) {
            this.updateAttribute(value);
        }
    }

    @JsxFunction
    public boolean toggle(String token) {
        if (this.contains(token)) {
            this.remove(token);
            return false;
        }
        this.add(token);
        return true;
    }

    @JsxFunction
    public boolean contains(String token) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_CONTAINS_RETURNS_FALSE_FOR_BLANK) && StringUtils.isBlank((CharSequence)token)) {
            return false;
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        if (StringUtils.containsAny((CharSequence)token, (CharSequence)this.whitespaceChars())) {
            throw JavaScriptEngine.reportRuntimeError("Empty input not allowed");
        }
        String value = this.getAttribValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return this.position(value = String.join((CharSequence)" ", StringUtils.split((String)value, (String)this.whitespaceChars())), token) > -1;
    }

    @JsxFunction
    public Object item(int index) {
        if (index < 0) {
            return null;
        }
        String value = this.getAttribValue();
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        String[] values = StringUtils.split((String)value, (String)this.whitespaceChars());
        if (index < values.length) {
            return values[index];
        }
        return null;
    }

    public Object get(int index, Scriptable start) {
        Object value = this.item(index);
        if (value == null && !this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_GET_NULL_IF_OUTSIDE)) {
            return Undefined.instance;
        }
        return value;
    }

    private void updateAttribute(String value) {
        DomElement domNode = (DomElement)this.getDomNodeOrDie();
        DomAttr attr = domNode.getPage().createAttribute(this.attributeName_);
        attr.setValue(value);
        domNode.setAttributeNode(attr);
    }

    private int position(String value, String token) {
        int pos = value.indexOf(token);
        if (pos < 0) {
            return -1;
        }
        if (pos != 0 && !this.isWhitespace(value.charAt(pos - 1))) {
            return -1;
        }
        int end = pos + token.length();
        if (end != value.length() && !this.isWhitespace(value.charAt(end))) {
            return -1;
        }
        return pos;
    }

    private String whitespaceChars() {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_DOMTOKENLIST_ENHANCED_WHITESPACE_CHARS)) {
            return WHITESPACE_CHARS_IE_11;
        }
        return WHITESPACE_CHARS;
    }

    private boolean isWhitespace(int ch) {
        return this.whitespaceChars().indexOf(ch) > -1;
    }
}

