/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.html;

import java.util.Map;
import org.htmlunit.BrowserVersionFeatures;
import org.htmlunit.Page;
import org.htmlunit.SgmlPage;
import org.htmlunit.html.DoTypeProcessor;
import org.htmlunit.html.DomAttr;
import org.htmlunit.html.DomNode;
import org.htmlunit.html.HtmlElement;
import org.htmlunit.html.HtmlInput;
import org.htmlunit.html.impl.SelectableTextInput;
import org.htmlunit.html.impl.SelectableTextSelectionDelegate;
import org.htmlunit.html.impl.SelectionDelegate;

public abstract class HtmlSelectableTextInput
extends HtmlInput
implements SelectableTextInput {
    private SelectableTextSelectionDelegate selectionDelegate_ = new SelectableTextSelectionDelegate(this);
    private DoTypeProcessor doTypeProcessor_ = new DoTypeProcessor(this);

    HtmlSelectableTextInput(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
    }

    @Override
    public void setValue(String newValue) {
        super.setValue(newValue);
        Page page = this.getPage();
        if (page != null && ((SgmlPage)page).isHtmlPage()) {
            int pos = 0;
            if (!this.hasFeature(BrowserVersionFeatures.JS_INPUT_SET_VALUE_MOVE_SELECTION_TO_START)) {
                pos = newValue.length();
            }
            this.setSelectionStart(pos);
            this.setSelectionEnd(pos);
        }
    }

    @Override
    protected void doType(char c, boolean lastType) {
        this.doTypeProcessor_.doType(this.getRawValue(), (SelectionDelegate)this.selectionDelegate_, c, (HtmlElement)this, lastType);
    }

    @Override
    protected void doType(int keyCode, boolean lastType) {
        this.doTypeProcessor_.doType(this.getRawValue(), (SelectionDelegate)this.selectionDelegate_, keyCode, (HtmlElement)this, lastType);
    }

    @Override
    protected void typeDone(String newValue, boolean notifyAttributeChangeListeners) {
        if (!this.isMinMaxLengthSupported() || newValue.length() <= this.getMaxLength()) {
            this.setRawValue(newValue);
            this.markValueDirty();
        }
    }

    @Override
    public void setText(String text) {
        this.setValue(text);
    }

    @Override
    public String getText() {
        return this.getRawValue();
    }

    @Override
    public void select() {
        this.selectionDelegate_.select();
    }

    @Override
    public String getSelectedText() {
        return this.selectionDelegate_.getSelectedText();
    }

    @Override
    public int getSelectionStart() {
        return this.selectionDelegate_.getSelectionStart();
    }

    @Override
    public void setSelectionStart(int selectionStart) {
        this.selectionDelegate_.setSelectionStart(selectionStart);
    }

    @Override
    public int getSelectionEnd() {
        return this.selectionDelegate_.getSelectionEnd();
    }

    @Override
    public void setSelectionEnd(int selectionEnd) {
        this.selectionDelegate_.setSelectionEnd(selectionEnd);
    }

    @Override
    public void reset() {
        super.reset();
        this.setSelectionEnd(0);
    }

    @Override
    public DomNode cloneNode(boolean deep) {
        HtmlSelectableTextInput newNode = (HtmlSelectableTextInput)super.cloneNode(deep);
        newNode.selectionDelegate_ = new SelectableTextSelectionDelegate(newNode);
        newNode.doTypeProcessor_ = new DoTypeProcessor(newNode);
        return newNode;
    }
}

