/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.activex.javascript.msxml;

import org.htmlunit.activex.javascript.msxml.MSXMLScriptable;
import org.htmlunit.activex.javascript.msxml.XMLDOMNode;
import org.htmlunit.corejs.javascript.Scriptable;
import org.htmlunit.html.DomNode;
import org.htmlunit.javascript.HtmlUnitScriptable;
import org.htmlunit.javascript.JavaScriptEngine;
import org.htmlunit.javascript.configuration.JsxClass;
import org.htmlunit.javascript.configuration.JsxFunction;
import org.htmlunit.javascript.configuration.JsxGetter;
import org.htmlunit.javascript.configuration.SupportedBrowser;
import org.w3c.dom.NamedNodeMap;

@JsxClass(value={SupportedBrowser.IE})
public class XMLDOMNamedNodeMap
extends MSXMLScriptable {
    private final NamedNodeMap attributes_;
    private int currentIndex_;

    public XMLDOMNamedNodeMap() {
        this.attributes_ = null;
    }

    public XMLDOMNamedNodeMap(DomNode node) {
        this.setParentScope((Scriptable)node.getScriptableObject());
        this.setPrototype(this.getPrototype(this.getClass()));
        this.attributes_ = node.getAttributes();
        this.setDomNode(node, false);
    }

    public final Object get(int index, Scriptable start) {
        XMLDOMNamedNodeMap startMap = (XMLDOMNamedNodeMap)start;
        HtmlUnitScriptable response = startMap.item(index);
        if (response != null) {
            return response;
        }
        return NOT_FOUND;
    }

    @JsxGetter
    public int getLength() {
        return this.attributes_.getLength();
    }

    public HtmlUnitScriptable getNamedItemWithoutSyntheticClassAttr(String name) {
        DomNode attr;
        if (this.attributes_ != null && (attr = (DomNode)this.attributes_.getNamedItem(name)) != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Object getNamedItem(String name) {
        if (name == null || "null".equals(name)) {
            throw JavaScriptEngine.reportRuntimeError("Type mismatch.");
        }
        return this.getNamedItemWithoutSyntheticClassAttr(name);
    }

    @JsxFunction
    public HtmlUnitScriptable item(int index) {
        DomNode attr = (DomNode)this.attributes_.item(index);
        if (attr != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public Object nextNode() {
        return this.item(this.currentIndex_++);
    }

    @JsxFunction
    public HtmlUnitScriptable removeNamedItem(String name) {
        if (name == null || "null".equals(name)) {
            throw JavaScriptEngine.reportRuntimeError("Type mismatch.");
        }
        DomNode attr = (DomNode)this.attributes_.removeNamedItem(name);
        if (attr != null) {
            return attr.getScriptableObject();
        }
        return null;
    }

    @JsxFunction
    public void reset() {
        this.currentIndex_ = 0;
    }

    @JsxFunction
    public Object setNamedItem(XMLDOMNode node) {
        if (node == null) {
            throw JavaScriptEngine.reportRuntimeError("Type mismatch.");
        }
        this.attributes_.setNamedItem(node.getDomNodeOrDie());
        return node;
    }
}

