/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.common.util.ParameterCheckUtils;
import com.xceptance.xlt.report.util.lucene.OpenBitSet;

public class IntLowPrecisionValueSet {
    private static int DEFAULT_BUCKET_COUNT = 256;
    private final OpenBitSet bitSet;
    private final int buckets;
    private int scale;

    public static void setDefaultBucketCount(int buckets) {
        ParameterCheckUtils.isNotNegative(buckets, "buckets");
        DEFAULT_BUCKET_COUNT = buckets;
    }

    public IntLowPrecisionValueSet() {
        this(DEFAULT_BUCKET_COUNT);
    }

    public IntLowPrecisionValueSet(int buckets) {
        this.buckets = buckets;
        this.scale = 0;
        this.bitSet = new OpenBitSet(this.buckets);
    }

    public void addValue(int value) {
        if (value < 0) {
            return;
        }
        value >>= this.scale;
        while (value >= this.buckets) {
            this.scale();
            value >>= 1;
        }
        this.bitSet.set(value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntLowPrecisionValueSet other = (IntLowPrecisionValueSet)obj;
        if (this.bitSet == null ? other.bitSet != null : !this.bitSet.equals(other.bitSet)) {
            return false;
        }
        if (this.scale != other.scale) {
            return false;
        }
        return this.buckets == other.buckets;
    }

    public double[] getValues() {
        double[] values = new double[(int)this.bitSet.cardinality()];
        int x = 0;
        for (int i = 0; i < values.length; ++i) {
            int v = this.bitSet.nextSetBit(x);
            values[i] = v << this.scale;
            x = v + 1;
        }
        return values;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.bitSet == null ? 0 : this.bitSet.hashCode());
        result = 31 * result + this.scale;
        result = 31 * result + this.buckets;
        return result;
    }

    public void merge(IntLowPrecisionValueSet other) {
        if (this.scale != other.scale) {
            int targetScale;
            IntLowPrecisionValueSet toBeScaled;
            if (this.scale < other.scale) {
                toBeScaled = this;
                targetScale = other.scale;
            } else {
                toBeScaled = other;
                targetScale = this.scale;
            }
            while (toBeScaled.scale < targetScale) {
                toBeScaled.scale();
            }
        }
        this.bitSet.or(other.bitSet);
    }

    private void scale() {
        ++this.scale;
        for (int i = 0; i < this.buckets; i += 2) {
            boolean bitValue;
            int bitIndex = i >> 1;
            boolean bl = bitValue = this.bitSet.get(i) || this.bitSet.get(i + 1);
            if (bitValue) {
                this.bitSet.set(bitIndex);
                continue;
            }
            this.bitSet.clear(bitIndex);
        }
        this.bitSet.clear(this.buckets >> 1, this.buckets);
    }
}

