/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

import com.xceptance.xlt.report.util.AbstractFixedSizeDoubleValueSet;
import com.xceptance.xlt.report.util.lucene.OpenBitSet;
import org.apache.commons.lang3.ArrayUtils;

public class DoubleLowPrecisionValueSet
extends AbstractFixedSizeDoubleValueSet {
    static int DEFAULT_BUCKET_COUNT = 128;
    private final OpenBitSet bitSet;

    public static void setDefaultBucketCount(int numberOfBuckets) {
        DEFAULT_BUCKET_COUNT = numberOfBuckets;
    }

    public DoubleLowPrecisionValueSet() {
        this(DEFAULT_BUCKET_COUNT);
    }

    public DoubleLowPrecisionValueSet(int numberOfBuckets) {
        super(numberOfBuckets);
        this.bitSet = new OpenBitSet(numberOfBuckets);
    }

    @Override
    protected void scale() {
        int numberOfBuckets = this.getNumberOfBuckets();
        int i = 0;
        int j = 0;
        while (i < numberOfBuckets) {
            boolean bitValue = this.bitSet.get(i) || this.bitSet.get(i + 1);
            this.bitSet.set(j, bitValue);
            i += 2;
            ++j;
        }
        this.bitSet.clear(numberOfBuckets / 2, numberOfBuckets);
    }

    @Override
    protected void shift(int buckets) {
        int numberOfBuckets = this.getNumberOfBuckets();
        for (int i = numberOfBuckets - 1; i >= 0; --i) {
            if (i >= buckets) {
                this.bitSet.set(i, this.bitSet.get(i - buckets));
                continue;
            }
            this.bitSet.clear(i);
        }
    }

    @Override
    protected void storeValue(int index, double value) {
        this.bitSet.set(index);
    }

    public double[] getValues() {
        double[] values;
        double bucketWidth = this.getBucketWidth();
        double min = this.getMinimum();
        if (Double.isNaN(min)) {
            values = ArrayUtils.EMPTY_DOUBLE_ARRAY;
        } else {
            int size = (int)this.bitSet.cardinality();
            values = new double[size];
            int j = this.bitSet.nextSetBit(0);
            for (int i = 0; i < size; ++i) {
                values[i] = min + bucketWidth * (double)j;
                j = this.bitSet.nextSetBit(j + 1);
            }
        }
        return values;
    }

    public void merge(DoubleLowPrecisionValueSet other) {
        for (double value : other.getValues()) {
            this.addValue(value);
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.bitSet == null ? 0 : this.bitSet.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleLowPrecisionValueSet other = (DoubleLowPrecisionValueSet)obj;
        return !(this.bitSet == null ? other.bitSet != null : !this.bitSet.equals(other.bitSet));
    }
}

