/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.util;

public abstract class AbstractFixedSizeDoubleValueSet {
    static double INITIAL_BUCKET_WIDTH = Math.pow(2.0, -13.0);
    private final int numberOfBuckets;
    private double bucketWidth = INITIAL_BUCKET_WIDTH;
    private double min = Double.NaN;
    private double max = Double.MIN_VALUE;

    public AbstractFixedSizeDoubleValueSet(int numberOfBuckets) {
        if (numberOfBuckets <= 0 || numberOfBuckets % 2 != 0) {
            throw new IllegalArgumentException("Parameter 'numberOfBuckets' must be greater than 0 and be a multiple of 2");
        }
        this.numberOfBuckets = numberOfBuckets;
    }

    public int getNumberOfBuckets() {
        return this.numberOfBuckets;
    }

    public double getBucketWidth() {
        return this.bucketWidth;
    }

    public double getMinimum() {
        return this.min;
    }

    public void addValue(double value) {
        if (Double.isNaN(this.min)) {
            this.min = value;
        } else {
            this.adjustRange(value);
        }
        double diff = Math.max(0.0, value - this.min);
        int index = (int)Math.floor(diff / this.bucketWidth);
        this.max = Math.max(this.max, this.min + this.bucketWidth * (double)(index + 1));
        this.storeValue(index, value);
    }

    private void adjustRange(double value) {
        while (value >= this.min + this.bucketWidth * (double)this.numberOfBuckets || value < this.max - this.bucketWidth * (double)this.numberOfBuckets) {
            this.bucketWidth *= 2.0;
            this.scale();
        }
        if (value < this.min) {
            double diff = Math.max(0.0, this.min - value);
            int buckets = (int)Math.ceil(diff / this.bucketWidth);
            this.min -= this.bucketWidth * (double)buckets;
            this.shift(buckets);
        }
    }

    protected abstract void scale();

    protected abstract void shift(int var1);

    protected abstract void storeValue(int var1, double var2);

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.bucketWidth);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.min);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.numberOfBuckets;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractFixedSizeDoubleValueSet other = (AbstractFixedSizeDoubleValueSet)obj;
        if (Double.doubleToLongBits(this.bucketWidth) != Double.doubleToLongBits(other.bucketWidth)) {
            return false;
        }
        if (Double.doubleToLongBits(this.max) != Double.doubleToLongBits(other.max)) {
            return false;
        }
        if (Double.doubleToLongBits(this.min) != Double.doubleToLongBits(other.min)) {
            return false;
        }
        return this.numberOfBuckets == other.numberOfBuckets;
    }
}

