/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.trendreport;

import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.engine.XltExecutionContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class TrendReportGeneratorConfiguration
extends AbstractConfiguration {
    private static final String PROP_PREFIX = "com.xceptance.xlt.trendreportgenerator.";
    private static final String PROP_CHARTS_PREFIX = "com.xceptance.xlt.trendreportgenerator.charts.";
    private static final String PROP_CHARTS_HEIGHT = "com.xceptance.xlt.trendreportgenerator.charts.height";
    private static final String PROP_CHARTS_WIDTH = "com.xceptance.xlt.trendreportgenerator.charts.width";
    private static final String PROP_CHARTS_AUTO_RANGE_INCLUDES_ZERO = "com.xceptance.xlt.trendreportgenerator.charts.autoRangeIncludesZero";
    private static final String PROP_REPORTS_ROOT_DIR = "com.xceptance.xlt.trendreportgenerator.reports";
    private static final String PROP_THREAD_COUNT = "com.xceptance.xlt.trendreportgenerator.threads";
    private static final String PROP_TRANSFORMATIONS_PREFIX = "com.xceptance.xlt.trendreportgenerator.transformations.";
    private static final String PROP_TRANSFORMATIONS_STYLE_SHEET_FILE_SUFFIX = ".styleSheetFileName";
    private static final String PROP_TRANSFORMATIONS_OUTPUT_FILE_SUFFIX = ".outputFileName";
    private final int chartsHeight;
    private final int chartsWidth;
    private final boolean chartsAutoRangeIncludesZero;
    private final File configDirectory;
    private final File homeDirectory = XltExecutionContext.getCurrent().getXltHomeDir();
    private final File reportsRootDirectory;
    private final List<String> styleSheetFileNames;
    private final List<String> outputFileNames;
    private final int threadCount;

    public TrendReportGeneratorConfiguration() throws IOException {
        this.configDirectory = XltExecutionContext.getCurrent().getXltConfigDir();
        this.loadProperties(new File(this.configDirectory, "trendreportgenerator.properties"));
        File reportsRootDir = this.getFileProperty(PROP_REPORTS_ROOT_DIR, new File(this.homeDirectory, "reports"));
        if (!reportsRootDir.isAbsolute()) {
            reportsRootDir = new File(this.homeDirectory, reportsRootDir.getPath());
        }
        this.reportsRootDirectory = reportsRootDir;
        this.chartsWidth = this.getIntProperty(PROP_CHARTS_WIDTH, 600);
        this.chartsHeight = this.getIntProperty(PROP_CHARTS_HEIGHT, 300);
        this.chartsAutoRangeIncludesZero = this.getBooleanProperty(PROP_CHARTS_AUTO_RANGE_INCLUDES_ZERO, false);
        this.threadCount = this.getIntProperty(PROP_THREAD_COUNT, -1);
        this.outputFileNames = new ArrayList<String>();
        this.styleSheetFileNames = new ArrayList<String>();
        this.readTransformations(this.outputFileNames, this.styleSheetFileNames);
    }

    public int getChartHeight() {
        return this.chartsHeight;
    }

    public int getChartWidth() {
        return this.chartsWidth;
    }

    public boolean getChartAutoRangeIncludesZero() {
        return this.chartsAutoRangeIncludesZero;
    }

    public File getConfigDirectory() {
        return this.configDirectory;
    }

    public File getHomeDirectory() {
        return this.homeDirectory;
    }

    public File getReportsRootDirectory() {
        return this.reportsRootDirectory;
    }

    public List<String> getOutputFileNames() {
        return this.outputFileNames;
    }

    public List<String> getStyleSheetFileNames() {
        return this.styleSheetFileNames;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    private void readTransformations(List<String> outputFileNames, List<String> styleSheetFileNames) {
        Set<String> keys = this.getPropertyKeyFragment(PROP_TRANSFORMATIONS_PREFIX);
        for (String key : keys) {
            String propertyPrefix = PROP_TRANSFORMATIONS_PREFIX + key;
            File outputFile = this.getFileProperty(propertyPrefix + PROP_TRANSFORMATIONS_OUTPUT_FILE_SUFFIX);
            File styleSheetFile = this.getFileProperty(propertyPrefix + PROP_TRANSFORMATIONS_STYLE_SHEET_FILE_SUFFIX);
            outputFileNames.add(outputFile.getPath());
            styleSheetFileNames.add(styleSheetFile.getPath());
        }
    }
}

