/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.scorecard;

import com.xceptance.common.util.Console;
import com.xceptance.xlt.api.util.XltLogger;
import com.xceptance.xlt.engine.XltEngine;
import com.xceptance.xlt.engine.XltExecutionContext;
import com.xceptance.xlt.report.ReportGenerator;
import com.xceptance.xlt.util.Timer;
import java.io.File;
import java.util.Locale;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.vfs2.VFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UpdateMain {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateMain.class);
    private final Options options = UpdateMain.createCommandLineOptions();
    private File inputDir;
    private File outputDir;

    public static void main(String[] args) throws Throwable {
        String errorMessage;
        Locale.setDefault(Locale.US);
        XltLogger.reportLogger.info(Console.horizontalBar());
        XltLogger.reportLogger.info(Console.startSection("XLT Scorecard Update"));
        XltLogger.reportLogger.info(Console.endSection());
        UpdateMain main = new UpdateMain();
        try {
            main.init(args);
        }
        catch (Exception e) {
            errorMessage = "Failed to initialize report generator";
            System.err.println("Failed to initialize report generator: " + e.getMessage());
            LOG.error("Failed to initialize report generator", (Throwable)e);
            main.printUsage();
            System.exit(2);
        }
        try {
            main.run();
            System.exit(0);
        }
        catch (Exception e) {
            errorMessage = "Failed to update scorecard";
            System.err.println("Failed to update scorecard: " + e.getMessage());
            LOG.error("Failed to update scorecard", (Throwable)e);
            System.exit(1);
        }
    }

    private UpdateMain() {
    }

    private void init(String[] arguments) throws ParseException {
        String[] remainingArguments;
        XltLogger.reportLogger.info(Console.horizontalBar());
        XltLogger.reportLogger.info(Console.startSection("Initializing..."));
        Timer timer = Timer.start();
        XltEngine.get();
        CommandLine cmdLine = new DefaultParser().parse(this.options, arguments);
        String outputDirName = cmdLine.getOptionValue("o");
        if (outputDirName != null) {
            this.outputDir = new File(outputDirName);
        }
        if ((remainingArguments = cmdLine.getArgs()).length != 1) {
            throw new IllegalArgumentException("Please specify a single report directory");
        }
        this.inputDir = new File(remainingArguments[0]);
        XltExecutionContext.getCurrent().setTestSuiteHomeDir(this.inputDir);
        XltExecutionContext.getCurrent().setTestSuiteConfigDir(new File(this.inputDir, "config"));
        XltLogger.reportLogger.info(timer.stop().get("...finished"));
        XltLogger.reportLogger.info(Console.endSection());
    }

    private void run() throws Exception {
        XltLogger.reportLogger.info(Console.horizontalBar());
        XltLogger.reportLogger.info(Console.startSection("Setup..."));
        Timer timer = Timer.start();
        ReportGenerator reportGenerator = new ReportGenerator(VFS.getManager().resolveFile(this.inputDir.toURI()), this.outputDir, true);
        XltLogger.reportLogger.info(timer.stop().get("...finished"));
        XltLogger.reportLogger.info(Console.endSection());
        reportGenerator.updateScorecard();
    }

    private void printUsage() {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setSyntaxPrefix("Usage: ");
        helpFormatter.setWidth(79);
        System.out.println();
        helpFormatter.printHelp("update_scorecard (<options>) reportdir", "Updates the scorecard of the given report\n\nOptions:\n", this.options, null);
        System.out.println();
    }

    private static Options createCommandLineOptions() {
        Options opts = new Options();
        Option targetDir = new Option("o", true, "the output directory");
        targetDir.setArgName("dir");
        opts.addOption(targetDir);
        return opts;
    }
}

