/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.report.scorecard;

import com.thoughtworks.xstream.annotations.XStreamAlias;
import com.thoughtworks.xstream.annotations.XStreamAsAttribute;
import com.thoughtworks.xstream.annotations.XStreamConverter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.converters.collections.AbstractCollectionConverter;
import com.thoughtworks.xstream.converters.enums.EnumToStringConverter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.mapper.Mapper;
import com.xceptance.xlt.report.scorecard.TestFailTrigger;
import com.xceptance.xlt.report.scorecard.ValidationException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

@XStreamAlias(value="group")
public class GroupDefinition {
    @XStreamAsAttribute
    private final String id;
    @XStreamAsAttribute
    private final String name;
    private String description;
    @XStreamAlias(value="rules")
    @XStreamConverter(value=RuleIdConverter.class)
    private final List<String> ruleIds;
    @XStreamAsAttribute
    private boolean enabled;
    @XStreamAsAttribute
    private boolean failsTest;
    @XStreamAsAttribute
    private TestFailTrigger failsOn;
    @XStreamAsAttribute
    @XStreamConverter(value=EnumToStringConverter.class)
    private Mode mode;
    private String successMessage;
    private String failMessage;

    public GroupDefinition(String id, String name, List<String> ruleIds) {
        this.id = Objects.requireNonNull(id, "Group ID must not be null");
        this.name = name;
        this.ruleIds = ruleIds;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Mode getMode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    public String getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<String> getRuleIds() {
        return Collections.unmodifiableList(this.ruleIds);
    }

    public String getSuccessMessage() {
        return this.successMessage;
    }

    public void setSuccessMessage(String successMessage) {
        this.successMessage = successMessage;
    }

    public String getFailMessage() {
        return this.failMessage;
    }

    public void setFailMessage(String failMessage) {
        this.failMessage = failMessage;
    }

    public boolean isFailsTest() {
        return this.failsTest;
    }

    public void setFailsTest(boolean failsTest) {
        this.failsTest = failsTest;
    }

    public TestFailTrigger getFailsOn() {
        return this.failsOn;
    }

    public void setFailsOn(TestFailTrigger failsOn) {
        this.failsOn = failsOn;
    }

    public static GroupDefinition fromJSON(JSONObject jsonObject) throws ValidationException {
        String id = jsonObject.getString("id");
        String name = StringUtils.trimToNull((String)jsonObject.optString("name"));
        String description = jsonObject.optString("description", null);
        JSONArray ruleArr = jsonObject.getJSONArray("rules");
        boolean enabled = jsonObject.optBoolean("enabled", true);
        boolean failsTest = jsonObject.optBoolean("failsTest", false);
        String modeStr = StringUtils.trimToNull((String)jsonObject.optString("mode"));
        String failsOnStr = StringUtils.trimToNull((String)jsonObject.optString("failsOn"));
        Mode source = (Mode)EnumUtils.getEnumIgnoreCase(Mode.class, (String)modeStr, (Enum)Mode.firstPassed);
        TestFailTrigger failsOn = (TestFailTrigger)EnumUtils.getEnumIgnoreCase(TestFailTrigger.class, (String)failsOnStr);
        JSONObject messageObj = jsonObject.optJSONObject("messages");
        String successMessage = messageObj != null ? StringUtils.trimToNull((String)messageObj.optString("success")) : null;
        String failMessage = messageObj != null ? StringUtils.trimToNull((String)messageObj.optString("fail")) : null;
        LinkedList<String> ruleIds = new LinkedList<String>();
        for (int i = 0; i < ruleArr.length(); ++i) {
            ruleIds.add(ruleArr.getString(i));
        }
        if (ruleIds.isEmpty()) {
            throw new ValidationException("Property 'rules' must contain at least one value");
        }
        if (ruleIds.stream().distinct().count() != (long)ruleIds.size()) {
            throw new ValidationException("Property 'rules' must contain distinct values");
        }
        GroupDefinition group = new GroupDefinition(id, name, ruleIds);
        group.setEnabled(enabled);
        group.setDescription(description);
        group.setFailsTest(failsTest);
        group.setFailsOn(failsOn);
        group.setMode(source);
        group.setFailMessage(failMessage);
        group.setSuccessMessage(successMessage);
        return group;
    }

    public static class RuleIdConverter
    extends AbstractCollectionConverter {
        public RuleIdConverter(Mapper mapper) {
            super(mapper);
        }

        public boolean canConvert(Class type) {
            return List.class.isAssignableFrom(type);
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
            for (Object o : (List)source) {
                writer.startNode("rule");
                writer.addAttribute("ref-id", Objects.toString(o));
                writer.endNode();
            }
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            return null;
        }
    }

    public static enum Mode {
        firstPassed,
        lastPassed,
        allPassed;

    }
}

