/*
 * Decompiled with CFR 0.152.
 */
package com.xceptance.xlt.mastercontroller;

import com.xceptance.common.lang.ParseNumbers;
import com.xceptance.common.lang.ThrowableUtils;
import com.xceptance.common.util.AbstractConfiguration;
import com.xceptance.xlt.api.util.XltException;
import com.xceptance.xlt.mastercontroller.AbstractLoadFunctionParser;
import com.xceptance.xlt.mastercontroller.DoubleValueLoadFunctionParser;
import com.xceptance.xlt.mastercontroller.IntValueLoadFunctionParser;
import com.xceptance.xlt.mastercontroller.LoadFunctionUtils;
import com.xceptance.xlt.mastercontroller.TestCaseLoadProfileConfiguration;
import com.xceptance.xlt.util.XltPropertiesImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;

public class TestLoadProfileConfiguration
extends AbstractConfiguration {
    private static final String PROP_SUFFIX_ARRIVAL_RATE = ".arrivalRate";
    private static final String PROP_SUFFIX_CLASS = ".class";
    public static final String PROP_SUFFIX_INITIAL_DELAY = ".initialDelay";
    private static final String PROP_SUFFIX_ITERATIONS = ".iterations";
    private static final String PROP_SUFFIX_LOAD_FACTOR = ".loadFactor";
    public static final String PROP_SUFFIX_RAMP_UP_PERIOD = ".rampUpPeriod";
    private static final String PROP_SUFFIX_RAMP_UP_STEADY_PERIOD = ".rampUpSteadyPeriod";
    private static final String PROP_SUFFIX_SHUT_DOWN_PERIOD = ".shutdownPeriod";
    public static final String PROP_SUFFIX_WARM_UP_PERIOD = ".warmUpPeriod";
    private static final String PROP_SUFFIX_MEASUREMENT_PERIOD = ".measurementPeriod";
    private static final String PROP_SUFFIX_USERS = ".users";
    private static final String PROP_SUFFIX_RAMP_UP_STEP_SIZE = ".rampUpStepSize";
    @Deprecated
    private static final String PROP_SUFFIX_RAMP_UP_INITIAL_USERS = ".rampUpInitialUsers";
    private static final String PROP_SUFFIX_RAMP_UP_INITIAL_VALUE = ".rampUpInitialValue";
    @Deprecated
    private static final String PROP_SUFFIX_DURATION = ".duration";
    private static final String PROP_SUFFIX_ISCLIENTPERFTEST = ".clientPerformanceTest";
    private static final String PROP_ACTION_THINK_TIME = "com.xceptance.xlt.thinktime.action";
    private static final String PROP_ACTION_THINK_TIME_DEVIATION = "com.xceptance.xlt.thinktime.action.deviation";
    private static final String PROP_ACTIVE_LOAD_TESTS = "com.xceptance.xlt.loadtests";
    private static final String PROP_PREFIX_LOAD_TESTS = "com.xceptance.xlt.loadtests.";
    public static final String PROP_LOAD_TEST_DEFAULTS = "com.xceptance.xlt.loadtests.default";
    private final Map<String, TestCaseLoadProfileConfiguration> loadTestConfigs;
    private Set<String> activeTestCases;
    private final XltPropertiesImpl xltProperties;

    public static XltPropertiesImpl readProperties(File homeDir, File configDir) {
        try {
            FileSystemManager fsMgr = VFS.getManager();
            FileObject homeDirFO = fsMgr.resolveFile(homeDir.getAbsolutePath());
            FileObject configDirFO = fsMgr.resolveFile(configDir.getAbsolutePath());
            return new XltPropertiesImpl(homeDirFO, configDirFO, false, false);
        }
        catch (FileSystemException fse) {
            throw new IllegalArgumentException("Failed to resolve configuration: " + configDir);
        }
    }

    public TestLoadProfileConfiguration() {
        this.loadTestConfigs = new TreeMap<String, TestCaseLoadProfileConfiguration>();
        this.activeTestCases = new LinkedHashSet<String>();
        this.xltProperties = new XltPropertiesImpl();
    }

    public TestLoadProfileConfiguration(XltPropertiesImpl properties) {
        this.xltProperties = properties;
        this.addProperties(this.xltProperties.getProperties());
        this.loadTestConfigs = this.readLoadTestCaseConfiguration();
    }

    protected TestLoadProfileConfiguration(TestLoadProfileConfiguration source, String testCaseName) {
        this.xltProperties = new XltPropertiesImpl();
        this.loadTestConfigs = new HashMap<String, TestCaseLoadProfileConfiguration>();
        TestCaseLoadProfileConfiguration config = source.loadTestConfigs.get(testCaseName);
        if (config != null) {
            this.loadTestConfigs.put(testCaseName, config);
        }
    }

    public void addTestCaseLoadProfileConfiguration(TestCaseLoadProfileConfiguration testCaseLoadProfileConfiguration) {
        this.loadTestConfigs.put(testCaseLoadProfileConfiguration.getUserName(), testCaseLoadProfileConfiguration);
    }

    public TestLoadProfileConfiguration getTestLoadProfileConfiguration(String testCaseName) {
        return new TestLoadProfileConfiguration(this, testCaseName);
    }

    public Set<String> getActiveTestCaseNames() {
        return this.activeTestCases;
    }

    public List<TestCaseLoadProfileConfiguration> getLoadTestConfiguration() {
        return new ArrayList<TestCaseLoadProfileConfiguration>(this.loadTestConfigs.values());
    }

    public long getTotalRampUpPeriod() {
        long maxRampUpOffset = 0L;
        long smallestInitialDelay = Long.MAX_VALUE;
        for (TestCaseLoadProfileConfiguration loadProfile : this.getLoadTestConfiguration()) {
            int initialDelay = loadProfile.getInitialDelay();
            int rampUpPeriod = loadProfile.getRampUpPeriod();
            if (rampUpPeriod > 0) {
                maxRampUpOffset = Math.max(maxRampUpOffset, (long)(initialDelay + rampUpPeriod));
            }
            smallestInitialDelay = Math.min(smallestInitialDelay, (long)initialDelay);
        }
        return Math.max(0L, maxRampUpOffset - smallestInitialDelay);
    }

    private Map<String, TestCaseLoadProfileConfiguration> readLoadTestCaseConfiguration() {
        TreeMap<String, TestCaseLoadProfileConfiguration> configs = new TreeMap<String, TestCaseLoadProfileConfiguration>();
        DefaultTestCaseLoadProfileConfiguration defaultTestCaseConfig = this.getDefaultTestCaseLoadProfileConfiguration();
        String activeTestCasesPropertyValue = this.getStringProperty(PROP_ACTIVE_LOAD_TESTS, "");
        String[] activeTestCaseNames = StringUtils.split((String)activeTestCasesPropertyValue, (String)" ,;");
        this.activeTestCases = new LinkedHashSet<String>();
        this.configure(activeTestCaseNames, configs, defaultTestCaseConfig);
        return configs;
    }

    private DefaultTestCaseLoadProfileConfiguration getDefaultTestCaseLoadProfileConfiguration() {
        this.checkForOutdatedProperties(PROP_LOAD_TEST_DEFAULTS);
        String defaultClassName = this.getStringProperty("com.xceptance.xlt.loadtests.default.class", null);
        int defaultWarmUpPeriod = this.getTimePeriodProperty("com.xceptance.xlt.loadtests.default.warmUpPeriod", 0);
        int defaultMeasurementPeriod = this.getTimePeriodProperty("com.xceptance.xlt.loadtests.default.measurementPeriod", 0);
        int defaultRampUpPeriod = this.getTimePeriodProperty("com.xceptance.xlt.loadtests.default.rampUpPeriod", -1);
        int defaultRampUpSteadyPeriod = this.getTimePeriodProperty("com.xceptance.xlt.loadtests.default.rampUpSteadyPeriod", -1);
        int defaultShutdownPeriod = this.getTimePeriodProperty("com.xceptance.xlt.loadtests.default.shutdownPeriod", 0);
        int defaultIterations = this.getIntProperty("com.xceptance.xlt.loadtests.default.iterations", 0);
        int defaultInitialDelay = this.getTimePeriodProperty("com.xceptance.xlt.loadtests.default.initialDelay", 0);
        int defaultRampUpStepSize = this.getIntProperty("com.xceptance.xlt.loadtests.default.rampUpStepSize", -1);
        int defaultRampUpInitialValue = this.getIntProperty("com.xceptance.xlt.loadtests.default.rampUpInitialValue", -1);
        int[][] defaultLoadFactor = this.getDoubleLoadFunction("com.xceptance.xlt.loadtests.default.loadFactor", null);
        int[][] defaultUsers = this.getLoadFunction("com.xceptance.xlt.loadtests.default.users", null);
        int[][] defaultArrivalRate = this.getLoadFunction("com.xceptance.xlt.loadtests.default.arrivalRate", null);
        int defaultActionThinkTime = this.getIntProperty(PROP_ACTION_THINK_TIME, 0);
        int defaultActionThinkTimeDeviation = this.getIntProperty(PROP_ACTION_THINK_TIME_DEVIATION, 0);
        DefaultTestCaseLoadProfileConfiguration defaultConfig = new DefaultTestCaseLoadProfileConfiguration();
        defaultConfig.setTestCaseClassName(defaultClassName);
        defaultConfig.setWarmUpPeriod(defaultWarmUpPeriod);
        defaultConfig.setMeasurementPeriod(defaultMeasurementPeriod);
        defaultConfig.setRampUpPeriod(defaultRampUpPeriod);
        defaultConfig.setRampUpSteadyPeriod(defaultRampUpSteadyPeriod);
        defaultConfig.setShutdownPeriod(defaultShutdownPeriod);
        defaultConfig.setNumberOfIterations(defaultIterations);
        defaultConfig.setInitialDelay(defaultInitialDelay);
        defaultConfig.setRampUpStepSize(defaultRampUpStepSize);
        defaultConfig.setRampUpInitialValue(defaultRampUpInitialValue);
        defaultConfig.setLoadFactor(defaultLoadFactor);
        defaultConfig.setNumberOfUsers(defaultUsers);
        defaultConfig.setArrivalRate(defaultArrivalRate);
        defaultConfig.setActionThinkTime(defaultActionThinkTime);
        defaultConfig.setActionThinkTimeDeviation(defaultActionThinkTimeDeviation);
        return defaultConfig;
    }

    private void configure(String[] testCaseNames, Map<String, TestCaseLoadProfileConfiguration> configurations, DefaultTestCaseLoadProfileConfiguration defaultConfiguration) {
        for (String testCaseName : testCaseNames) {
            this.activeTestCases.add(testCaseName);
            String propertyName = PROP_PREFIX_LOAD_TESTS + testCaseName;
            this.checkForOutdatedProperties(propertyName);
            String className = this.getStringProperty(propertyName + PROP_SUFFIX_CLASS, defaultConfiguration.getTestCaseClassName());
            int iterations = this.getIntProperty(propertyName + PROP_SUFFIX_ITERATIONS, defaultConfiguration.getNumberOfIterations());
            int warmUpPeriod = this.getTimePeriodProperty(propertyName + PROP_SUFFIX_WARM_UP_PERIOD, defaultConfiguration.getWarmUpPeriod());
            int shutdownPeriod = this.getTimePeriodProperty(propertyName + PROP_SUFFIX_SHUT_DOWN_PERIOD, defaultConfiguration.getShutdownPeriod());
            int measurementPeriod = this.getTimePeriodProperty(propertyName + PROP_SUFFIX_MEASUREMENT_PERIOD, defaultConfiguration.getMeasurementPeriod());
            int rampUpPeriod = this.getTimePeriodProperty(propertyName + PROP_SUFFIX_RAMP_UP_PERIOD, defaultConfiguration.getRampUpPeriod());
            int rampUpSteadyPeriod = this.getTimePeriodProperty(propertyName + PROP_SUFFIX_RAMP_UP_STEADY_PERIOD, defaultConfiguration.getRampUpSteadyPeriod());
            int initialDelay = this.getTimePeriodProperty(propertyName + PROP_SUFFIX_INITIAL_DELAY, defaultConfiguration.getInitialDelay());
            int rampUpStepSize = this.getIntProperty(propertyName + PROP_SUFFIX_RAMP_UP_STEP_SIZE, defaultConfiguration.getRampUpStepSize());
            int rampUpInitialValue = this.getIntProperty(propertyName + PROP_SUFFIX_RAMP_UP_INITIAL_VALUE, defaultConfiguration.getRampUpInitialValue());
            int[][] loadFactor = this.getDoubleLoadFunction(propertyName + PROP_SUFFIX_LOAD_FACTOR, defaultConfiguration.getLoadFactor());
            int[][] users = this.getLoadFunction(propertyName + PROP_SUFFIX_USERS, defaultConfiguration.getNumberOfUsers());
            int[][] arrivalRate = this.getLoadFunction(propertyName + PROP_SUFFIX_ARRIVAL_RATE, defaultConfiguration.getArrivalRate());
            boolean isCPTest = this.getBooleanProperty(propertyName + PROP_SUFFIX_ISCLIENTPERFTEST, false);
            int actionThinkTime = this.xltProperties.getProperty(className, testCaseName, PROP_ACTION_THINK_TIME).flatMap(ParseNumbers::parseOptionalInt).orElse(defaultConfiguration.getActionThinkTime());
            int actionThinkTimeDeviation = this.xltProperties.getProperty(className, testCaseName, PROP_ACTION_THINK_TIME_DEVIATION).flatMap(ParseNumbers::parseOptionalInt).orElse(defaultConfiguration.getActionThinkTimeDeviation());
            if (className == null || className.isBlank()) {
                throw new XltException("No test class specified for test case '" + testCaseName + "'.");
            }
            if (measurementPeriod == 0) {
                throw new XltException("No measurement period specified for test case '" + testCaseName + "'.");
            }
            if (users == null) {
                throw new XltException("Number of users not specified for test case '" + testCaseName + "'.");
            }
            if (arrivalRate != null) {
                if (LoadFunctionUtils.isComplexLoadFunction(users)) {
                    throw new XltException("Both a complex user function and an arrival rate are specified for test case '" + testCaseName + "', but they cannot be used together.");
                }
                if (iterations != 0) {
                    throw new XltException("Both number of iterations and arrival rate are specified for test case '" + testCaseName + "', but they cannot be used together.");
                }
            }
            if (loadFactor != null && LoadFunctionUtils.isComplexLoadFunction(loadFactor)) {
                if (LoadFunctionUtils.isComplexLoadFunction(users)) {
                    throw new XltException("Both a complex user function and a complex load factor function are specified for test case '" + testCaseName + "', but only one of them can be complex.");
                }
                if (arrivalRate != null && LoadFunctionUtils.isComplexLoadFunction(arrivalRate)) {
                    throw new XltException("Both a complex arrival rate function and a complex load factor function are specified for test case '" + testCaseName + "', but only one of them can be complex.");
                }
            }
            arrivalRate = LoadFunctionUtils.scaleLoadFunction(arrivalRate, loadFactor);
            users = LoadFunctionUtils.scaleLoadFunction(users, loadFactor);
            int[][] complexLoadFunction = null;
            if (arrivalRate != null && LoadFunctionUtils.isComplexLoadFunction(arrivalRate)) {
                complexLoadFunction = arrivalRate;
            } else if (LoadFunctionUtils.isComplexLoadFunction(users)) {
                complexLoadFunction = users;
            }
            if (complexLoadFunction != null) {
                rampUpPeriod = -1;
            } else if (arrivalRate == null) {
                int rampUpTargetValue = users[0][1];
                users = LoadFunctionUtils.computeLoadFunction(rampUpInitialValue, rampUpTargetValue, rampUpPeriod, rampUpStepSize, rampUpSteadyPeriod);
            } else {
                int rampUpTargetValue = arrivalRate[0][1];
                arrivalRate = LoadFunctionUtils.computeLoadFunction(rampUpInitialValue, rampUpTargetValue, rampUpPeriod, rampUpStepSize, rampUpSteadyPeriod);
            }
            TestCaseLoadProfileConfiguration config = new TestCaseLoadProfileConfiguration();
            config.setTestCaseClassName(className);
            config.setArrivalRate(arrivalRate);
            config.setNumberOfUsers(users);
            config.setNumberOfIterations(iterations);
            config.setShutdownPeriod(shutdownPeriod);
            config.setWarmUpPeriod(warmUpPeriod);
            config.setMeasurementPeriod(measurementPeriod);
            config.setInitialDelay(initialDelay);
            config.setUserName(testCaseName);
            config.setComplexLoadFunction(complexLoadFunction);
            config.setRampUpPeriod(rampUpPeriod);
            config.setLoadFactor(loadFactor);
            config.setCPTest(isCPTest);
            config.setActionThinkTime(actionThinkTime);
            config.setActionThinkTimeDeviation(actionThinkTimeDeviation);
            configurations.put(testCaseName, config);
        }
    }

    private void checkForOutdatedProperties(String propertyPrefix) throws XltException {
        String message = "Property '%s' is not supported any longer. Please remove it and use '%s' instead.";
        String propertyName = propertyPrefix + PROP_SUFFIX_DURATION;
        if (this.getStringProperty(propertyName, null) != null) {
            throw new XltException(String.format("Property '%s' is not supported any longer. Please remove it and use '%s' instead.", propertyName, propertyPrefix + PROP_SUFFIX_MEASUREMENT_PERIOD));
        }
        propertyName = propertyPrefix + PROP_SUFFIX_RAMP_UP_INITIAL_USERS;
        if (this.getStringProperty(propertyName, null) != null) {
            throw new XltException(String.format("Property '%s' is not supported any longer. Please remove it and use '%s' instead.", propertyName, propertyPrefix + PROP_SUFFIX_RAMP_UP_INITIAL_VALUE));
        }
    }

    private int[][] getLoadFunction(String propertyName, int[][] defaultValues) {
        String propertyValue = null;
        try {
            propertyValue = this.getStringProperty(propertyName);
        }
        catch (RuntimeException e) {
            return defaultValues;
        }
        Object loadFunction = null;
        IntValueLoadFunctionParser parser = new IntValueLoadFunctionParser();
        try {
            loadFunction = parser.parse(propertyValue);
        }
        catch (Exception e) {
            try {
                int value = ((AbstractLoadFunctionParser)parser).parseValue(propertyValue);
                loadFunction = new int[][]{{0, value}};
            }
            catch (Exception e2) {
                throw new IllegalArgumentException(String.format("The value '%s' of property '%s' can neither be parsed as simple integer, nor as load function.", propertyValue, propertyName));
            }
        }
        try {
            LoadFunctionUtils.checkLoadFunction(loadFunction);
        }
        catch (IllegalArgumentException e) {
            ThrowableUtils.setMessage(e, String.format("The property '%s' does not specify a valid load function: %s", propertyName, e.getMessage()));
            throw e;
        }
        loadFunction = LoadFunctionUtils.completeLoadFunctionIfNecessary(loadFunction);
        return loadFunction;
    }

    private int[][] getDoubleLoadFunction(String propertyName, int[][] defaultValues) {
        String propertyValue = null;
        try {
            propertyValue = this.getStringProperty(propertyName);
        }
        catch (RuntimeException e) {
            return defaultValues;
        }
        Object loadFunction = null;
        DoubleValueLoadFunctionParser parser = new DoubleValueLoadFunctionParser();
        try {
            loadFunction = parser.parse(propertyValue);
        }
        catch (Exception e) {
            try {
                int value = ((AbstractLoadFunctionParser)parser).parseValue(propertyValue);
                loadFunction = new int[][]{{0, value}};
            }
            catch (Exception e2) {
                throw new IllegalArgumentException(String.format("The value '%s' of property '%s' can neither be parsed as simple double, nor as load function.", propertyValue, propertyName));
            }
        }
        try {
            LoadFunctionUtils.checkLoadFunction(loadFunction);
        }
        catch (IllegalArgumentException e) {
            ThrowableUtils.setMessage(e, String.format("The property '%s' does not specify a valid load function: %s", propertyName, e.getMessage()));
            throw e;
        }
        loadFunction = LoadFunctionUtils.completeLoadFunctionIfNecessary(loadFunction);
        return loadFunction;
    }

    private static class DefaultTestCaseLoadProfileConfiguration
    extends TestCaseLoadProfileConfiguration {
        private int rampUpSteadyPeriod;
        private int rampUpInitialValue;
        private int rampUpStepSize;

        private DefaultTestCaseLoadProfileConfiguration() {
        }

        public void setRampUpSteadyPeriod(int defaultRampUpSteadyPeriod) {
            this.rampUpSteadyPeriod = defaultRampUpSteadyPeriod;
        }

        public void setRampUpInitialValue(int defaultRampUpInitialValue) {
            this.rampUpInitialValue = defaultRampUpInitialValue;
        }

        public void setRampUpStepSize(int defaultRampUpStepSize) {
            this.rampUpStepSize = defaultRampUpStepSize;
        }

        public final int getRampUpSteadyPeriod() {
            return this.rampUpSteadyPeriod;
        }

        public final int getRampUpInitialValue() {
            return this.rampUpInitialValue;
        }

        public final int getRampUpStepSize() {
            return this.rampUpStepSize;
        }
    }
}

